<?php

namespace Drupal\awareness\Event;

use Symfony\Component\EventDispatcher\EventDispatcherInterface;

/**
 * Trait for classes that utilize event_dispatcher service.
 */
trait EventDispatcherAwareTrait {

  /**
   * The event dispatcher.
   *
   * @var \Symfony\Component\EventDispatcher\EventDispatcherInterface
   */
  protected $eventDispatcher;

  /**
   * @see \Drupal\awareness\Event\EventDispatcherAwareInterface::setEventDispatcher
   */
  public function setEventDispatcher(EventDispatcherInterface $eventDispatcher) {
    $this->eventDispatcher = $eventDispatcher;
    return $this;
  }

}
