<?php

namespace Drupal\awareness\Extension;

use Drupal\Core\Theme\ThemeManagerInterface;

/**
 * Interface for classes that utilize theme.manager service.
 */
interface ThemeManagerAwareInterface {

  const SERVICE_ID = 'theme.manager';

  /**
   * Set the theme manager.
   *
   * @param \Drupal\Core\Theme\ThemeManagerInterface $themeManager
   *   The theme manager service.
   *
   * @return $this
   */
  public function setThemeManager(ThemeManagerInterface $themeManager);

}
