<?php

namespace Drupal\awareness\Extension;

use Drupal\Core\Theme\ThemeManagerInterface;

/**
 * Trait for classes that utilize theme.manager service.
 */
trait ThemeManagerAwareTrait {

  /**
   * The theme manager service.
   *
   * @var \Drupal\Core\Theme\ThemeManagerInterface
   */
  protected $themeManager;

  /**
   * @see \Drupal\awareness\Extension\ThemeManagerAwareInterface::setThemeHandler
   */
  public function setThemeManager(ThemeManagerInterface $themeManager) {
    $this->themeManager = $themeManager;
    return $this;
  }

}
