<?php

namespace Drupal\awareness\File;

use Drupal\file\FileRepositoryInterface;

/**
 * Interface for classes that utilize file.repository service.
 */
interface FileRepositoryAwareInterface {

  const SERVICE_ID = 'file.repository';

  /**
   * Set the file repository service.
   *
   * @param \Drupal\file\FileRepositoryInterface $fileRepository
   *   The file repository service.
   *
   * @return $this
   */
  public function setFileRepository(FileRepositoryInterface $fileRepository);

}
