<?php

namespace Drupal\awareness\File;

use Drupal\file\FileRepositoryInterface;

/**
 * Trait for classes that utilize file.repository service.
 */
trait FileRepositoryAwareTrait {

  /**
   * The file repository service.
   *
   * @var \Drupal\file\FileRepositoryInterface
   */
  protected $fileRepository;

  /**
   * @see \Drupal\awareness\File\FileRepositoryAwareInterface::setFileRepository
   */
  public function setFileRepository(FileRepositoryInterface $fileRepository) {
    $this->fileRepository = $fileRepository;
    return $this;
  }

}
