<?php

namespace Drupal\awareness\File;

use Drupal\Core\File\FileSystemInterface;

/**
 * Interface for classes that utilize file_system service.
 */
interface FileSystemAwareInterface {

  const SERVICE_ID = 'file_system';

  /**
   * Set the file system service.
   *
   * @param \Drupal\Core\File\FileSystemInterface $fileSystem
   *   The file system service.
   *
   * @return $this
   */
  public function setFileSystem(FileSystemInterface $fileSystem);

}
