<?php

namespace Drupal\awareness\File;

use Drupal\Core\File\FileUrlGeneratorInterface;

/**
 * Interface for classes that utilize the file_url_generator service.
 */
interface FileUrlGeneratorAwareInterface {

  const SERVICE_ID = 'file_url_generator';

  /**
   * Set the file URL generator service.
   *
   * @param \Drupal\Core\File\FileUrlGeneratorInterface $fileUrlGenerator
   *   The file URL generator service.
   *
   * @return $this
   */
  public function setFileUrlGenerator(FileUrlGeneratorInterface $fileUrlGenerator);

}
