<?php

namespace Drupal\awareness\File;

use Drupal\Core\File\FileUrlGeneratorInterface;

/**
 * Trait for classes that utilize the file_url_generator service.
 */
trait FileUrlGeneratorAwareTrait {

  /**
   * The file URL generator service.
   *
   * @var \Drupal\Core\File\FileUrlGeneratorInterface
   */
  protected $fileUrlGenerator;

  /**
   * @see \Drupal\awareness\File\FileUrlGeneratorAwareInterface::setFileUrlGenerator
   */
  public function setFileUrlGenerator(FileUrlGeneratorInterface $fileUrlGenerator) {
    $this->fileUrlGenerator = $fileUrlGenerator;
    return $this;
  }

}
