<?php

namespace Drupal\awareness\Form;

use Drupal\Core\Form\FormBuilderInterface;

/**
 * Interface for classes that utilize form_builder service.
 */
interface FormBuilderAwareInterface {

  const SERVICE_ID = 'form_builder';

  /**
   * Set the form builder.
   *
   * @param \Drupal\Core\Form\FormBuilderInterface $formBuilder
   *   The form builder service.
   *
   * @return $this
   */
  public function setFormBuilder(FormBuilderInterface $formBuilder);

}
