<?php

namespace Drupal\awareness\Form;

use Drupal\Core\Form\FormBuilderInterface;

/**
 * Trait for classes that utilize form_builder service.
 */
trait FormBuilderAwareTrait {

  /**
   * The form builder service.
   *
   * @var \Drupal\Core\Form\FormBuilderInterface
   */
  protected $formBuilder;

  /**
   * @see \Drupal\awareness\Form\FormBuilderAwareInterface::setFormBuilder
   */
  public function setFormBuilder(FormBuilderInterface $formBuilder) {
    $this->formBuilder = $formBuilder;
    return $this;
  }

}
