<?php

namespace Drupal\awareness\Http;

use Drupal\Core\Http\ClientFactory;

/**
 * Interface for classes that utilize the http_client_factory service.
 */
interface HttpClientFactoryAwareInterface {

  const SERVICE_ID = 'http_client_factory';

  /**
   * Set the HTTP client factory service.
   *
   * @param \Drupal\Core\Http\ClientFactory $httpClientFactory
   *   The HTTP client factory service.
   *
   * @return $this
   */
  public function setHttpClientFactory(ClientFactory $httpClientFactory);

}
