<?php

namespace Drupal\awareness\Queue;

use Drupal\Core\Queue\QueueFactory;

/**
 * Trait for classes that utilize queue service.
 */
trait QueueFactoryAwareTrait {

  /**
   * The queue factory.
   *
   * @var \Drupal\Core\Queue\QueueFactory
   */
  protected $queueFactory;

  /**
   * @see \Drupal\awareness\Queue\QueueFactoryAwareInterface::setQueueFactory
   */
  public function setQueueFactory(QueueFactory $queueFactory) {
    $this->queueFactory = $queueFactory;
    return $this;
  }

}
