<?php

namespace Drupal\awareness\Queue;

use Drupal\Core\Queue\QueueWorkerManagerInterface;

/**
 * Interface for classes that utilize plugin.manager.queue_worker service.
 */
interface QueueWorkerManagerAwareInterface {

  const SERVICE_ID = 'plugin.manager.queue_worker';

  /**
   * Set the queue worker manager.
   *
   * @param \Drupal\Core\Queue\QueueWorkerManagerInterface $queueWorkerManager
   *   The queue worker manager.
   *
   * @return $this
   */
  public function setQueueWorkerManager(QueueWorkerManagerInterface $queueWorkerManager);

}
