<?php

namespace Drupal\awareness\Queue;

use Drupal\Core\Queue\QueueWorkerManagerInterface;

/**
 * Trait for classes that utilize plugin.manager.queue_worker service.
 */
trait QueueWorkerManagerAwareTrait {

  /**
   * The queue worker manager service.
   *
   * @var \Drupal\Core\Queue\QueueWorkerManagerInterface
   */
  protected $queueWorkerManager;

  /**
   * @see \Drupal\awareness\Queue\QueueWorkerManagerAwareInterface::setQueueWorkerManager
   */
  public function setQueueWorkerManager(QueueWorkerManagerInterface $queueWorkerManager) {
    $this->queueWorkerManager = $queueWorkerManager;
    return $this;
  }

}
