<?php

namespace Drupal\awareness\Routing;

use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Interface for classes that utilize the current_route_match service.
 */
interface RouteMatchAwareInterface {

  const SERVICE_ID = 'current_route_match';

  /**
   * Set the current route match.
   *
   * @param \Drupal\Core\Routing\RouteMatchInterface $routeMatch
   *   The current route match service.
   *
   * @return $this
   */
  public function setRouteMatch(RouteMatchInterface $routeMatch);

}
