<?php

namespace Drupal\awareness\TempStore;

use Drupal\Core\TempStore\PrivateTempStoreFactory;

/**
 * Interface for classes that utilize the tempstore.private service.
 */
interface PrivateTempStoreFactoryAwareInterface {

  const SERVICE_ID = 'tempstore.private';

  /**
   * Set the private temporary storage factory service.
   *
   * @param \Drupal\Core\TempStore\PrivateTempStoreFactory $privateTempStoreFactory
   *   The private temporary storage factory service.
   *
   * @return $this
   */
  public function setPrivateTempStoreFactory(PrivateTempStoreFactory $privateTempStoreFactory);

}
