<?php

namespace Drupal\awareness\TempStore;

use Drupal\Core\TempStore\PrivateTempStoreFactory;

/**
 * Trait for classes that utilize the tempstore.private service.
 */
trait PrivateTempStoreFactoryAwareTrait {

  /**
   * The private temporary storage factory service.
   *
   * @var \Drupal\Core\TempStore\PrivateTempStoreFactory
   */
  protected $privateTempStoreFactory;

  /**
   * @see \Drupal\awareness\TempStore\PrivateTempStoreFactoryAwareInterface::setPrivateTempStoreFactory
   */
  public function setPrivateTempStoreFactory(PrivateTempStoreFactory $privateTempStoreFactory) {
    $this->privateTempStoreFactory = $privateTempStoreFactory;
    return $this;
  }

}
