<?php

namespace Drupal\awareness\TempStore;

use Drupal\Core\TempStore\SharedTempStoreFactory;

/**
 * Interface for classes that utilize the tempstore.shared service.
 */
interface SharedTempStoreFactoryInterface {

  const SERVICE_ID = 'tempstore.shared';

  /**
   * Set the shared temporary storage factory service.
   *
   * @param \Drupal\Core\TempStore\SharedTempStoreFactory $sharedTempStoreFactory
   *   The shared temporary storage factory service.
   *
   * @return $this
   */
  public function setSharedTempStoreFactory(SharedTempStoreFactory $sharedTempStoreFactory);

}
