<?php

namespace Drupal\awareness\TempStore;

use Drupal\Core\TempStore\SharedTempStoreFactory;

/**
 * Trait for classes that utilize the tempstore.shared service.
 */
trait SharedTempStoreFactoryTrait {

  /**
   * The shared temporary storage factory service.
   *
   * @var \Drupal\Core\TempStore\SharedTempStoreFactory
   */
  protected $sharedTempStoreFactory;

  /**
   * @see \Drupal\awareness\TempStore\SharedTempStoreFactoryInterface::setSharedTempStoreFactory
   */
  public function setSharedTempStoreFactory(SharedTempStoreFactory $sharedTempStoreFactory) {
    $this->sharedTempStoreFactory = $sharedTempStoreFactory;
    return $this;
  }

}
