<?php

namespace Drupal\awareness\DateTime;

use Drupal\Core\Datetime\DateFormatterInterface;

/**
 * Interface for classes that utilize date.formatter service.
 */
interface DateFormatterAwareInterface {

  const SERVICE_ID = 'date.formatter';

  /**
   * Set the date formatter service.
   *
   * @param \Drupal\Core\Datetime\DateFormatterInterface $dateFormatter
   *   The date formatter service.
   *
   * @return $this
   */
  public function setDateFormatter(DateFormatterInterface $dateFormatter);

}
