<?php

namespace Drupal\awareness\Render;

use Drupal\Core\Render\RendererInterface;

/**
 * Trait for classes that utilize renderer service.
 */
trait RendererAwareTrait {

  /**
   * The renderer service.
   *
   * @var \Drupal\Core\Render\RendererInterface
   */
  protected $renderer;

  /**
   * @see \Drupal\awareness\Render\RendererAwareInterface::setRenderer
   */
  public function setRenderer(RendererInterface $renderer) {
    $this->renderer = $renderer;
    return $this;
  }

}
