<?php

namespace Drupal\Tests\awareness\Kernel;

use Drupal\awareness\Layout\LayoutPluginManagerAwareTrait;
use Drupal\Component\Uuid\UuidInterface;
use Drupal\Component\Utility\EmailValidatorInterface;
use Drupal\Core\Layout\LayoutPluginManagerInterface;
use Drupal\file\FileRepositoryInterface;
use Drupal\user\UserDataInterface;
use Drupal\Component\Transliteration\TransliterationInterface;
use Drupal\Core\Utility\Token;
use Drupal\Core\TempStore\SharedTempStoreFactory;
use Drupal\Core\TempStore\PrivateTempStoreFactory;
use Drupal\awareness\Cache\CacheFactoryAwareTrait;
use Drupal\awareness\Cache\MemoryCache\EntityMemoryCacheAwareTrait;
use Drupal\awareness\Config\ConfigFactoryAwareTrait;
use Drupal\awareness\Context\ContextRespositoryAwareTrait;
use Drupal\awareness\Controller\ControllerResolverAwareTrait;
use Drupal\awareness\Database\DatabaseAwareTrait;
use Drupal\awareness\DateTime\DateFormatterAwareTrait;
use Drupal\awareness\DateTime\TimeAwareTrait;
use Drupal\awareness\Event\EventDispatcherAwareTrait;
use Drupal\awareness\Extension\ModuleHandlerAwareTrait;
use Drupal\awareness\Extension\ThemeManagerAwareTrait;
use Drupal\awareness\File\FileRepositoryAwareTrait;
use Drupal\awareness\File\FileSystemAwareTrait;
use Drupal\awareness\File\FileUrlGeneratorAwareTrait;
use Drupal\awareness\Form\FormBuilderAwareTrait;
use Drupal\awareness\Http\HttpClientAwareTrait;
use Drupal\awareness\Http\HttpClientFactoryAwareTrait;
use Drupal\awareness\KeyValue\KeyValueExpirableFactoryAwareTrait;
use Drupal\awareness\KeyValue\KeyValueFactoryAwareTrait;
use Drupal\awareness\Lock\LockAwareTrait;
use Drupal\awareness\Mail\MailPluginManagerAwareTrait;
use Drupal\awareness\Mime\FileMimeTypeGuesserAwareTrait;
use Drupal\awareness\Pager\PagerManagerAwareTrait;
use Drupal\awareness\Password\PasswordGeneratorAwareTrait;
use Drupal\awareness\Queue\QueueFactoryAwareTrait;
use Drupal\awareness\Queue\QueueWorkerManagerAwareTrait;
use Drupal\awareness\Render\RendererAwareTrait;
use Drupal\awareness\Request\RequestStackAwareTrait;
use Drupal\awareness\Routing\RedirectDestinationAwareTrait;
use Drupal\awareness\Routing\RouteMatchAwareTrait;
use Drupal\awareness\Session\CurrentUserAwareTrait;
use Drupal\awareness\Settings\SettingsAwareTrait;
use Drupal\awareness\State\StateAwareTrait;
use Drupal\awareness\StreamWrapper\StreamWrapperManagerAwareTrait;
use Drupal\awareness\TempStore\PrivateTempStoreFactoryAwareTrait;
use Drupal\awareness\TempStore\SharedTempStoreFactoryTrait;
use Drupal\awareness\Token\TokenAwareTrait;
use Drupal\awareness\Transliteration\TransliterationAwareTrait;
use Drupal\awareness\User\UserDataAwareTrait;
use Drupal\awareness\Utility\EmailValidatorAwareTrait;
use Drupal\awareness\Uuid\UuidAwareTrait;
use Drupal\Component\Datetime\TimeInterface;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Cache\MemoryCache\MemoryCacheInterface;
use Drupal\Core\Config\Config;
use Drupal\Core\Config\ImmutableConfig;
use Drupal\Core\Controller\ControllerResolverInterface;
use Drupal\Core\Database\Connection;
use Drupal\Core\Datetime\DateFormatterInterface;
use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityFormBuilderInterface;
use Drupal\Core\Entity\EntityRepositoryInterface;
use Drupal\Core\Entity\EntityTypeBundleInfoInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\Core\File\FileSystemInterface;
use Drupal\Core\File\FileUrlGeneratorInterface;
use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Http\ClientFactory;
use Drupal\Core\KeyValueStore\KeyValueExpirableFactoryInterface;
use Drupal\Core\KeyValueStore\KeyValueFactoryInterface;
use Drupal\Core\Lock\LockBackendInterface;
use Drupal\Core\Mail\MailManagerInterface;
use Drupal\Core\Pager\PagerManagerInterface;
use Drupal\Core\Password\PasswordGeneratorInterface;
use Drupal\Core\Plugin\Context\ContextRepositoryInterface;
use Drupal\awareness\Entity\EntityFieldManagerAwareTrait;
use Drupal\awareness\Entity\EntityFormBuilderAwareTrait;
use Drupal\awareness\Entity\EntityRepositoryAwareTrait;
use Drupal\awareness\Entity\EntityTypeBundleInfoAwareTrait;
use Drupal\awareness\Entity\EntityTypeManagerAwareTrait;
use Drupal\Core\Queue\QueueFactory;
use Drupal\Core\Queue\QueueWorkerManagerInterface;
use Drupal\Core\Render\RendererInterface;
use Drupal\Core\Routing\RedirectDestinationInterface;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Session\AccountProxyInterface;
use Drupal\Core\Site\Settings;
use Drupal\Core\State\StateInterface;
use Drupal\Core\StreamWrapper\StreamWrapperManagerInterface;
use Drupal\Core\Theme\ThemeManagerInterface;
use Drupal\KernelTests\KernelTestBase;
use GuzzleHttp\Client;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Mime\MimeTypeGuesserInterface;

/**
 * Test awareness traits.
 *
 * @group awareness
 */
class AwarenessKernelTest extends KernelTestBase {

  use CacheFactoryAwareTrait;
  use ConfigFactoryAwareTrait;
  use ContextRespositoryAwareTrait;
  use ControllerResolverAwareTrait;
  use CurrentUserAwareTrait;
  use DatabaseAwareTrait;
  use DateFormatterAwareTrait;
  use EmailValidatorAwareTrait;
  use EntityFieldManagerAwareTrait;
  use EntityFormBuilderAwareTrait;
  use EntityMemoryCacheAwareTrait;
  use EntityRepositoryAwareTrait;
  use EntityTypeBundleInfoAwareTrait;
  use EntityTypeManagerAwareTrait;
  use EventDispatcherAwareTrait;
  use FileRepositoryAwareTrait;
  use FileSystemAwareTrait;
  use FileUrlGeneratorAwareTrait;
  use FormBuilderAwareTrait;
  use HttpClientAwareTrait;
  use HttpClientFactoryAwareTrait;
  use KeyValueExpirableFactoryAwareTrait;
  use KeyValueFactoryAwareTrait;
  use LockAwareTrait;
  use MailPluginManagerAwareTrait;
  use FileMimeTypeGuesserAwareTrait;
  use LayoutPluginManagerAwareTrait;
  use ModuleHandlerAwareTrait;
  use PagerManagerAwareTrait;
  use PasswordGeneratorAwareTrait;
  use PrivateTempStoreFactoryAwareTrait;
  use QueueFactoryAwareTrait;
  use QueueWorkerManagerAwareTrait;
  use RendererAwareTrait;
  use RequestStackAwareTrait;
  use RedirectDestinationAwareTrait;
  use RouteMatchAwareTrait;
  use SettingsAwareTrait;
  use SharedTempStoreFactoryTrait;
  use StateAwareTrait;
  use StreamWrapperManagerAwareTrait;
  use TokenAwareTrait;
  use TransliterationAwareTrait;
  use TimeAwareTrait;
  use ThemeManagerAwareTrait;
  use UserDataAwareTrait;
  use UuidAwareTrait;

  /**
   * Test cache traits.
   */
  public function testCache() {
    $this->assertInstanceOf(CacheBackendInterface::class, $this->getCacheBin());
    $this->assertInstanceOf(MemoryCacheInterface::class, $this->getEntityMemoryCache());
  }

  /**
   * Test config traits.
   */
  public function testConfig() {
    $this->assertInstanceOf(ImmutableConfig::class, $this->getConfig('system.site'));
    $this->assertInstanceOf(Config::class, $this->getEditableConfig('system.site'));
  }

  /**
   * Test context traits.
   */
  public function testContext() {
    $this->assertInstanceOf(ContextRepositoryInterface::class, $this->getContextRepository());
  }

  /**
   * Test controller traits.
   */
  public function testController() {
    $this->assertInstanceOf(ControllerResolverInterface::class, $this->getControllerResolver());
  }

  /**
   * Test database traits.
   */
  public function testDatabase() {
    $this->assertInstanceOf(Connection::class, $this->getDatabase());
  }

  /**
   * Test date/time traits.
   */
  public function testDatetime() {
    $this->assertInstanceOf(DateFormatterInterface::class, $this->getDateFormatter());
    $this->assertInstanceOf(TimeInterface::class, $this->getTime());
  }

  /**
   * Test entity traits.
   */
  public function testEntity() {
    $this->assertInstanceOf(EntityFieldManagerInterface::class, $this->getEntityFieldManager());
    $this->assertInstanceOf(EntityFormBuilderInterface::class, $this->getEntityFormBuilder());
    $this->assertInstanceOf(EntityRepositoryInterface::class, $this->getEntityRepository());
    $this->assertInstanceOf(EntityTypeBundleInfoInterface::class, $this->getEntityTypeBundleInfo());
    $this->assertInstanceOf(EntityTypeManagerInterface::class, $this->getEntityTypeManager());
  }

  /**
   * Test event traits.
   */
  public function testEvent() {
    $this->assertInstanceOf(EventDispatcherInterface::class, $this->getEventDispatcher());
  }

  /**
   * Test extension traits.
   */
  public function testExtension() {
    $this->assertInstanceOf(ModuleHandlerInterface::class, $this->getModuleHandler());
    $this->assertInstanceOf(ThemeManagerInterface::class, $this->getThemeManager());
  }

  /**
   * Test file traits.
   */
  public function testFile() {
    $this->assertInstanceOf(FileSystemInterface::class, $this->getFileSystem());
    $this->assertInstanceOf(FileUrlGeneratorInterface::class, $this->getFileUrlGenerator());
  }

  /**
   * Test file module traits.
   */
  public function testFileModule() {
    $this->enableModules(['file']);
    $this->assertInstanceOf(FileRepositoryInterface::class, $this->getFileRepository());
  }

  /**
   * Test file traits.
   */
  public function testForm() {
    $this->assertInstanceOf(FormBuilderInterface::class, $this->getFormBuilder());
  }

  /**
   * Test HTTP traits.
   */
  public function testHttp() {
    $this->assertInstanceOf(Client::class, $this->getHttpClient());
    $this->assertInstanceOf(ClientFactory::class, $this->getHttpClientFactory());
  }

  /**
   * Test key/value traits.
   */
  public function testKeyValues() {
    $this->assertInstanceOf(KeyValueFactoryInterface::class, $this->getKeyValueFactory());
    $this->assertInstanceOf(KeyValueExpirableFactoryInterface::class, $this->getKeyValyeExpirableFactory());
  }

  /**
   * Test layout module traits.
   *
   * @debug
   */
  public function testLayoutModule() {
    $this->enableModules(['layout_discovery']);
    $this->assertInstanceOf(LayoutPluginManagerInterface::class, $this->getLayoutPluginManager());
  }

  /**
   * Test lock traits.
   */
  public function testLock() {
    $this->assertInstanceOf(LockBackendInterface::class, $this->getLock());
  }

  /**
   * Test mail traits.
   */
  public function testMail() {
    $this->assertInstanceOf(MailManagerInterface::class, $this->getMailPluginManager());
  }

  /**
   * Test mail traits.
   */
  public function testMime() {
    $this->assertInstanceOf(MimeTypeGuesserInterface::class, $this->getFileMimeTypeGuesser());
  }

  /**
   * Test pager traits.
   */
  public function testPager() {
    $this->assertInstanceOf(PagerManagerInterface::class, $this->getPagerManager());
  }

  /**
   * Test password traits.
   */
  public function testPassword() {
    $this->assertInstanceOf(PasswordGeneratorInterface::class, $this->getPasswordGenerator());
  }

  /**
   * Test queue traits.
   */
  public function testQueue() {
    $this->assertInstanceOf(QueueFactory::class, $this->getQueueFactory());
    $this->assertInstanceOf(QueueWorkerManagerInterface::class, $this->getQueueWorkerManager());
  }

  /**
   * Test render traits.
   */
  public function testRender() {
    $this->assertInstanceOf(RendererInterface::class, $this->getRenderer());
  }

  /**
   * Test request traits.
   */
  public function testRequest() {
    $this->assertInstanceOf(RequestStack::class, $this->getRequestStack());
  }

  /**
   * Test routing traits.
   */
  public function testRouting() {
    $this->assertInstanceOf(RedirectDestinationInterface::class, $this->getRedirectDestination());
    $this->assertInstanceOf(RouteMatchInterface::class, $this->getRouteMatch());
  }

  /**
   * Test session traits.
   */
  public function testSession() {
    $this->assertInstanceOf(AccountProxyInterface::class, $this->getCurrentUser());
  }

  /**
   * Test settings traits.
   */
  public function testSettings() {
    $this->assertInstanceOf(Settings::class, $this->getSettings());
  }

  /**
   * Test state traits.
   */
  public function testState() {
    $this->assertInstanceOf(StateInterface::class, $this->getState());
  }

  /**
   * Test stream wrapper traits.
   */
  public function testStreamWrapper() {
    $this->assertInstanceOf(StreamWrapperManagerInterface::class, $this->getStreamWrapperManager());
  }

  /**
   * Test temp store traits.
   */
  public function testTempStore() {
    $this->assertInstanceOf(PrivateTempStoreFactory::class, $this->getPrivateTempStoreFactory());
    $this->assertInstanceOf(SharedTempStoreFactory::class, $this->getSharedTempStoreFactory());
  }

  /**
   * Test token traits.
   */
  public function testToken() {
    $this->assertInstanceOf(Token::class, $this->getToken());
  }

  /**
   * Test transliteration traits.
   */
  public function testTransliteration() {
    $this->assertInstanceOf(TransliterationInterface::class, $this->getTransliteration());
  }

  /**
   * Test user module traits.
   */
  public function testUserModule() {
    $this->enableModules(['user']);
    $this->assertInstanceOf(UserDataInterface::class, $this->getUserData());
  }

  /**
   * Test utility traits.
   */
  public function testUtility() {
    $this->assertInstanceOf(EmailValidatorInterface::class, $this->getEmailValidator());
  }

  /**
   * Test uuid traits.
   */
  public function testUuid() {
    $this->assertInstanceOf(UuidInterface::class, $this->getUuid());
  }

}
