<?php

/**
 * @file
 * Database handling for aws_ec2_lib
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */


module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_ebs_volumes_db'    ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_elastic_ips_db'    ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_images_db'         ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_instances_db'      ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_instances_lock_db' ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_register_image_db' ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_security_groups_db') ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_snapshots_db'      ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_ssh_keys_db'       ) ;
module_load_include('inc', 'aws_ec2_lib', 'aws_ec2_lib_user_keys_db'      ) ;


/**
 * Retrieve and store information from the server about the sub-cloud.
 *
 * This function will download the avaliable information for the following.
 *     viz. Elastic IP Info,
 *          Instances Info,
 *          SSH Keys Info,
 *          Security Group Info,
 *          Zone Info,
 *          Snapshot Info,
 *          Volume Info
 *
 * In case the expected paramters are not set there will be a errror message displayed asking user to first set the variables.
 *
 * @param $cloud_context
 *         This is the sub-cloud who's information is to be downloaded
 * @return
 *         The information is downloded using REST calls and is stored in the database in the respective cloud_context tables.
 */
function _aws_ec2_lib_download_all($cloud_context) {

  $host_uri   = cloud_get_info( $cloud_context, 'host_uri'       ) ; 
  $access_key = cloud_get_info( $cloud_context, 'aws_access_key' ) ; 
  $sec_key    = cloud_get_info( $cloud_context, 'aws_secret_key' ) ; 
  
  // Checking if all ec2 variables are set
  if ( empty( $host_uri   )
  ||   empty( $access_key )
  ||   empty( $sec_key    ) ) {  

    $cloud_list = cloud_get_all_clouds_display_name() ;
    if (user_access($cloud_context . ' administer cloud')) {
    
        $admin_url  = filter_xss( l( t('@cloud_name Settings', array('@cloud_name' => $cloud_list[$cloud_context])), "admin/settings/$cloud_context" ) );
    }
    else {
        
        $admin_url  = $cloud_list[$cloud_context] ;
    }
    drupal_set_message(check_plain(t('The variables are not correctly configured: ')) . $admin_url, 'error');

    return FALSE ;
  }

  if ( strpos( $host_uri, 'http://' ) !== FALSE) {  

    $cloud_list = cloud_get_all_clouds_display_name() ;
    $admin_url  = filter_xss( l( t('@cloud_name Settings', array('@cloud_name' => $cloud_list[$cloud_context])), "admin/settings/$cloud_context" ) );
    drupal_set_message(check_plain(t("'http://' is not required in AWS API. Please remove 'http://' from API URI: ")) . $admin_url, 'error');

    return FALSE ;
  }
    
  $resp = _aws_ec2_lib_download_describe_elastic_ips($cloud_context) ;
  
  if ( $resp == FALSE ) {

    $cloud_list = cloud_get_all_clouds_display_name() ;
    if (user_access($cloud_context . ' administer cloud')) {
    
        $admin_url = filter_xss( l( t('@cloud_name Settings', array('@cloud_name' => $cloud_list[$cloud_context])), "admin/settings/$cloud_context" ) );
    }
    else {
        
        $admin_url = $cloud_list[$cloud_context] ;
    }
    drupal_set_message(check_plain(t('The variables are not correctly configured: ')) . $admin_url, 'error');

    return FALSE ;
  }
  
  $resp = _aws_ec2_lib_download_describe_instances($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;
    
  $resp = _aws_ec2_lib_download_describe_ssh_keys($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;
    
  $resp = _aws_ec2_lib_download_describe_security_groups($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;
    
  $resp = _aws_ec2_lib_download_describe_zones($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;
  
  $resp = _aws_ec2_lib_download_describe_snapshots($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;
  
  $resp = _aws_ec2_lib_download_describe_volumes($cloud_context) ;
  if ( $resp == FALSE )
    return FALSE ;

  return TRUE ;
}


/**
 * Retrieve the images information and store it in the database of the respective sub-cloud(cloud_context)
 *
 * @param $cloud_context
 *        This is the sub-cloud who's information is to be downloaded
 * @return
 *        The downloaded image information is stored in the database tables of the respective sub-cloud
 */
function _aws_ec2_lib_download_all_images($cloud_context) {

  $resp = _aws_ec2_lib_download_describe_images($cloud_context) ;
  if ( $resp == FALSE )
    return ;
}  
  
// Start : DB functions Related to Instance Type  

// Start : DB functions Related to Availability Zone  

/**
 * Download Zone related information
 * @param $cloud_context
 * @return 
 */
function _aws_ec2_lib_get_describe_zones_query($cloud_context) {

  $ec2_lib_zone_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ZONE_TABLE ) ;  
  return $query =   'SELECT c.zone_name,  c.zone_state, c.region FROM {' . $ec2_lib_zone_table . '} c  '  ;
}


function _aws_ec2_lib_download_describe_zones($cloud_context) {
  
  $ec2_lib_zone_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ZONE_TABLE ) ;  
  $myclient = aws_ec2_api_describe_zones($cloud_context) ;
  if ( $myclient->code != 200  )
    return FALSE ;
  
  $obj_response = new SimpleXMLElement($myclient->data);
  
  db_query( 'truncate table {'. $ec2_lib_zone_table . '}', NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_zone_table . '} 
                  ( `zone_name`  , 
                    `zone_state` ,
                    `region` 
                  )  values '; 
  
  $count = 0 ;   
  foreach ($obj_response->availabilityZoneInfo->item as $item) {
        
    $insert_query = $insert_query . " ('%s', '%s', '%s' ) ," ; 
    $query_args[] = $item->zoneName  ;
    $query_args[] = $item->zoneState ;
    $query_args[] = isset( $item->regionName ) ? $item->regionName : '' ;
    
    $count++ ;
  }

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => 'Updated: Availability Zone(s)', 
      'link'    => '',
     )
  );
  
  if ( $count == 0 )
    return TRUE;
    
  $insert_query = substr($insert_query,  0,  -1);    
  db_query( $insert_query, $query_args );
  
  return TRUE;
}


// End : DB functions Related to Availability Zone  



// Start : DB functions Related to Bundle Instance

function aws_ec2_lib_db_bundle_instance($cloud_context, $instance_id, $nickname, $bucketname, $foldername, $volume_size, $status) {
  
  $aws_ec2_lib_bundle_instances_table  = AWS_EC2_LIB_BUNDLE_INSTANCES_TABLE ;  
  
  $insert_query = 'INSERT INTO {' . $aws_ec2_lib_bundle_instances_table . '} 
    ( `cloud_context`  , 
      `instance_id`    ,
      `nickname`       ,
      `bucketname`     ,
      `foldername`     ,
      `volume_size`    ,
      `status`    
    )  values ' ;  
  
  $query_args = array() ;
  
  $insert_query = $insert_query . " ('%s', '%s', '%s' , '%s' , '%s', '%s' , '%s' ) " ;
  $query_args[] = $cloud_context  ;
  $query_args[] = $instance_id    ;
  $query_args[] = $nickname       ;
  $query_args[] = $bucketname     ;
  $query_args[] = $foldername       ;
  $query_args[] = $volume_size    ;
  $query_args[] = $status         ;
    
  db_query( $insert_query, $query_args );
  return TRUE;
}


function aws_ec2_lib_db_bundle_instance_get($status) {

  $aws_ec2_lib_bundle_instances_table  = AWS_EC2_LIB_BUNDLE_INSTANCES_TABLE ;

  $script_count = 0 ;
  $query =  'SELECT *  FROM {' . $aws_ec2_lib_bundle_instances_table . '} c  WHERE status=\'%s\' ' ;
  $query_args = array() ;
  $query_args[] = $status ;
  
  $return_result = array() ;
  $result = db_query( $query, $query_args );
  while ($details = db_fetch_object($result)) {

    $values = array() ;
    foreach ($details as $key => $val) {
      $values[$key]=$val;
    }

    $return_result[] = $values ;
  }
  
  return $return_result ;
}


function aws_ec2_lib_db_bundle_instance_update_status($instance_id, $status) {

  $aws_ec2_lib_bundle_instances_table  = AWS_EC2_LIB_BUNDLE_INSTANCES_TABLE ;

  $query =  'UPDATE {' . $aws_ec2_lib_bundle_instances_table . '} set status=\'%s\'  WHERE instance_id=\'%s\' ' ;
  $query_args = array() ;
  $query_args[] = $status ;
  $query_args[] = $instance_id ;

  $result = db_query( $query, $query_args );
  return TRUE ;
}

// End : DB functions Related to Bundle Instance

