<?php

/**
 * @file
 * DB functions Related to Volumes for Amazon EC2
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 *
 */


/**
 * Update the databse after the request to attach a volume to an instance was successfully completed
 * 
 * @param $cloud_context
 *      The instance of sub-cloud on which attach volume operation was performed.
 * @param $myclient
 *      The response of the REST call
 * @return
 *      FALSE: If the reponse was empty
 *      TRUE:  If the database update was successfull.
 */
function _aws_ec2_lib_save_attach_volume($cloud_context, $myclient) {

  if ( empty($myclient) )
    return FALSE ;
    
  $ec2_lib_volumes_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
    
  $update_query = 'UPDATE {' . $ec2_lib_volumes_table . '} 
                set `instance_id`=\'%s\' , 
                  `device`=\'%s\' , 
                  `status`=\'%s\' , 
                  `attached`=\'%s\'
                  
                where `volume_id`=\'%s\'                  
          '; 
  
  $obj_response = new SimpleXMLElement($myclient->data);
  
  if ( isset($obj_response->instanceId) == FALSE )
    return FALSE ;
  
  $query_args = array(
    $obj_response->instanceId ,
    $obj_response->device     ,
    $obj_response->status     ,
    $obj_response->attachTime ,
    $obj_response->volumeId   ,
  ) ;
  
  db_query( $update_query, $query_args ) ;
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => t('Volume has been modified: @volume_id', array('@volume_id' => $obj_response->volumeId)), 
      'link'    => '',
    )
  );
  
  return TRUE ;
}

function _aws_ec2_lib_update_attach_volume($cloud_context) {

  $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
    
  $update_query = 'UPDATE {' . $ec2_lib_volumes_table . '} 
                set `%s`=\'%s\' 
                where `volume_id`=\'%s\'                  
          '; 
  
  return $update_query ;
}


function _aws_ec2_lib_get_volume_deviceoptions_query($cloud_context) {

  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_VOLUMES_DEVICE_OPTIONS_TABLE ) ;
  return $query =  'SELECT c.deviceid, c.device FROM {' . $ec2_lib_volumes_device_opt_table . '} c ' ;
}

function _aws_ec2_lib_get_volumes_by_instance_query($cloud_context) {

  $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE   ) ;
  
  
  return $query =  'SELECT c.volume_id,  c.nickname,  d.instance_nickname,  c.device,  c.status,  c.created,  c.vol_size,  c.snapshot_id,  c.vol_zone,  c.attached FROM {' . $ec2_lib_volumes_table . '} c LEFT JOIN  {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id WHERE c.instance_id=\'%s\' order by c.nickname ' ;
}

/**
 *
 * @param  $cloud_context
 * @param  $instance_id
 * @return  
 */
 function _aws_ec2_lib_get_describe_volumes_query($cloud_context, $instance_id='') {

   $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE ) ;
  
  $search_where= '';
  if ($instance_id) {
    $search_where = ' and c.vol_zone in (select placement from {' . $ec2_lib_instances_table . '} where instance_id="' . $instance_id . '")';
  }
  
   return $query =  'SELECT c.volume_id,  c.nickname,  d.instance_nickname, c.instance_id, c.device,  c.status,  c.created,  c.vol_size,  c.snapshot_id,  c.vol_zone,  c.attached,  CAST(SUBSTRING_INDEX(c.vol_size,  " ",  1) as UNSIGNED) as volume_size FROM {' . $ec2_lib_volumes_table . '} c LEFT JOIN  {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id  WHERE %s like \'%%%s%%\' ' . $search_where ;
}


/**
 *
 * @param  $cloud_context
 * @param  $instance_id
 * @return  
 */
function _aws_ec2_lib_get_volume($cloud_context, $instance_id='') {

  $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE ) ;
  
  $search_where= '';
  if ($instance_id) {
    $search_where = ' and c.vol_zone in (select placement from {' . $ec2_lib_instances_table . '} where instance_id="' . $instance_id . '")';
  }
  
   return $query =  'SELECT c.volume_id,  c.nickname,  d.instance_nickname,  c.device,  c.status,  c.created,  c.vol_size,  c.snapshot_id,  c.vol_zone,  c.attached,  CAST(SUBSTRING_INDEX(c.vol_size,  " ",  1) as UNSIGNED) as volume_size FROM {' . $ec2_lib_volumes_table . '} c LEFT JOIN  {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id  WHERE %s = \'%s\' ' . $search_where ;
}


/**
 *
 * @param  $cloud_context
 * @return  
 */
function _aws_ec2_lib_get_volumes_query($cloud_context) {

  $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE   ) ;
  
  return $query =  'SELECT c.volume_id,  c.nickname,  d.instance_nickname,  c.device,  c.status,  c.created,  c.vol_size,  c.snapshot_id,  c.vol_zone,  c.attached,  c.instance_id FROM {' . $ec2_lib_volumes_table . '} c LEFT JOIN  {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id WHERE volume_id= \'%s\' ' ;
}

/**
 *
 * @param  $cloud_context
 * @return  
 */
function _aws_ec2_lib_get_volumes_list_count($cloud_context) {

  $ec2_lib_volumes_table   = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $ec2_lib_instances_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE ) ;
  
  $query = 'SELECT count(*) as item_count FROM {' . $ec2_lib_volumes_table . '} c LEFT JOIN  {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id' ;
  $result = db_query( $query, NULL );
  while ($item = db_fetch_object($result)) {
  
    $item_count = $item->item_count ;
  }

  return $item_count ;
}

/**
 *
 * @param  $cloud_context
 * @return   
 */
function _aws_ec2_lib_download_describe_volumes($cloud_context) {
  
  $ec2_lib_volumes_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  
  $myclient = aws_ec2_api_describe_volumes($cloud_context) ;
  if ( $myclient->code != 200  )
    return FALSE ;
  
  $obj_response = new SimpleXMLElement($myclient->data);
  $id_nick_arr  = cloud_get_all_nickname('volume_id', 'nickname' , $ec2_lib_volumes_table ) ;

  db_query( 'truncate table {' . $ec2_lib_volumes_table . '}' , NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_volumes_table . '} 
                  ( `volume_id`   ,  
                    `nickname`    ,  
                    `instance_id` ,  
                    `device`      ,  
                    `status`      , 
                    `created`     , 
                    `vol_size`    , 
                    `snapshot_id` , 
                    `vol_zone`    , 
                    `attached`  
                  )  values 
          '; 
  
  $count = 0 ;   
  
  foreach ($obj_response->volumeSet->item as $item) {

    $attachment   = $item->attachmentSet->item ;

    $insert_query = $insert_query . " ( '%s', '%s', '%s', '%s', '%s', '%s' , '%s', '%s', '%s', '%s' ) ," ; 
    $query_args[] = $item->volumeId;
    $tmp_nickname = cloud_check_in_array($id_nick_arr, $item->volumeId) ;
    $query_args[] = $tmp_nickname != NULL
                  ? $tmp_nickname
                  : $item->volumeId;
    $query_args[] = $attachment->instanceId ;
    $query_args[] = $attachment->device     ;
    if ( isset( $attachment->status) ) 
      $query_args[] = $item->status . '(' . $attachment->status .')';
    else
      $query_args[] = $item->status ;
      
    $query_args[] = $item->createTime   ;
    $query_args[] = $item->size . ' GB' ;
    $query_args[] = ( isset($item->snapshotId)
                  &&  empty($item->snapshotId) == FALSE )
                  ? $item->snapshotId 
                  : '' ;
    $query_args[] = $item->availabilityZone ;
    $query_args[] = $attachment->attachTime ;
    $count++ ;
  }
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => 'Updated: Volume(s)', 
      'link'    => '',
    )
  );
  
  if ( $count == 0 ) return TRUE;
    
  $insert_query = substr($insert_query,  0,  -1);    
  
  db_query( $insert_query, $query_args );
  
  return TRUE;
}

/**
 *
 * @param  $cloud_context
 * @param  $myclient
 * @param  $nickname
 * @return  
 */
function _aws_ec2_lib_save_new_volume($cloud_context, $myclient, $nickname ) {
  
  $ec2_lib_volumes_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  
  $obj_response = new SimpleXMLElement($myclient->data);
  $count = 0 ;   
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_volumes_table . '} 
                  ( `volume_id`   ,  
                    `nickname`    , 
                    `status`      , 
                    `created`     , 
                    `vol_size`    , 
                    `vol_zone`    ,
                    `snapshot_id` 
                  )  values 
          '; 
          
  $insert_query = $insert_query . "  (  '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) ; " ; 
  $query_args[] = $obj_response->volumeId         ;
  $query_args[] = $nickname                       ;
  $query_args[] = $obj_response->status           ;
  $query_args[] = $obj_response->startTime        ;
  $query_args[] = $obj_response->volumeSize       ;
  $query_args[] = $obj_response->availabilityZone ;
  $query_args[] = $obj_response->snapshotId       ;
  
  
  db_query( $insert_query, $query_args );
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => t('Volume has been added: @volume_id', array('@volume_id' => $obj_response->volumeId)), 
      'link'    => '',
    )
  );
  
  return TRUE ;
}

/**
 * First a REST request to delete a volume is submitted and this function will
 * store the response of this request
 * 
 * @param  $cloud_context
 *           The sub-cloud who's volume is to be deleted
 * @param  $result
 *           The REST call response
 * @param  $vol_id
 *           The Id of volume to be deleted
 * @return   
 */
function _aws_ec2_lib_delete_volume($cloud_context, $result, $vol_id ) {

  if ( $result->code != 200 )
    return FALSE ;
    
  $ec2_lib_volumes_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  $obj_response = new SimpleXMLElement($result->data);
  if ( $obj_response->return == 'true' ) {
  
    $delete_query = 'DELETE FROM {' . $ec2_lib_volumes_table . "} where volume_id='%s' ; " ;
    $query_args[] = $vol_id ;
    db_query( $delete_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Volume has been deleted: @volume_id', array('@volume_id' => $vol_id)), 
        'link'    => '',
      )
    );
      
    return TRUE ;  
  }
  
  return FALSE ;
}

// End : DB functions Related to Volumes