<?php

/**
 * @file
 * Constants for aws_ec2_lib
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */

 
/**
 *
 * @param   $cloud_context
 * @param   $myclient
 * @param   $instance_id
 * @param   $public_ip
 * @return   
 */
function _aws_ec2_lib_save_associate_address($cloud_context , $myclient, $instance_id, $public_ip) {

  if ( $myclient->code != 200)
    return FALSE ;
    
  $ec2_lib_elastic_ip_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 

  $obj_response = new SimpleXMLElement($myclient->data);
  
  if ( isset($obj_response->return) && $obj_response->return == 'true' ) {
  
    $insert_query = 'UPDATE {' . $ec2_lib_elastic_ip_table . "} set `instance_id`='%s' where `public_ip`='%s' "; 
    
    $query_args[] = $instance_id ;
    $query_args[] = $public_ip ;
    
    db_query( $insert_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Elastic IP "@public_id" has been assigned to instance "@instance_id".', array(
                                   '@public_id' => $public_ip,                '@instance_id' => $instance_id)),
        'link'    => '',
      )
    );
    
    return TRUE ;
  }
  
  return FALSE ;
}


/**
 *
 * @param   $cloud_context
 * @param   $myclient
 * @return   
 */
function _aws_ec2_lib_save_allocate_address($cloud_context , $myclient) {

  $ec2_lib_elastic_ip_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 

  $obj_response = new SimpleXMLElement($myclient->data);

  if ( isset($obj_response->publicIp) ) {
  
    $insert_query = 'INSERT INTO {' . $ec2_lib_elastic_ip_table . "} 
                  ( `public_ip` ,  
                    `public_ip_name`
                  )  values (  '%s', '%s')
          "; 
    
    $query_args[] = $obj_response->publicIp ;
    $query_args[] = '- changeme -' ;

    db_query( $insert_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Elastic IP has been added: @public_ip', array('@public_ip' => $obj_response->publicIp)),
        'link'    => '',
      )
    );
    
    return TRUE ;
  }
  
  return FALSE ;
}

/**
 *
 * @param   $cloud_context
 * @param   $myclient
 * @param   $ip
 * @return   
 */
function _aws_ec2_lib_release_address_save($cloud_context , $myclient, $ip) {

  $ec2_lib_elastic_ip_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 

  $obj_response = new SimpleXMLElement($myclient->data);
  
  if ( isset($obj_response->return) && $obj_response->return == 'true' ) {
  
    $delete_query = 'DELETE FROM {' . $ec2_lib_elastic_ip_table . "}  where public_ip='%s'  "; 
    $query_args[] = $ip ;
    
    db_query( $delete_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Elastic IP has been deleted: @ip', array('@ip' => $ip)), 
        'link'    => '',
      )
    );
    
    return TRUE ;
  }
  
  return FALSE ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_download_describe_elastic_ips($cloud_context) {
  
  $ec2_lib_elastic_ip_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ;
  
  try {
  
    $myclient = aws_ec2_api_describe_address($cloud_context) ;

    if (empty($myclient)
    ||  isset($myclient->data) === FALSE
    ||        $myclient->code  !=  200) { // Needed for OpenStack
  
      return FALSE ;
    }
  
    $obj_response = new SimpleXMLElement($myclient->data);
  
  } catch (Exception $e) {

    $cloud_list = cloud_get_all_clouds_display_name() ;
    if (user_access($cloud_context . ' administer cloud')) {
    
        $admin_url = filter_xss( l( t('@cloud_name Settings', array('@cloud_name' => $cloud_list[$cloud_context])), "admin/settings/$cloud_context" ) );
    }
    else {
        
        $admin_url = $cloud_list[$cloud_context] ;
    }
    
    drupal_set_message(check_plain(t('The variables are not correctly configured: ')) . $admin_url, 'error');

    return FALSE ;
  }
  
  $id_nick_arr = cloud_get_all_nickname('public_ip', 'public_ip_name', $ec2_lib_elastic_ip_table ) ;
  db_query( 'truncate table {' . $ec2_lib_elastic_ip_table . '}',  NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_elastic_ip_table . '} 
                  ( `public_ip` ,  
                    `public_ip_name` ,  
                    `instance_id` 
                  )  values 
          '; 
  
  $count = 0 ;   
  if (isset($obj_response->addressesSet)
  &&  isset($obj_response->addressesSet->item)
  &&  count($obj_response->addressesSet->item)>0) {
    foreach ($obj_response->addressesSet->item as $item) {
        
/*
      if ( isset($item->instanceId) && $item->instanceId == 'nobody' ) {
      
        continue ;
      }        
*/
      $insert_query = $insert_query . " ( '%s', '%s', '%s' ) ," ; 
      $query_args[] = $item->publicIp ;
      $tmp_nickname = cloud_check_in_array($id_nick_arr, $item->publicIp) ;
      $query_args[] = $tmp_nickname != NULL ? $tmp_nickname : $item->publicIp ;
      
      if ( empty($item->instanceId) || substr_count( $item->instanceId , 'available') > 0 ) 
        $query_args[] = '' ;
      else {
        
        $instance_id  = $item->instanceId ;
        $instance_id  = trim( str_replace( '(eucalyptus)', '', $instance_id ) );
        $instance_id  = trim( str_replace( '(admin)'      ,  '', $instance_id ) );
        $query_args[] = $instance_id ;  
      }  
        
      $count++ ;
    }
  }

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => 'Updated: Elastic IP(s)', 
      'link'    => ''
    )
  );
  
  if ( $count == 0 )
    return TRUE;
    
  $insert_query = substr($insert_query,  0,  -1);    
  
  db_query( $insert_query, $query_args );
  return TRUE;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_describe_elastic_ips_query($cloud_context) {

  $ec2_lib_elastic_ip_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ;  
  $ec2_lib_instances_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE  ) ;  
  
  return $query = 'SELECT c.public_ip, c.public_ip_name, c.instance_id, d.instance_nickname FROM {' . $ec2_lib_elastic_ip_table . '} c LEFT JOIN {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id where %s like \'%%%s%%\' '  ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_elastic_ips_query($cloud_context) {

  $ec2_lib_elastic_ip_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 
  $ec2_lib_instances_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE  ) ;    
  
  return $query = 'SELECT c.public_ip, c.public_ip_name, c.instance_id, d.instance_nickname FROM {' . $ec2_lib_elastic_ip_table . '} c LEFT JOIN {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id where c.public_ip=\'%s\' '  ;
}

/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_elastic_ips_list_count($cloud_context) {

  $ec2_lib_elastic_ip_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 
  $ec2_lib_instances_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_TABLE  ) ;    
  
  $query      = 'SELECT COUNT(*) as item_count FROM {' . $ec2_lib_elastic_ip_table . '} c LEFT JOIN {' . $ec2_lib_instances_table . '} d on c.instance_id=d.instance_id'  ;
  $result     = db_query( $query, NULL );
  $item_count = 0;

  while ($item = db_fetch_object($result)) {
  
    $item_count = $item->item_count ;
  }

  return $item_count ;
}


function _aws_ec2_lib_update_ip_query($cloud_context) {

  $ec2_lib_elastic_ip_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_ELASTIC_IP_TABLE ) ; 
  $sql_instance_update = 'update {' . $ec2_lib_elastic_ip_table . "} set %s='%s' where public_ip= '%s'" ;    
  return $sql_instance_update ;
}
  
// End : DB functions Related to Elastic IP's    
