<?php

/**
 * @file
 * aws_ec2_lib DB handling for Elastic IP
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */


/**
* Updated by yas 2011/02/22
*/

// Start : DB functions Related to Images

/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_describe_images_query($cloud_context) {

  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_IMAGES_TABLE ) ;
  return $query = 'SELECT c.image_nickname, c.image_id, c.image_location, c.imageowner_id, c.image_state, c.architecture, c.region, c.image_type FROM {' . $ec2_lib_images_table . '} c WHERE %s like \'%%%s%%\' '  ;
}


/**
 *
 * @param   $cloud_context
 * @return
 */
function _aws_ec2_lib_get_images_list_count($cloud_context) {

  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_IMAGES_TABLE ) ;

  $query        = 'SELECT COUNT(*) AS images_count FROM {' . $ec2_lib_images_table . '} c '  ;
  $result       = db_query( $query, NULL );
  $images_count = 0 ;

  while ($img = db_fetch_object($result)) {

    $images_count = $img->images_count ;
  }
  return $images_count ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_describe_owner_images_query($cloud_context) {

  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context, AWS_EC2_LIB_IMAGES_TABLE ) ;
  return $query = 'SELECT c.image_nickname, c.image_id, c.image_location, c.imageowner_id, c.image_state, c.architecture, c.region, c.image_type FROM {' . $ec2_lib_images_table . "} c WHERE %s like '%%%s%%' and imageowner_id='%s'" ;
}



/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_image_query($cloud_context) {

  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context, AWS_EC2_LIB_IMAGES_TABLE ) ;
  return $query = 'SELECT c.image_nickname, c.image_id, c.image_location, c.imageowner_id, c.image_state, c.architecture FROM {' . $ec2_lib_images_table . '} c WHERE %s=\'%s\'  '  ;
}



/**
 *
 * @param   $location
 * @return   
 */
function _aws_ec2_lib_get_image_nickname($location) {

  $tok  = explode('/' , $location ) ; 
  $len  = sizeof($tok) ;
  
  $name =  $tok[$len - 1 ] ;
  
  $nickname = explode('.manifest.xml' , $name ) ; 
  
  return $nickname[0] ; 
}


/**
 *
 * @param   $cloud_context
 * @param   $image_url_arr
 * @param   $base_url
 * @return   
 */
function _aws_ec2_lib_download_images($cloud_context , $image_url_arr, $base_url) {

  if ( empty($base_url)) {

    $cloud_list = cloud_get_all_clouds_display_name() ;
    if (user_access($cloud_context . ' administer cloud')) {
    
        $admin_url = filter_xss( l( t('@cloud_name Settings', array('@cloud_name' => $cloud_list[$cloud_context])), "admin/settings/$cloud_context" ) );
    }
    else {
    
        $admin_url = $cloud_list[$cloud_context] ;
    }
    drupal_set_message(check_plain(t('The variables are not correctly configured: ')) . $admin_url, 'error');
    
    return FALSE ;
  }  
  
  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_IMAGES_TABLE ) ;
  $host_uri = $base_url ;
  $myclient = aws_ec2_api_describe_images($cloud_context , $host_uri) ;
  if ( $myclient->code != 200  )
    return FALSE ;
  
  $obj_response = new SimpleXMLElement($myclient->data);

  $id_nick_arr = cloud_get_all_nickname('image_id', 'image_nickname' , $ec2_lib_images_table ) ;
  
  $insert_init_query = 'INSERT INTO {' . $ec2_lib_images_table . '} 
                  ( `image_id`       , 
                    `image_nickname` ,  
                    `image_location` , 
                    `image_state`    , 
                    `imageowner_id`  ,   
                    `is_public`      , 
                    `architecture`   ,  
                    `image_type`     ,
                    `kernel_id`      , 
                    `ramdisk_id`     , 
                    `region` 
                  )  values 
          '; 
  
  
  $insert_query    = $insert_init_query ;
  $count           = 0 ;
  $records_deleted = FALSE ;
  $query_args      = array() ;
  foreach ($obj_response->imagesSet->item as $item) {
          
    $insert_query = $insert_query . " (  '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) ," ; 
    $query_args[] = $item->imageId ;
    
    $tmp_nickname = cloud_check_in_array($id_nick_arr, $item->imageId ) ;
    $query_args[] = $tmp_nickname != NULL
                  ? $tmp_nickname
                  : _aws_ec2_lib_get_image_nickname($item->imageLocation) ;
    $query_args[] = $item->imageLocation ;
    $query_args[] = $item->imageState    ;
    $query_args[] = $item->imageOwnerId  ;
    $query_args[] = $item->isPublic      ;
    $query_args[] = isset( $item->architecture ) ? $item->architecture : '' ;

    switch ($cloud_context) { // Needed for OpenStack
      // That should be imageType.  In Austin release, there are two types of attributes like
      // 'type' and 'imageType'.  However in Baxer release, they left 'type' and removed 'imageType'!
      case AWS_EC2_LIB_OPENSTACK_NOVA_CONTEXT:
        $query_args[] =  isset($item->type     ) ? $item->type
                      : (isset($item->imageType) ? $item->imageType : '') ;
        break;

      default:
        $query_args[] =  isset($item->imageType) ? $item->imageType : ''  ;
    }

    $query_args[] = isset( $item->kernelId     ) ? $item->kernelId  : ''  ;
    $query_args[] = isset( $item->ramdiskId    ) ? $item->ramdiskId : ''  ;
    $query_args[] = !empty($region_url         ) ? $region_url      : ''  ;
    $count++ ;
    
    if ($count % 900 == 0 ) { // Insert 1000 Records{
      // If Old records not deleted then delete those
      if ($records_deleted === FALSE ) {
        db_query( 'TRUNCATE TABLE {' . $ec2_lib_images_table . '} ', NULL );  
        $records_deleted = TRUE ;
      }
      
      // Insert records
      $insert_query = substr($insert_query, 0, -1);    
      db_query( $insert_query, $query_args );
      
      //Reset
      $insert_query = $insert_init_query ;
      $query_args   = array() ;
    }
  }

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => 'Update: Image(s)', 
      'link'    => ''
    )
  );

  if ( $count == 0 )
    continue ;

  if ($records_deleted === FALSE ) {
    db_query( 'DELETE FROM {' . $ec2_lib_images_table . '} ' , NULL );  
  }

  $insert_query = substr($insert_query, 0, -1);    
  db_query( $insert_query, $query_args );
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_download_describe_images($cloud_context) {

  ini_set('memory_limit', '512M'); 
  
  $region = '' ; // getAmazonRegions() ;
  $host = cloud_get_info( $cloud_context , 'host_uri' )  ;
  _aws_ec2_lib_download_images( $cloud_context , $region , $host ) ;

  return TRUE;
}


/**
 *
 * @param   $cloud_context
 * @param   $image_type
 * @return   
 */
function aws_ec2_lib_get_all_images_db($cloud_context, $image_type='') {

  $query = '';
  $query_args    = array() ;
  $image_options = array();

  $ec2_lib_images_table    = aws_ec2_lib_get_table_info( $cloud_context, AWS_EC2_LIB_IMAGES_TABLE ) ;
    
  $query .= ' SELECT distinct * FROM {' . $ec2_lib_images_table . ' }'
         .  ' WHERE %s like \'%%%s%%\' '  ;
  
  $query_args[] = 'image_type' ;
  $query_args[] = $image_type ;

  $image_options = array();
  $image_options[AWS_EC2_LIB_CLOUD_NONE] = AWS_EC2_LIB_CLOUD_NONE ;
  $result = db_query( $query, $query_args ); 
  
  while ($image = db_fetch_object($result)) {
  
    $image_options[$image->image_id] =  $image->image_nickname . ' (' . $image->image_id . ')' ;
  }
  
  asort( $image_options);
  return $image_options ;
}



/**
 *
 * @param   $cloud_context
 * @param   $image_type
 * @param   $search_str
 * @return   
 */
function aws_ec2_lib_get_all_images_by_str_db($cloud_context, $image_type='', $search_str='') {

  $ec2_lib_images_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_IMAGES_TABLE ) ;  
  
  $query      = 'SELECT distinct * FROM {' . $ec2_lib_images_table . '} WHERE image_type=\'%s\' and ( image_id like \'%%%s%%\' or image_nickname like \'%%%s%%\' ) order by image_id ' ;
  $query_args = array(
    $image_type,
    $search_str,
    $search_str,
  );

  $image_options = array();
  $image_options[AWS_EC2_LIB_CLOUD_NONE] = AWS_EC2_LIB_CLOUD_NONE ;
  $result = db_query( $query, $query_args ); 
  
  while ($image = db_fetch_object($result)) {
  
    $image_options[$image->image_nickname . ' (' . $image->image_id . ')'] =  $image->image_nickname . ' (' . $image->image_id . ')' ;
  }
  asort($image_options);
  return $image_options ;
}


/**
 *
 * @param   $cloud_context
 * @param   $img_id @
 */
function aws_ec2_lib_callback_list_machine_images($cloud_context , $img_id) {

  $matches = array();
  $matches =  aws_ec2_lib_get_all_images_by_str_db($cloud_context, 'machine' , $img_id );
  print drupal_to_js($matches);

  exit();
}


/**
 *
 * @param   $cloud_context
 * @param   $img_id 
 */
function aws_ec2_lib_callback_list_kernel_images($cloud_context , $img_id) {

  $matches = array();
  $matches =  aws_ec2_lib_get_all_images_by_str_db($cloud_context, 'kernel'  , $img_id );
  print drupal_to_js($matches);

  exit();
}



/**
 *
 * @param   $cloud_context
 * @param   $img_id @
 */
function aws_ec2_lib_callback_list_ramdisk_images($cloud_context , $img_id) {

  $matches = array();
  $matches = aws_ec2_lib_get_all_images_by_str_db($cloud_context, 'ramdisk' , $img_id );
  print drupal_to_js($matches);

  exit();
} 

  
// End : DB functions Related to Images