<?php

/**
 * @file
 * Constants for aws_ec2_lib_instances_lock_db.inc
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */



/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_lock_status_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'select instance_id, is_locked, monitor, script_status, ssh_user_name from {' . $ec2_lib_instances_lock_table . "} where instance_id='%s'  " ;
  return $sql_instance ;
}


/**
 *
 * @param   $cloud_context
 * @param   $instance_id
 * @return   
 */
function _aws_ec2_lib_get_lock_status_by_id_query($cloud_context , $instance_id) {

  $get_instance_query      = _aws_ec2_lib_get_lock_status_query($cloud_context) ;
  $get_instance_query_args = array(
    $instance_id, 
  ) ;  
  $instance_found_flag = FALSE; 
  $result_instance_query = db_query( $get_instance_query, $get_instance_query_args ) ; 

  while ($instance_data = db_fetch_object($result_instance_query)) {
    
    return $instance_data->is_locked ;
  }
  
  return '' ; // Default value
}

/**
 * This function returns the lock status of all instances.
 * This will decide whether the instance will allow operations  
 *
 */
function _aws_ec2_lib_get_lock_status_all_instances_db($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'select instance_id,  is_locked,  monitor ,  script_status from {' . $ec2_lib_instances_lock_table . '}' ;

  $result = db_query( $sql_instance );
  
  $result_status = array(); 
  
  while ($key = db_fetch_object($result)) {
    
    $result_status[$key->instance_id] = array() ;
    $result_status[$key->instance_id]['is_locked'    ] = $key->is_locked ;
    $result_status[$key->instance_id]['monitor'      ] = $key->monitor ;
    $result_status[$key->instance_id]['script_status'] = $key->script_status ;
  }
  
  return $result_status ;
}

/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_lock_status_by_cloud_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'select instance_id, is_locked, monitor, script_status from {' . $ec2_lib_instances_lock_table . "} where instance_id='%s'" ;    
  return $sql_instance ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_instances_lock_status($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $lock_query = 'select instance_id, is_locked, monitor from {' . $ec2_lib_instances_lock_table . '}';
  $result = db_query( $lock_query );
  
  $result_status = array(); 
  
  while ($key = db_fetch_object($result)) {
    
    $result_status[$key->instance_id             ] = $key->is_locked ;
    $result_status[$key->instance_id . '_monitor'] = $key->monitor ;
  }
  
  return $result_status ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_set_lock_status_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'INSERT INTO {' . $ec2_lib_instances_lock_table . "} ( instance_id,  is_locked , ssh_user_name ) values ('%s', '%s' , '%s') " ;
  return $sql_instance ;
}


/**
 *
 * @param   $cloud_context
 * @return
 */
function _aws_ec2_lib_set_ssh_user_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'INSERT INTO {' . $ec2_lib_instances_lock_table . "} ( instance_id,  is_locked , ssh_user_name ) values ('%s', '%s' , '%s') " ;
  return $sql_instance ;
}

/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_set_monitor_status_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'INSERT INTO {' . $ec2_lib_instances_lock_table . "} ( instance_id,  is_locked ,  monitor) values ('%s', '%s', '%s') " ;    
  return $sql_instance ;
}


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_update_lock_status_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'update {' . $ec2_lib_instances_lock_table . "} set is_locked='%s' where instance_id='%s' " ;    
  return $sql_instance ;
}


/**
 *
 * @param   $cloud_context
 * @return
 */
function _aws_ec2_lib_update_ssh_user_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'update {' . $ec2_lib_instances_lock_table . "} set ssh_user_name='%s' where instance_id='%s' " ;
  return $sql_instance ;
}

/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_ec2_lib_instance_monitoring_status_update_query($cloud_context) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $sql_instance = 'update {' . $ec2_lib_instances_lock_table . "} set monitor='%s' where instance_id='%s' " ;    
  return $sql_instance ;
}



/**
 *
 * @param   $cloud_context
 * @param   $instance_id
 * @param   $script_status
 * @return   
 */
function aws_ec2_lib_instance_status_update($cloud_context, $instance_id, $script_status) {

  $ec2_lib_instances_lock_table     = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  $get_instance_query        = _aws_ec2_lib_get_lock_status_query($cloud_context) ;
  $get_instance_query_args   = array() ;
  $get_instance_query_args[] = $instance_id ; 
  
  $instance_found_flag = FALSE; 
  $result_instance_query = db_query( $get_instance_query, $get_instance_query_args ) ; 

  while ($instance_data = db_fetch_object($result_instance_query)) {
    $instance_found_flag = TRUE; 
  }
  
  if ($instance_found_flag) {
    $status_update_query = 'update {' . $ec2_lib_instances_lock_table . "} set script_status='%s' where instance_id='%s' " ;    
    $update_args = array() ;
    $update_args[] = $script_status ;
    $update_args[] = $instance_id ; 
    
    $result_update = db_query( $status_update_query, $update_args ) ; 
  }
  else  {
    $sql_insert_instance = 'INSERT INTO {' . $ec2_lib_instances_lock_table . "} ( instance_id,  is_locked ,  monitor ,  script_status ) values ('%s', '%s', '%s', '%s') " ;    
    $sql_insert_instance_args   = array() ;
    $sql_insert_instance_args[] = $instance_id ;
    $sql_insert_instance_args[] = 'Unlock' ; // default value
    $sql_insert_instance_args[] = '0' ; // default value
    $sql_insert_instance_args[] =  $script_status ;
    
    $result_update = db_query( $sql_insert_instance, $sql_insert_instance_args ) ; 
  }
  
  return $result_update ;
}


/**
 *
 * @param   $cloud_context
 * @param   $instance_id
 * @param   $monitor_flag
 * @return   
 */
function aws_ec2_lib_instance_monitoring_status_update($cloud_context, $instance_id, $monitor_flag) {

  $ec2_lib_instances_lock_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_INSTANCES_LOCK_TABLE ) ;
  
  $found_record = FALSE  ;
  
  $query = _aws_ec2_lib_get_lock_status_query($cloud_context) ;
  $query_args = array() ;
  
  $query_args[] = $instance_id ;
  $result = db_query( $query, $query_args ); 
  while ($elastic_ip = db_fetch_object($result)) {
  
    $found_record = TRUE ;
  }
  
  if ($found_record == TRUE ) { // Record already exists update the record
  
    $query_update = _aws_ec2_lib_ec2_lib_instance_monitoring_status_update_query($cloud_context) ;
    $update_args = array() ;
    $update_args[] = $monitor_flag ;
    $update_args[] = $instance_id ; 
    
    $result_update = db_query( $query_update, $update_args ) ; 
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Instance monitoing status has been modified: @instance_id', array('@instance_id' => $instance_id)),
        'link'    => '',
      )
    );
  }
  else { // Insert a new record
    
    $query_insert = _aws_ec2_lib_set_monitor_status_query($cloud_context) ;
    $insert_args  = array(
                      $instance_id ,
                      'Unlock'     ,
                      $monitor_flag,
    ); 
    
    $result_update = db_query( $query_insert, $insert_args ) ; 
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Instance has been added: @instance_id', array('@instance_id' => $instance_id)),
        'link'    => '',
      )
    );
  }

  return;
}
