<?php

/**
 * @file
 * aws_ec2_lib Register Image
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */
 
// Start : DB functions Related to Register Image


/**
 *
 * @param   $cloud_context
 * @return   
 */
function _aws_ec2_lib_get_register_image_query($cloud_context) {

  $ec2_lib_register_image_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_REGISTER_IMAGE_STATUS_TABLE ) ;
  return $query = 'SELECT c.id,  c.owner,   c.status ,  c.image_id FROM {' . $ec2_lib_register_image_table . '} c WHERE id=\'%s\'  '  ;
}

/**
 *
 * @param     $cloud_context
 * @param     $id
 * @param     $status
 * @param     $image_id
 * @return     
 */
function _aws_ec2_lib_update_image_register_status($cloud_context , $id, $status, $image_id) {

  $ec2_lib_register_image_table  = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_REGISTER_IMAGE_STATUS_TABLE ) ;
  $query = 'UPDATE {' . $ec2_lib_register_image_table . '} c set status=\'%s\' ,  image_id=\'%s\' WHERE id=\'%s\'  '  ;
  $query_args[] = $status ;
  $query_args[] = $image_id ;
  $query_args[] = $id ;

  db_query( $query, $query_args );

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => t('Image has been added: @image_id', array('@image_id' => $id)),
      'link'    => '',
    )
  );

  return;
}

// End : DB functions Related to Register Image
