<?php

/**
 * @file
 * aws_ec2_lib Security Group DB
 * DB functions Related to Security Groups
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_security_group_query($cloud_context) {

  $ec2_lib_security_groups_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  return $query =   'SELECT c.owner_id, c.group_name, c.group_description, c.permissions FROM {' . $ec2_lib_security_groups_table . '} c WHERE group_name= \'%s\' order by group_name asc '  ;
}


/**
 *
 * @param     $cloud_context
 * @param     $myclient
 * @param     $group_name
 * @param     $grp_desc
 * @return     
 */
function _aws_ec2_lib_save_new_security_group($cloud_context, $myclient, $group_name, $grp_desc) {
  
  if ( $myclient->code != 200 )
    return FALSE ;
    
  $ec2_lib_security_groups_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  
  $obj_response = new SimpleXMLElement($myclient->data);
  $count = 0 ;   

  $owner_id = cloud_get_info( $cloud_context , 'user_id' )  ;
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_security_groups_table . '} 
                  ( `group_name` ,  
                    `group_description` ,
                    `owner_id`
                  )  values
          '; 
          
  $insert_query = $insert_query . "  ( '%s', '%s' , '%s' ) ; " ;
  $query_args[] = $group_name;
  $query_args[] = $grp_desc ;
  $query_args[] = $owner_id ;

  if ( $myclient->code === '200' )  {
    
    // User Activity Log
    cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => t('Security Group has been added: @group_name', array('@group_name' => $group_name)), 
      'link'    => ''
      )
    );
    
    db_query( $insert_query, $query_args );
    return TRUE ;
  }
  
  return FALSE ;

}

 /**
  *
  * @param     $cloud_context
  * @param     $result
  * @param     $group_name
  * @return     
  */
function _aws_ec2_lib_delete_security_group($cloud_context, $result, $group_name ) {

  $ec2_lib_security_groups_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  if ( $result->code != 200 )
    return FALSE ;
    
  $obj_response = new SimpleXMLElement($result->data);
  if ( $obj_response->return == 'true' ) {
  
    $delete_query = 'DELETE FROM {' . $ec2_lib_security_groups_table . "} where group_name='%s' ; " ;
    $query_args[] = $group_name ;
    db_query( $delete_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => t('Security Group has been deleted: @group_name', array('@group_name' => $group_name)),
      'link'    => '',
      )
    );
    
    return TRUE ;  
  }
  
  return FALSE ;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_describe_security_groups_query($cloud_context) {

  $ec2_lib_security_groups_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  
  return $query =   'SELECT c.owner_id,  c.group_name ,  c.group_description ,  c.permissions  FROM {' . $ec2_lib_security_groups_table . '} c WHERE %s like \'%%%s%%\' '  ;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_download_describe_security_groups($cloud_context) {

  $ec2_lib_security_groups_table            = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  $ec2_lib_security_groups_details_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_DETAILS_TABLE ) ;
  $myclient = aws_ec2_api_describe_security_groups($cloud_context) ;
  if ( $myclient->code != 200  )
    return FALSE ;

  $obj_response = new SimpleXMLElement($myclient->data);
  
  db_query( 'truncate table {' . $ec2_lib_security_groups_table . '}' , NULL );
  db_query( 'truncate table {' . $ec2_lib_security_groups_details_table . '}' , NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_security_groups_table . '} 
                  ( `owner_id` ,  
                    `group_name` , 
                    `group_description` , 
                    `permissions`
                  )  values '; 
  

  $sg_details_insert_query = 'INSERT INTO {' . $ec2_lib_security_groups_details_table . '}
                  ( `group_name` ,
                    `ip_protocol` ,
                    `from_port` ,
                    `to_port` ,
                    `user_id` ,
                    `tgt_group_name` ,
                    `cidr_ip` 
                  )  values ';

  // User Activity Log
  cloud_audit_user_activity( array(
      'type' => 'user_activity', 
      'message' => 'Updated: Security Group(s)', 
      'link' => ''
    )
  );

  $count = 0 ;
  $query_args = array() ;
  $query_details_args = array() ;
  
  foreach ($obj_response->securityGroupInfo->item as $item) {

    $insert_query = $insert_query . "  (  '%s', '%s', '%s', '%s' ) ," ;
    $query_args[] = $item->ownerId   ;
    $query_args[] = $item->groupName ;
    $query_args[] = $item->groupDescription ;
    $query_args[] = '' ;
    
    $permissions = '' ;
    
    foreach ($item->ipPermissions->item as $perm_item) {

      $from_port        = $perm_item->fromPort;
      $to_port          = $perm_item->toPort ;
      $ip_protocol      = $perm_item->ipProtocol ;

      if ( isset($perm_item->ipRanges) ) {
        foreach ($perm_item->ipRanges->item as $cidr_ip_item) {

             $sg_details_insert_query   = $sg_details_insert_query . "  (  '%s', '%s', '%s', '%s' , '%s', '%s', '%s' ) ," ;
             $query_details_args[]      = $item->groupName   ;
             $query_details_args[]      = $ip_protocol ;
             $query_details_args[]      = $from_port ;
             $query_details_args[]      = $to_port ;
             $query_details_args[]      = '' ; // Since this is for cidr_ip user_id is empty
             $query_details_args[]      = ''; // Since this is for cidr_ip group_name is empty
             $query_details_args[]      = $cidr_ip_item->cidrIp ;
        }
      }

      if ( isset($perm_item->groups) ) {

          foreach ($perm_item->groups->item as $grp_item) {

             $sg_details_insert_query   = $sg_details_insert_query . "  (  '%s', '%s', '%s', '%s' , '%s', '%s', '%s' ) ," ;
             $query_details_args[]      = $item->groupName   ;
             $query_details_args[]      = $ip_protocol ;
             $query_details_args[]      = $from_port ;
             $query_details_args[]      = $to_port ;
             $query_details_args[]      = $grp_item->userId ;
             $query_details_args[]      = $grp_item->groupName ;
             $query_details_args[]      = '' ; // Since this is for group user_id is empty
          }
      }
    }

    $count++ ;
  }

  if ( $count == 0 )
    return TRUE;
  
  $insert_query = substr($insert_query, 0, -1);
  db_query( $insert_query, $query_args );

  $last_char = substr( $sg_details_insert_query , -1);
  if (  $last_char === ',' ) {  // Execute the insert data present

      $sg_details_insert_query = substr($sg_details_insert_query, 0, -1);
      db_query( $sg_details_insert_query, $query_details_args );
  }

  return TRUE;
  
 
  
  if ( $count == 0 )
    return TRUE;
    
  $insert_query = substr($insert_query, 0, -1);    
  db_query( $insert_query, $query_args );
  
  return TRUE;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_security_groups($cloud_context) {

  $security_group_options = array();
  $query        = _aws_ec2_lib_get_describe_security_groups_query($cloud_context) ;
  $query_args   = array() ;
  $query_args[] = 'group_name' ;

  $security_group_result = db_query( $query, $query_args );

  while ($sg = db_fetch_object($security_group_result)) {

    $security_group_options[$sg->group_name] = drupal_strtolower($sg->group_name) ;
  }
  asort( $security_group_options);
  return $security_group_options ;
}



/**
 *
 * @param     $cloud_context
 * @return
 */
function _aws_ec2_lib_get_security_groups_details_db($cloud_context, $sg_name='' ) {

  $ec2_lib_security_groups_details_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_DETAILS_TABLE ) ;
  $security_group_details = array();

  $query_args   = array() ;
  $query = '' ;
  
  if ( empty($sg_name) ) {
  
      $query        =  'SELECT *  FROM {' . $ec2_lib_security_groups_details_table . '} c '  ;
  }
  else {

      $query        =  'SELECT *  FROM {' . $ec2_lib_security_groups_details_table . '} c WHERE group_name=\'%s\' '  ;
      $query_args[] = $sg_name ;
      $security_group_details[$sg_name] = array() ;
  }

  $query        .=   ' order by ip_protocol desc ' ;
  $security_groups_details_result = db_query( $query, $query_args );

  $cnt = 0 ;
  while ($sg_details = db_fetch_object($security_groups_details_result)) {

    if (isset($security_group_details[$sg_details->group_name]) === FALSE )  {
    
        $security_group_details[$sg_details->group_name] = array() ;
    }

    $security_group_details[$sg_details->group_name][$cnt] = array() ;
    $security_group_details[$sg_details->group_name][$cnt]['group_name'    ]      = $sg_details->group_name ;
    $security_group_details[$sg_details->group_name][$cnt]['ip_protocol'   ]      = $sg_details->ip_protocol ;
    $security_group_details[$sg_details->group_name][$cnt]['from_port'     ]      = $sg_details->from_port ;
    $security_group_details[$sg_details->group_name][$cnt]['to_port'       ]      = $sg_details->to_port ;
    $security_group_details[$sg_details->group_name][$cnt]['user_id'       ]      = $sg_details->user_id ;
    $security_group_details[$sg_details->group_name][$cnt]['tgt_group_name']      = $sg_details->tgt_group_name ;
    $security_group_details[$sg_details->group_name][$cnt]['cidr_ip'       ]      = $sg_details->cidr_ip ;
    $cnt++ ;
  }
  
  return $security_group_details ;
}


/**
 *
 * @param   $cloud_context
 * @return
 */
function _aws_ec2_lib_get_security_groups_list_count($cloud_context) {

  $ec2_lib_security_groups_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SECURITY_GROUPS_TABLE ) ;
  if (empty($ec2_lib_security_groups_table) ) {

    return TRUE ;
  }
  
  $query    = 'SELECT count(*) as sg_count FROM {' . $ec2_lib_security_groups_table . '} c '  ;
  $result   = db_query( $query, NULL );
  $sg_count = 0 ;

  while ($sg = db_fetch_object($result)) {

    $sg_count = $sg->sg_count ;
  }

  return $sg_count ;
}


// End : DB functions Related to Security Groups  
