<?php

/**
 * @file
 * DB functions Related to Snapshot for Amazon EC2
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */

/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_describe_snapshots_query($cloud_context) {

  $ec2_lib_snapshot_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;
  $ec2_lib_ebs_volumes_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  
  return $query = 'SELECT c.snapshot_id, vol.nickname as vol_nickname , c.nickname, c.volume_id, c.status, c.created, c.progress FROM {' . $ec2_lib_snapshot_table . '} c LEFT JOIN
                     {' . $ec2_lib_ebs_volumes_table . '} vol
                    on c.volume_id = vol.volume_id WHERE c.%s like \'%%%s%%\' ' ;
}




/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_snapshots_list_count($cloud_context) {

  $ec2_lib_snapshot_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;

  $query      = 'SELECT COUNT(*) as item_count FROM {' . $ec2_lib_snapshot_table . '}' ;
  $result     = db_query( $query, NULL );
  $item_count = 0;

  while ($item = db_fetch_object($result)) {
  
    $item_count = $item->item_count ;
  }

  return $item_count ;
}


function _aws_ec2_lib_get_count_name_snapshots_query($cloud_context) {

  $ec2_lib_snapshot_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;

  return $query = 'SELECT count(*) as count FROM {' . $ec2_lib_snapshot_table . '} c WHERE %s =\'%s\'  ' ;
}


/**
 *
 * @param     $cloud_context
 * @param     $ss_id
 * @return     
 */
function _aws_ec2_lib_get_snapshots_by_id_db($cloud_context, $ss_id) {

  $ec2_lib_snapshot_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;
  $ec2_lib_ebs_volumes_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_EBS_VOLUMES_TABLE ) ;
  
  $query =  'select snap.nickname    as snap_nickname  , 
                    snap.snapshot_id as snapshot_id    ,
                    snap.status      as snap_status    ,
                    snap.volume_id   as snap_volume_id ,
                    snap.created     as snap_created   ,
                    vol.nickname as vol_nickname ,
                    snap.volume_size as vol_size ,
                    vol.vol_zone as vol_zone
                    from
                    ( SELECT c.snapshot_id,  c.nickname,   c.volume_id,  c.status,  c.created,  c.progress, c.volume_size FROM {' . $ec2_lib_snapshot_table . '} c
                    WHERE c.snapshot_id=\'%s\'  ) snap
                    LEFT JOIN
                     {' . $ec2_lib_ebs_volumes_table . '} vol
                    on snap.volume_id = vol.volume_id
                    ' ;
  $query_args = array(
    $ss_id,
  ) ;
  
  $result_arr = array() ;
  $db_result  = db_query( $query, $query_args ) ;
  while ($row = db_fetch_array($db_result)) {

     foreach ($row as $key => $val) {

        $result_arr[$key]=$val ;
    }
  }

  return $result_arr ;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_download_describe_snapshots($cloud_context) {
  
  $ec2_lib_snapshot_table = aws_ec2_lib_get_table_info( $cloud_context, AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;
  $myclient               = aws_ec2_api_describe_snapshots($cloud_context) ;

  if ( $myclient->code != 200  )
    return FALSE ;
  
  $obj_response   = new SimpleXMLElement($myclient->data);
  
  $id_nick_arr = cloud_get_all_nickname('snapshot_id', 'nickname', $ec2_lib_snapshot_table ) ;
  db_query( 'truncate table {' . $ec2_lib_snapshot_table . '}',  NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_snapshot_table . '} 
                  ( `snapshot_id` ,  
                    `nickname`    ,  
                    `volume_id`   ,  
                    `status`      , 
                    `created`     ,  
                    `progress`    , 
                    `owner_id`    , 
                    `volume_size` , 
                    `description` 
                  )  values 
          '; 
  
  $count = 0 ;   
  
  foreach ($obj_response->snapshotSet->item as $item) {
          
    $insert_query = $insert_query . "  (  '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s' ) ," ; 
    $query_args[] = $item->snapshotId                                         ;
    $tmp_nickname = cloud_check_in_array($id_nick_arr, $item->snapshotId)     ;
    $query_args[] = $tmp_nickname != NULL ? $tmp_nickname : $item->snapshotId ;
    $query_args[] = $item->volumeId                                           ;
    $query_args[] = $item->status                                             ;
    $query_args[] = $item->startTime                                          ;
    $query_args[] = $item->progress                                           ;
    $query_args[] = isset($item->ownerId     ) ? $item->ownerId     : ''      ;
    $query_args[] = isset($item->volumeSize  ) ? $item->volumeSize  : ''      ;
    $query_args[] = isset($item->description ) ? $item->description : ''      ;
    $count++ ;
  }

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity', 
      'message' => 'Updated: Snapshot(s)', 
      'link'    => '',
    )
  );   
  
  if ( $count == 0 )
    return TRUE;
    
  $insert_query = substr($insert_query, 0, -1);    
  
  db_query( $insert_query, $query_args );
  
  return TRUE;
}


/**
 *
 * @param     $cloud_context
 * @param     $myclient
 * @param     $ss_name
 * @param     $ss_desc
 * @return     
 */
function _aws_ec2_lib_save_create_snapshot($cloud_context, $myclient, $ss_name, $ss_desc) {
  
  if ( $myclient->code != 200 )
    return FALSE ;
    
  $ec2_lib_snapshot_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;
  
  if ( isset($myclient->data) == FALSE )  
    return FALSE;
    
  $obj_response = new SimpleXMLElement($myclient->data);
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_snapshot_table . '} 
                  ( `snapshot_id` ,  
                    `nickname`    ,  
                    `volume_id`   ,  
                    `status`      ,  
                    `created`  ,  
                    `progress`    , 
                    `owner_id`    , 
                    `volume_size` , 
                    `description`  
                  )  values 
          '; 
  
  $item = $obj_response ; 
          
  $insert_query = $insert_query . "  ( '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s', '%s') " ; 
  $query_args[] = $item->snapshotId ;
  $query_args[] = $ss_name          ;
  $query_args[] = $item->volumeId   ;
  $query_args[] = $item->status     ;
  $query_args[] = $item->startTime  ;
  $query_args[] = $item->progress   ;
  $query_args[] = isset($item->ownerId)    ? $item->ownerId     : '' ;
  $query_args[] = isset($item->volumeSize) ? $item->volumeSize  : '' ;
  $query_args[] = isset($ss_desc)          ? $ss_desc           : '' ;
  
  db_query( $insert_query, $query_args );
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => t('Snapshot has been added: @snapshot_name', array('@snapshot_name' => $ss_name)), 
      'link'    => '',
    )
  ); 

  return TRUE ;
}


/**
 *
 * @param     $cloud_context
 * @param     $result
 * @param     $ss_id
 * @return     
 */
function _aws_ec2_lib_delete_snapshot_db($cloud_context, $result, $ss_id ) {

  if ( $result->code != 200 )
    return FALSE ;
    
  $ec2_lib_snapshot_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;

  $obj_response = new SimpleXMLElement($result->data);
  if ( $obj_response->return == 'true' ) {
  
    $delete_query = 'DELETE FROM {' . $ec2_lib_snapshot_table . "} where snapshot_id='%s' ; " ;
    $query_args[] = $ss_id ;
    db_query( $delete_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity', 
        'message' => t('Snapshot has been deleted: @snapshot_id', array('@snapshot_id' => $ss_id)), 
        'link'    => '',
      )
    );
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity',
        'message' => 'Updated: User Key(s)',
        'link'    => '',
      )
    );
    
    return TRUE ;  
  }
  
  return FALSE ;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_snapshot_options($cloud_context) {
  
  $snapshot_options = array(
    AWS_EC2_LIB_CLOUD_NONE => AWS_EC2_LIB_CLOUD_NONE,
  );
  
  $query = _aws_ec2_lib_get_describe_snapshots_query($cloud_context) ;
  
  $query_args = array(
    'snapshot_id',
  ) ;
  
  // $query .= tablesort_sql( array(array('field' => 'nickname', 'sort' => 'asc')) ) ;
  $snapshot_result = db_query($query, $query_args) ; 
  
  while ($snap = db_fetch_object($snapshot_result)) {
  
    $snapshot_options[$snap->snapshot_id] = $snap->nickname . ' (' . $snap->snapshot_id . ')' ;
  }
  
  //asort($snapshot_options);
  return $snapshot_options ; 
}


/**
 *
 * @param     $cloud_context
 * @param     $snapshot_id
 * @param     $sql_col
 * @param     $value
 * @return     
 */
function _aws_ec2_lib_snapshot_update($cloud_context , $snapshot_id , $sql_col , $value) {

  $ec2_lib_snapshot_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SNAPSHOTS_TABLE ) ;

  $update_query = 'UPDATE {' . $ec2_lib_snapshot_table . '}
                set `%s`=\'%s\'
                where `snapshot_id`=\'%s\'
          ';

  $query_args = array(
    $sql_col     ,
    $value       ,
    $snapshot_id ,
  ) ;
  
  db_query( $update_query, $query_args );

  return TRUE ;
}

// End : DB functions Related to Snapshot
