<?php

/**
 * @file
 * aws_ec2_lib SSH Key DB
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */
 

/**
 *
 * @param     $cloud_context
 * @param     $result
 * @param     $key_name
 * @return    
 * 
 */
function _aws_ec2_lib_delete_key_pair($cloud_context, $result, $key_name ) {

  if ( $result->code != 200 )
    return FALSE ;
    
  $ec2_lib_ssh_keys_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;

  $obj_response = new SimpleXMLElement($result->data);
  if ( $obj_response->return == 'true' ) {
  
    $delete_query = " delete from {" . $ec2_lib_ssh_keys_table . "} where key_name='%s' ; " ;
    $query_args[] = $key_name ;
    db_query( $delete_query, $query_args );
    
    // User Activity Log
    cloud_audit_user_activity( array(
        'type'    => 'user_activity',
        'message' => t('SSH Key has been deleted: @key_name', array('@key_name' => $key_name)), 
        'link'    => '',
      )
    ); 

    _aws_ec2_lib_remove_user_key($cloud_context , $key_name) ;
    return TRUE ;  
  }
  
  return FALSE ;
}


/**
 *
 * @param     $cloud_context
 * @param     $myclient
 * @return    
 * 
 */
function _aws_ec2_lib_save_new_ssh_keypair($cloud_context, $myclient) {
  
  $ec2_lib_ssh_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;
  
  $obj_response = new SimpleXMLElement($myclient->data);
  $count = 0 ;   
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_ssh_keys_table . '} 
                  ( `key_name` ,  
                    `fingerprint` , 
                    `key_material` 
                  )  values 
          '; 
          
  $insert_query = $insert_query . "  (  '%s', '%s', '%s' ) ; " ; 
  $query_args[] = $obj_response->keyName ;
  $query_args[] = $obj_response->keyFingerprint ;
  $query_args[] = $obj_response->keyMaterial ;
  
  db_query( $insert_query, $query_args );
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => t('SSH Key has been added: @ssh_key', array('@ssh_key' => $obj_response->keyName)),
      'link'    => '',
    )
  );
  _aws_ec2_lib_add_user_key($cloud_context , $obj_response->keyName) ;

  return;
}


/**
 *
 * @param     $params
 * @return    
 * 
 */
function _aws_ec2_lib_get_ssh_key($params) {
  $key = "";

  $key_name = $params['key_name'];
  $cloud_context = $params['cloud_context'];

  $query = aws_ec2_lib_get_ssh_keys_query($cloud_context);
  $query_args[] = $key_name ;
  $result = db_query($query, $query_args);
  
  while ($row = db_fetch_object($result)) {
    $key = $row->key_material ;
  }
  return $key;
}


/**
 *
 * @param     $cloud_context
 * @return    
 * 
 */
function aws_ec2_lib_get_ssh_keys_query($cloud_context) {
  $ec2_lib_ssh_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;
  
  return $query =   'SELECT c.key_name,  c.fingerprint ,  c.key_material FROM {' . $ec2_lib_ssh_keys_table . '} c WHERE key_name=\'%s\'  order by key_name'  ;
}


/**
 *
 * @param     $cloud_context
 * @return    
 * 
 */
function _aws_ec2_lib_get_describe_ssh_keys_query($cloud_context) {

  $ec2_lib_ssh_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;
  return $query =   'SELECT c.key_name,  c.fingerprint ,  c.key_material FROM {' . $ec2_lib_ssh_keys_table . '} c WHERE %s like \'%%%s%%\' '  ;
}


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_download_describe_ssh_keys($cloud_context) {
  
  $ec2_lib_ssh_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;  
  $myclient = aws_ec2_api_describe_keypairs($cloud_context) ;
  if ( $myclient->code != 200  )
    return FALSE ;
    
  $obj_response = new SimpleXMLElement($myclient->data);
  
  $key_material_arr = cloud_get_all_nickname('key_name', 'key_material' , $ec2_lib_ssh_keys_table ) ;
  
  db_query( 'truncate table {' . $ec2_lib_ssh_keys_table . '}' , NULL );
  
  $insert_query = 'INSERT INTO {' . $ec2_lib_ssh_keys_table . '} 
                  ( `key_name` ,  
                    `fingerprint` , 
                    `key_material`
                  )  values 
          '; 

  switch  ($cloud_context) { // Needed for OpenStack
    case AWS_EC2_LIB_OPENSTACK_NOVA_CONTEXT:
      $items = $obj_response->keypairsSet->item
             ? $obj_response->keypairsSet->item
             : $obj_response->keySet->item;
      break;

    default:
      $items = $obj_response->keySet->item;
  }
 
  if ( empty($items) ) {
      
          $items = array() ;
   }
      
  $count = 0 ;   
  foreach ($items as $item) {
          
    $insert_query = $insert_query . " ( '%s', '%s', '%s' ) ," ; 
    $query_args[] = $item->keyName ;
    $query_args[] = $item->keyFingerprint ;
    $tmp_key_material = cloud_check_in_array($key_material_arr, $item->keyName ) ;
    $query_args[] = $tmp_key_material != NULL ? $tmp_key_material :  '' ;
    $count++ ;
  }
  
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => 'Updated: SSH Key(s)', 
      'link'    => '',
    )
  );
  
  if ( $count == 0 )
    return TRUE;
    
  $insert_query = substr($insert_query,  0,  -1);    
  db_query( $insert_query, $query_args );
  
  // save in user-ifno
  _aws_ec2_lib_download_all_user_keys($cloud_context , $query_args) ;
  
  return TRUE ;
}


/**
 *
 * @param     $cloud_context
 * @param     $key_name
 * @param     $key_material
 * @return    
 * 
 */
function _aws_ec2_lib_update_key_material($cloud_context, $key_name, $key_material) {
  
  $ec2_lib_ssh_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE )  ;
  $update_query = 'update {' . $ec2_lib_ssh_keys_table . '} 
                set `key_material`=\'%s\' 
                where `key_name`=\'%s\' 
                ';

  $key_material = str_replace("\r\n",  "\n" , $key_material );
  $query_args[] = trim($key_material) ; 
  $query_args[] = $key_name ; 
  
  db_query( $update_query, $query_args );
    
  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => t('SSH Key has been modified: @key_name', array('@key_name' => $key_name)), 
      'link'    => '',
    )
  );

  return;
}

/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_ssh_keys($cloud_context) {

  $query      = _aws_ec2_lib_get_describe_ssh_keys_query($cloud_context) ;
  $query_args = array(
    'key_name',
  ) ;

  //$query .= tablesort_sql( array(array('field' => 'key_name', 'sort' => 'asc')) ) ;
  $ssh_keys_result = db_query( $query, $query_args );

  $ssh_key_options = array(
    '-1' => AWS_EC2_LIB_CLOUD_NONE,
  );
  
  while ($ssh_key = db_fetch_object($ssh_keys_result)) {

    $ssh_key_options[$ssh_key->key_name] = drupal_strtolower($ssh_key->key_name);
  }
  asort( $ssh_key_options);
  return $ssh_key_options ;
}


/**
 *
 * @param   $cloud_context
 * @return
 */
function _aws_ec2_lib_get_ssh_keys_list_count($cloud_context) {

  $ec2_lib_ssh_keys_table = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_SSH_KEYS_TABLE ) ;
  if (empty($ec2_lib_ssh_keys_table) ) {

    return TRUE ;
  }

  $query     = 'SELECT COUNT(*) as ssh_count FROM {' . $ec2_lib_ssh_keys_table . '}'  ;
  $result    = db_query( $query, NULL );
  $ssh_count = 0 ;

  while ($ssh = db_fetch_object($result)) {

    $ssh_count = $ssh->ssh_count ;
  }

  return $ssh_count ;
}


// End : DB functions Related to SSH Keys

