<?php 

/**
 * @file
 * EC2_lib User Keys DB
 *
 * Copyright (c) 2010-2011 DOCOMO Communications Laboratories USA, Inc.
 * 
 */

 
// Start : DB functions Related to User Info keys
// This should be in sync with the ssh keys table


/**
 *
 * @param     $cloud_context
 * @param     $ssh_keys
 * @return     
 */
function _aws_ec2_lib_download_all_user_keys($cloud_context, $ssh_keys) {

  $ec2_lib_user_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_USER_KEYS_TABLE ) ;

  $user_key_arr = cloud_get_all_nickname('key_name' , 'owner' , $ec2_lib_user_keys_table) ;

  db_query( 'DELETE FROM {' . $ec2_lib_user_keys_table . "}" , NULL);

  $insert_query = 'INSERT INTO {' . $ec2_lib_user_keys_table . '} 
                  ( `key_name` ,  
                    `owner` 
                  )  values 
          ';

  $query_args = array() ;

  $len = sizeof($ssh_keys) ;
  $count = 0 ;

  while ($count < $len) {

    $insert_query = $insert_query . "  (  '%s', '%s' ) ," ;
    $query_args[] = $ssh_keys[$count] ;

    $tmp_key = cloud_check_in_array($user_key_arr, $ssh_keys[$count]) ;
    $query_args[] = $tmp_key == NULL ? $ssh_keys[$count] : $tmp_key ;

    $count = $count + 3 ;
  } 

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => 'Updated: User Key(s)',
      'link'    => '',
    )
  ); 

  $insert_query = substr($insert_query, 0, -1);
  db_query( $insert_query, $query_args );

  return TRUE ;
} 


/**
 * Store the user Key
 * @global     $user
 * @param     $cloud_context
 * @param     $key
 * @return     
 */
function _aws_ec2_lib_add_user_key($cloud_context, $key) {

  $ec2_lib_user_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_USER_KEYS_TABLE ) ;
  global $user;

  $owner = NULL ;
  if ( isset( $user->name ) ) {
  
    $owner = $user->name ;
  }
  

  if ($owner == NULL || empty($owner)) {
    $owner = $key ;
  } 

  db_query( 'DELETE FROM {' . $ec2_lib_user_keys_table . "} where key_name='%s'" , array($key));

  $insert_query = "INSERT INTO {" . $ec2_lib_user_keys_table . "} 
                  ( `key_name` ,  
                    `owner` 
                  )  values (  '%s', '%s' )  ";

  $query_args[] = $key ;
  $query_args[] = $owner ;

  db_query( $insert_query, $query_args ); 

  // User Activity Log
  cloud_audit_user_activity( array(
      'type'    => 'user_activity',
      'message' => t('User Key has been added: @key', array('@key' => $key)),
      'link'    => '',
    )
  );   // //
  return;
} 


/**
 *
 * @global     $user
 * @param     $cloud_context
 * @param     $key
 * @return     
 */
function _aws_ec2_lib_remove_user_key($cloud_context, $key) {

  $ec2_lib_user_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_USER_KEYS_TABLE ) ;
  global $user;

  $owner = $user -> name ;

  db_query( 'DELETE FROM {' . $ec2_lib_user_keys_table . "} where key_name='%s'" , array($key));

  return;
} 


/**
 *
 * @param     $cloud_context
 * @return     
 */
function _aws_ec2_lib_get_user_keys_query($cloud_context) {

  $ec2_lib_user_keys_table    = aws_ec2_lib_get_table_info( $cloud_context , AWS_EC2_LIB_USER_KEYS_TABLE ) ;

  return $query = 'SELECT c.key_name,  c.owner from {' . $ec2_lib_user_keys_table . '} c WHERE key_name=\'%s\'  ' ;
} 


/**
 *
 * @global     $user
 * @param     $cloud_context
 * @param     $source
 * @return     
 */
function _aws_ec2_lib_check_key($cloud_context, $source) {

  global $user ;

  $user_keys_all = array() ;
  $user_keys_all[] = $user -> name ;
  $query = _aws_ec2_lib_get_user_keys_query($cloud_context) ;
  $query_args[] = $user -> name ;
  $result_keys = db_query( $query, $query_args );

  while ($key = db_fetch_object($result_keys)) {
    $user_keys_all[] = $key -> key_name ;
  } 

  if (in_array($source, $user_keys_all)) {
    return TRUE ;
  } 

  return FALSE ;
} 


/**
 *
 * @global     $user
 * @param     $cloud_context
 * @return     
 */
function aws_ec2_lib_get_all_keys($cloud_context) {
  global $user ;
  $user_keys_all = array() ;
  $user_keys_all[] = $user -> name ;

  $query = _aws_ec2_lib_get_user_keys_query($cloud_context) ;
  $query_args[] = $user -> name ;
  $result_keys = db_query( $query, $query_args );

  while ($key = db_fetch_object($result_keys)) {
    $user_keys_all[] = $key -> key_name ;
  } 
  return $user_keys_all ;
} 
// End : DB functions Related to User Info keys

