(function ($, Drupal) {

  "use strict";

  Drupal.behaviors.axeptio = {
    attach: function (context, settings) {

      $(context).find("body").once("axeptio").each(function () {

        window.axeptioSettings = settings.axeptio;

        (function (d, s) {
          var t = d.getElementsByTagName(s)[0], e = d.createElement(s);
          e.async = true;
          e.src = "//static.axept.io/sdk.js";
          t.parentNode.insertBefore(e, t);
        })(document, "script");

      });

      // iframe management.
      void 0 === window._axcb && (window._axcb = []);
      window._axcb.push(function(axeptio) {
        axeptio.on("cookies:complete", function(choices) {

          var vendors = {};
          $.each(choices,function(vendor,values){
            vendors[vendor.toLowerCase()] = values
          });

          console.log(vendors);

          document.querySelectorAll("[data-requires-vendor-consent]").forEach(function (el) {
            var vendor = el.getAttribute("data-requires-vendor-consent");
            if (vendors[vendor]) {
              el.setAttribute("src", el.getAttribute("data-src"));
            }
          });

        });
      });

    }

  };

})(jQuery, Drupal);
