<?php


namespace Drupal\axeptio;


use Drupal\Core\Config\ConfigFactoryInterface;

class Axeptio implements AxeptioInterface {

  /**
   * @var \Drupal\Core\Config\ConfigFactoryInterface
   */
  protected $configFactory;

  /**
   * @var \Drupal\Core\Config\ImmutableConfig
   */
  protected $config;

  /**
   * Axeptio constructor.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   */
  public function __construct(ConfigFactoryInterface $configFactory) {
    $this->configFactory = $configFactory;

    $this->config = $configFactory->get('axeptio.settings');
  }

  /**
   * {@inheritdoc}
   */
  public function getId() {
    return $this->config->get('id');
  }

  /**
   * {@inheritdoc}
   */
  public function isLanguageSpecific() {
    return (bool) $this->config->get('language_specific');
  }

  /**
   * {@inheritdoc}
   */
  public function getCookiesVersion($admin = FALSE) {
    $cookies_version = $this->config->get('cookies_version');
    if ($admin || !$this->isLanguageSpecific()) {
      return $cookies_version;
    }

    $language = \Drupal::languageManager()->getCurrentLanguage();
    return $cookies_version . '-' . $language->getId();
  }

  /**
   * {@inheritdoc}
   */
  public function getCookiesDuration() {
    return (int) $this->config->get('cookies_duration');
  }

  /**
   * {@inheritdoc}
   */
  public function getCookiesSecure() {
    return (bool) $this->config->get('cookies_secure');
  }

  /**
   * {@inheritdoc}
   */
  public function isConfigured() {
    return $this->getId() && $this->getCookiesVersion();
  }

}
