<?php


namespace Drupal\axeptio;


class AxeptioIframe {

  /**
   * @var \Drupal\axeptio\AxeptioInterface
   */
  protected $axeptio;

  /**
   * AxeptioIframe constructor.
   *
   * @param \Drupal\axeptio\AxeptioInterface $axeptio
   *  The Axeptio main service.
   */
  public function __construct(AxeptioInterface $axeptio) {
    $this->axeptio = $axeptio;
  }

  /**
   * Convert iframe content to compatible Axeptio format.
   *
   * @param string $iframe
   */
  public function iframeToAxeptio($iframe) {
    // Extract source from iframe.
    preg_match('/src="((?:https?:\/\/)?(?:\/)?[a-zA-Z0-9]+\.\S{2,})"/', $iframe, $source_matches);
    if (empty($source_matches)) {
      return FALSE;
    }

    $source = $source_matches[0];

    // Get the source vendor.
    $vendor = $this->getVendor($source_matches[1]);
    //@todo: Adds availability to exclude vendor.

    // Replace the base source per the Axeptio version.
    return str_replace($source, 'src="" data-requires-vendor-consent="' . $vendor . '" data-src="' . $source_matches[1] . '"', $iframe);
  }

  /**
   * Retrieve the vendor of the given source.
   *
   * @param string $source
   *
   * @return false|string
   */
  public function getVendor($source) {

    $vendors = [
      'youtube' => '/youtube/',
      'dailymotion' => '/dailymotion/',
    ];

    foreach ($vendors as $vendor => $pattern) {
      if (preg_match($pattern, $source)) {
        return strtolower($vendor);
      }
    }

    $parsed = parse_url($source);
    preg_match('/(?:https?:\/\/)?(?:[a-zA-Z0-9]+\.)?([a-zA-Z0-9]+)\.\S{2,}/', $parsed['host'], $matches);

    if (count($matches) == 2) {
      return strtolower($matches[1]);
    }

    return FALSE;
  }

}
