<?php

namespace Drupal\axeptio;

interface AxeptioInterface {

  /**
   * Return the Axeptio ID.
   *
   * @return string|null
   */
  public function getId();

  /**
   * Indicate if the cookies is language specific.
   *
   * @return bool
   */
  public function isLanguageSpecific();

  /**
   * Return the Axeptio cookies version.
   *
   * @return string|null
   */
  public function getCookiesVersion($admin = FALSE);

  /**
   * Return the Axeptio cookies duration.
   *
   * @return int|null
   */
  public function getCookiesDuration();

  /**
   * Indicate if the cookie holding choices is HTTPS only.
   *
   * @return bool
   */
  public function getCookiesSecure();

  /**
   * Checks if the module if configured.
   *
   * @return bool
   */
  public function isConfigured();
}
