<?php


namespace Drupal\axeptio\Form;


use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['axeptio.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'axeptio_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state);
    $config = $this->config('axeptio.settings');

    $form['id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Id'),
      '#default_value' => $config->get('id'),
      '#required' => TRUE,
    ];

    $form['cookies_version'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Cookies version'),
      '#default_value' => $config->get('cookies_version'),
      '#required' => TRUE,
    ];

    $form['cookies_duration'] = [
      '#type' => 'number',
      '#title' => $this->t('Cookies duration'),
      '#description' => $this->t('The max life duration of the cookies.'),
      '#default_value' => $config->get('cookies_duration'),
      '#required' => TRUE,
    ];

    $form['cookies_secure'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Cookies secure'),
      '#description' => $this->t('Wether or not the cookie holding choices is HTTPS only.'),
      '#default_value' => $config->get('cookies_secure'),
    ];

    $form['language_specific'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Cookies language specific'),
      '#description' => $this->t('If checked, the version cookies will be completed with the language code like this: xxxxx-en'),
      '#default_value' => $config->get('language_specific'),
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    $fields = [
      'id',
      'cookies_version',
      'cookies_duration',
      'cookies_secure',
      'language_specific',
    ];

    $config = $this->config('axeptio.settings');
    foreach ($fields as $field) {
      $config->set($field, $form_state->getValue($field));
    }
    $config->save();

    parent::submitForm($form, $form_state);
  }
}
