<?php


namespace Drupal\axeptio\Plugin\Filter;


use Drupal\axeptio\AxeptioIframe;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\filter\FilterProcessResult;
use Drupal\filter\Plugin\FilterBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The filter to hide iframe content before.
 *
 * @Filter(
 *   title = @Translation("Axeptio iframe"),
 *   id = "axeptio_iframe",
 *   description = @Translation("Axeptio iframe."),
 *   type = Drupal\filter\Plugin\FilterInterface::TYPE_MARKUP_LANGUAGE
 * )
 */
class Iframe extends FilterBase implements ContainerFactoryPluginInterface {

  /**
   * @var \Drupal\axeptio\AxeptioIframe
   */
  protected $axeptioIframe;

  /**
   * Iframe constructor.
   *
   * @param array $configuration
   * @param $plugin_id
   * @param $plugin_definition
   * @param \Drupal\axeptio\AxeptioIframe $axeptioIframe
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, AxeptioIframe $axeptioIframe) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->axeptioIframe = $axeptioIframe;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('axeptio.iframe')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function process($text, $langcode) {

    // Extract iframe from text.
    preg_match_all('/<iframe(?:.*)>(.*)<\/iframe>/', $text, $matches);

    foreach ($matches[0] as $iframe) {

      $replacement = $this->axeptioIframe->iframeToAxeptio($iframe);
      if ($replacement) {
        $text = str_replace($iframe, $replacement, $text);
      }
    }

    return new FilterProcessResult($text);
  }

}
