<?php

namespace Drupal\azure_blob_fs\StreamWrapper;

/**
 * Defines a Drupal stream wrapper class for use with private scheme.
 *
 * Provides support for storing files on the azure file system with the
 * Drupal file interface.
 */
class PrivateAzureBlobFsStream extends AzureBlobFsStream {

  /**
   * {@inheritdoc}
   */
  public function getName(): string {
    return $this->t('Private Files (Azure Blob Storage)');
  }

  /**
   * {@inheritdoc}
   */
  public function getDescription(): string {
    return $this->t('Private files served from an Azure Blob Storage.');
  }

}
