<?php

namespace Drupal\azure_blob_fs\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\HttpFoundation\Request;

/**
 * Defines a form that configures module settings.
 *
 * @TODO - The current code doesn't even consider this form, and only takes what was entered in settings.php. This needs to be changed, but I'm just trying to get this damned thing working for now.
 */
class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'azure_blob_fs_admin_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return [
      'azure_blob_fs.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state, Request $request = NULL): array {
    $config = $this->config('azure_blob_fs.settings');

    $form['credentials'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Azure Blob Storage Credentials'),
      '#collapsible' => TRUE,
    ];

    $form['credentials']['blob_storage_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Azure Blob Storage URL'),
      '#default_value' => $config->get('blob_storage_url'),
    ];

    $form['credentials']['sas_token'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Azure Blob Storage SAS Token'),
      '#default_value' => $config->get('sas_token'),
    ];

    $form['credentials']['container_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Azure Blob Storage Container Name'),
      '#default_value' => $config->get('container_name'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $values = $form_state->getValues();
    $this->config('azure_blob_fs.settings')
      ->set('sas_token', $values['sas_token'])
      ->set('blob_storage_url', $values['blob_storage_url'])
      ->set('container_name', $values['container_name'])
      ->save();

    parent::submitForm($form, $form_state);
  }

}
