<?php

namespace Drupal\azure_blob_fs\Service;

use Drupal\Core\Config\ConfigFactory;
use Drupal\Core\Site\Settings;

/**
 * Defines a service for the Azure Blob File System module.
 */
class AzureBlobFsService implements AzureBlobFsServiceInterface {

  /**
   * The config factory object.
   *
   * @var \Drupal\Core\Config\ConfigFactory
   */
  protected $configFactory;

  /**
   * Constructs an AzureBlobFsService object.
   *
   * @param \Drupal\Core\Config\ConfigFactory $config_factory
   *   The config factory object.
   */
  public function __construct(ConfigFactory $config_factory) {
    $this->configFactory = $config_factory;
  }

  /**
   * {@inheritdoc}
   */
  public function wired(): bool {
    return Settings::get('azure_blob_fs.enabled')
      && !empty(Settings::get('azure_blob_fs.sas_token'))
      && !empty(Settings::get('azure_blob_fs.blob_storage_url'))
      && !empty(Settings::get('azure_blob_fs.container_name'));
  }

}
