<?php

namespace Drupal\azure_cdn_purge\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Azure CDN settings for this purger.
 */
class AzureCdnPurgeForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'azure_cdn_purge_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'azure_cdn_purge.purge_settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Purge settings.
    $form['manual_purge'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('Manual purge'),
    ];

    $form['manual_purge']['description'] = [
      '#markup' => '<div>' . $this->t('This form allow you to submit manual purge requests to Azure CDN.') . '</div>',
    ];

    $form['manual_purge']['paths'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Paths to purge'),
      '#rows' => 5,
      '#description' => $this->t('Enter one path per line, wildcards are supported.'),
      '#required' => TRUE,
    ];

    $form['actions']['#type'] = 'actions';
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Purge'),
      '#button_type' => 'primary',
    ];

    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    // General config.
    $paths = $form_state->getValue('paths');
    $items = explode("\n", $paths);

    $purgeInvalidationFactory = \Drupal::service('purge.invalidation.factory');
    $purgeProcessors = \Drupal::service('purge.processors');
    $purgePurgers = \Drupal::service('purge.purgers');

    $processor = $purgeProcessors->get('azure_processor');
    $invalidations = [];

    foreach ($items as $item) {
      if (strpos($item, '*') !== FALSE) {
        $invalidations[] = $purgeInvalidationFactory->get('wildcardpath', ltrim($item, '\/'));
      }
      else {
        $invalidations[] = $purgeInvalidationFactory->get('path', ltrim($item, '\/'));
      }
    }

    try {
      $purgePurgers->invalidate($processor, $invalidations);
      \Drupal::messenger()->addMessage($this->t('Purge request successfully sent to Azure CDN.'));
    }
    catch (\Exception $e) {
      // Error.
    }
  }

}
