<?php

namespace Drupal\azure_content_moderator\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Provides a settings form for the azure profanity service.
 */
class AzureContentModeratorSettingsForm extends ConfigFormBase {
  const CONFIG_NAME = 'azure_content_moderator.admin_settings';

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'azure_content_moderator_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      self::CONFIG_NAME,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config(self::CONFIG_NAME);

    $form['api_key'] = [
      '#type' => 'key_select',
      '#title' => $this->t('API key'),
      '#required' => TRUE,
      '#default_value' => $config->get('api_key'),
    ];

    $form['categories'] = [
      '#type' => 'checkboxes',
      '#description' => $this->t('Leave all options unselected to apply all categories.'),
      '#options' => [
        'Hate' => $this->t('Hate'),
        'Sexual' => $this->t('Sexual'),
        'SelfHarm' => $this->t('SelfHarm'),
        'Violence' => $this->t('Violence'),
      ],
      '#default_value' => $config->get('categories'),
      '#title' => $this->t('Categories'),
    ];

    $form['block_list_names'] = [
      '#type' => 'textfield',
      '#description' => $this->t('A comma separated list of block list names. For example "block_list_1, block_list_2"'),
      '#title' => $this->t('Block list names'),
      '#default_value' => $config->get('block_list_names'),
    ];

    $form['halt_on_block_list_hit'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Halt on block list hit'),
      '#default_value' => $config->get('halt_on_block_list_hit'),
    ];

    $toleranceOptions = [
      '1' => '1',
      '2' => '2',
      '3' => '3',
      '4' => '4',
      '5' => '5',
      '6' => '6',
      '7' => '7',
      '8' => '8',
    ];

    $form['hate_tolerance_category'] = [
      '#type' => 'select',
      '#title' => $this->t('Hate Category Tolerance'),
      '#options' => $toleranceOptions,
      '#default_value' => $config->get('hate_tolerance_category'),
      '#description' => $this->t('Select the category level that will trigger a failure for hate.'),
      '#required' => TRUE,
    ];

    $form['self_harm_tolerance_category'] = [
      '#type' => 'select',
      '#title' => $this->t('Self Harm Category Tolerance'),
      '#options' => $toleranceOptions,
      '#default_value' => $config->get('self_harm_tolerance_category'),
      '#description' => $this->t('Select the category level that will trigger a failure for self harm.'),
      '#required' => TRUE,
    ];

    $form['sexual_tolerance_category'] = [
      '#type' => 'select',
      '#title' => $this->t('Sexual Category Tolerance'),
      '#options' => $toleranceOptions,
      '#default_value' => $config->get('sexual_tolerance_category'),
      '#description' => $this->t('Select the category level that will trigger a failure for sexual.'),
      '#required' => TRUE,
    ];

    $form['violence_tolerance_category'] = [
      '#type' => 'select',
      '#title' => $this->t('Violence Category Tolerance'),
      '#options' => $toleranceOptions,
      '#default_value' => $config->get('violence_tolerance_category'),
      '#description' => $this->t('Select the category level that will trigger a failure for violence.'),
      '#required' => TRUE,
    ];

    $form['api_version'] = [
      '#type' => 'date',
      '#title' => $this->t('API Version'),
      '#description' => $this->t('The API version used for the Azure service'),
      '#default_value' => $config->get('api_version'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config(self::CONFIG_NAME)
      ->set('api_key', $form_state->getValue('api_key'))
      ->set('categories', $form_state->getValue('categories'))
      ->set('block_list_names', $form_state->getValue('block_list_names'))
      ->set('halt_on_block_list_hit', $form_state->getValue('halt_on_block_list_hit'))
      ->set('hate_tolerance_category', $form_state->getValue('hate_tolerance_category'))
      ->set('self_harm_tolerance_category', $form_state->getValue('self_harm_tolerance_category'))
      ->set('sexual_tolerance_category', $form_state->getValue('sexual_tolerance_category'))
      ->set('violence_tolerance_category', $form_state->getValue('violence_tolerance_category'))
      ->set('api_version', $form_state->getValue('api_version'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
