(function ($) {
    Drupal.behaviors.attributeMapping = {
      attach: function (context, settings) {
        const table = document.getElementById("attribute-mapping");
        const checkboxes = table.getElementsByClassName("custom-attribute-checkbox");
        const texts = table.getElementsByClassName("form-text");

        for (let i = 0; i < texts.length; i++) {
          texts[i].disabled = true;
        }

        function toggleTextDisabledState() {
          for (let i = 0; i < checkboxes.length; i++) {
            texts[i].disabled = !checkboxes[i].checked;
          }
        }

        for (let i = 0; i < checkboxes.length; i++) {
          checkboxes[i].addEventListener("change", toggleTextDisabledState);
        }

        toggleTextDisabledState();

        function updatePlaceholders() {
          var selectedValue = document.querySelector('input[name="role_options"]:checked').value;
          var formTextInputs = document.querySelectorAll('.js-form-type-textfield .form-text');

          formTextInputs.forEach(function (textInput) {
            if (selectedValue === 'ad_group') {
              textInput.placeholder = 'Enter the (Object Id) from Azure AD';
            } else if (selectedValue === 'department_field') {
              textInput.placeholder = 'Enter a department name';
            }
          });
        }

        updatePlaceholders();
        var radioElements = document.querySelectorAll('.form-boolean-group input[type="radio"]');
        radioElements.forEach(function (radio) {
          radio.addEventListener('change', updatePlaceholders);
        });
      },
    };
  })(jQuery);
