<?php

declare(strict_types=1);

namespace Drupal\Tests\b24_webform\Functional;

use Drupal\Core\Url;
use Drupal\Tests\BrowserTestBase;
use Drupal\user\Entity\User;

/**
 * Test for b24_webform module settings form.
 *
 * @group b24
 */
final class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['b24_webform'];

  /**
   * The test user having access to the module configuration.
   *
   * @var \Drupal\user\Entity\User
   */
  protected User $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser([
      'administer b24 configuration',
      'edit any webform',
    ]);
  }

  /**
   * Test callback.
   */
  public function test(): void {
    // Check if the form is not available for anonymous users.
    $this->drupalGet('/admin/config/b24/webform');
    $this->assertSession()->statusCodeEquals(403);
    // Check if the form is available for users with proper permissions.
    $this->drupalLogin($this->adminUser);
    $this->drupalGet('/admin/config/b24/webform');
    $this->assertSession()->statusCodeEquals(200);
    // Check if we get on a proper page.
    $this->assertSession()
      ->elementExists('xpath', '//h1[text() = "Settings for Webform Export to Bitrix24"]');
    // Check if there is a link to create a handler for an example webform.
    $handler_creation_path = Url::fromRoute('entity.webform.handler.add_form', [
      'webform' => 'contact',
      'webform_handler' => 'b24_webform_handler',
    ])->toString();
    $this->assertSession()
      ->elementExists('xpath', '//a[@href="' . $handler_creation_path . '"]');
    // Create a handler.
    $this->drupalGet($handler_creation_path);
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()
      ->elementExists('xpath', '//p[text() = "Sends submission data to bitrix24."]');
    $this->submitForm(['handler_id' => 'b24_webform_handler'], 'Save');
    $this->drupalGet('/admin/structure/webform/manage/contact/handlers/');
    // Check if there is a new handler in the b24 handlers list.
    $this->drupalGet('/admin/config/b24/webform');
    $this->assertSession()
      ->elementExists('xpath', '//a[@href="' . Url::fromRoute('entity.webform.handler.edit_form',
          [
            'webform' => 'contact',
            'webform_handler' => 'b24_webform_handler',
          ]
        )->toString() . '"]');
  }

}
