<?php

declare(strict_types=1);

namespace Drupal\Tests\b24_contact\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Test description.
 *
 * @group b24_contact
 */
final class SettingsFormTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'claro';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['b24_contact'];

  /**
   * Test callback.
   */
  public function testForm(): void {
    $this->drupalGet('admin/config/b24/contact');
    $this->assertSession()->statusCodeEquals(403);

    $admin_user = $this->drupalCreateUser(['administer b24 configuration']);
    $this->drupalLogin($admin_user);
    $this->drupalGet('admin/config/b24/contact');
    $this->assertSession()->statusCodeEquals(200);

    $this->assertSession()->elementExists('xpath', '//h1[text() = "Settings for Contact Forms Export to Bitrix24"]');
    $this->assertSession()->pageTextContains('Personal contact form');

    $this->submitForm([], 'Save configuration');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('The configuration options have been saved. ');
  }

}
