<?php

namespace Drupal\b24_user\EventSubscriber;

use Drupal\b24_commerce\Event\B24CommerceEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\Core\Database\Connection;

/**
 * Class B24UserEventSubscriber.
 */
class B24UserEventSubscriber implements EventSubscriberInterface {

  /**
   * @var \Drupal\Core\Database\Connection
   */
  protected $database;


  /**
   * Constructs a new B24UserEventSubscriber object.
   */
  public function __construct(Connection $connection) {
    $this->database = $connection;
  }

  /**
   * {@inheritdoc}
   */
  static function getSubscribedEvents() {
    $events['b24_commerce.entity.insert'] = ['onEntityInsert'];

    return $events;
  }

  /**
   * This method is called whenever the b24_commerce.entity.insert event is
   * dispatched.
   * If a contact has been created by b24_commerce module by converting from a
   * lead we add it to our reference table to notify b24_user module.
   *
   * @param B24CommerceEvent $event
   */
  public function onEntityInsert(B24CommerceEvent $event) {
    switch ($event->getName()) {
      case 'contact':
        if ($ext_id = $event->getResponse()) {
          $uid = $event->getOrder()->getCustomerId();
          $this->database->insert('b24_reference')
            ->fields([
              'entity_id' => $uid,
              'bundle' => 'user',
              'ext_id' => $ext_id,
              'ext_type' => 'contact',
              'hash' => '',
            ])->execute();
        }
        break;
    }
  }

}
