<?php

/**
 * @file
 * A specific handler for CH.
 */

$plugin = array(
  'title' => t('Address form (CH add-on)'),
  'format callback' => 'addressfield_format_address_ch_generate',
  'type' => 'address',
  'weight' => -80,
);

function addressfield_format_address_ch_generate(&$format, $address, $context = array()) {
  if ($address['country'] == 'CH' && $context['mode'] == 'form') {
    $format['locality_block']['postal_code']['#wrapper_id'] = $format['#wrapper_id'];
    $format['locality_block']['postal_code']['#process'][] = 'ajax_process_form';
    $format['locality_block']['postal_code']['#process'][] = 'addressfield_format_address_ch_postal_code_process';

    $format['locality_block']['postal_code']['#element_validate'] = array('addressfield_form_ch_postal_code_validation');
    $format['locality_block']['postal_code']['#ajax'] = array(
      'callback' => 'addressfield_standard_widget_refresh',
      'wrapper' => $format['#wrapper_id'],
      'method' => 'replace',
    );
  }
  else {
    if (isset($format['locality_block']['postal_code'])) {
      // Cancel the AJAX for forms we don't control.
      $format['locality_block']['postal_code']['#ajax'] = array();
    }
  }
}

function addressfield_format_address_ch_postal_code_process($element) {
  $element['#limit_validation_errors'] = array($element['#parents']);

  return $element;
}

function addressfield_form_ch_postal_code_validation($element, &$form_state, &$form) {
  $data = array(
    '1000' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1001' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1002' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1003' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1004' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1005' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1006' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1007' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1008' => array('town' => 'Prilly', 'canton' => 'VD'),
    '1009' => array('town' => 'Pully', 'canton' => 'VD'),
    '1010' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1011' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1012' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1014' => array('town' => 'Lausanne Adm cant', 'canton' => 'VD'),
    '1015' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1018' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1020' => array('town' => 'Renens VD', 'canton' => 'VD'),
    '1022' => array('town' => 'Chavannes-Renens', 'canton' => 'VD'),
    '1023' => array('town' => 'Crissier', 'canton' => 'VD'),
    '1024' => array('town' => 'Ecublens VD', 'canton' => 'VD'),
    '1025' => array('town' => 'St-Sulpice VD', 'canton' => 'VD'),
    '1026' => array('town' => 'Echandens-Denges', 'canton' => 'VD'),
    '1027' => array('town' => 'Lonay', 'canton' => 'VD'),
    '1028' => array('town' => 'Préverenges', 'canton' => 'VD'),
    '1030' => array('town' => 'Bussigny-Lausanne', 'canton' => 'VD'),
    '1032' => array('town' => 'Romanel-s-Lausanne', 'canton' => 'VD'),
    '1033' => array('town' => 'Cheseaux-Lausanne', 'canton' => 'VD'),
    '1037' => array('town' => 'Etagnières', 'canton' => 'VD'),
    '1038' => array('town' => 'Bercher', 'canton' => 'VD'),
    '1040' => array('town' => 'Echallens', 'canton' => 'VD'),
    '1377' => array('town' => 'Oulens-Echallens', 'canton' => 'VD'),
    '1042' => array('town' => 'Bettens', 'canton' => 'VD'),
    '1417' => array('town' => 'Epautheyres', 'canton' => 'VD'),
    '1041' => array('town' => 'Dommartin', 'canton' => 'VD'),
    '1063' => array('town' => 'Peyres-Possens', 'canton' => 'VD'),
    '1053' => array('town' => 'Bretigny-Morrens', 'canton' => 'VD'),
    '1034' => array('town' => 'Boussens', 'canton' => 'VD'),
    '1035' => array('town' => 'Bournens', 'canton' => 'VD'),
    '1036' => array('town' => 'Sullens', 'canton' => 'VD'),
    '1043' => array('town' => 'Sugnens', 'canton' => 'VD'),
    '1044' => array('town' => 'Fey', 'canton' => 'VD'),
    '1045' => array('town' => 'Ogens', 'canton' => 'VD'),
    '1407' => array('town' => 'Bioley-Magnoux', 'canton' => 'VD'),
    '1052' => array('town' => 'Mont-sur-Lausanne', 'canton' => 'VD'),
    '1054' => array('town' => 'Morrens VD', 'canton' => 'VD'),
    '1055' => array('town' => 'Froideville', 'canton' => 'VD'),
    '1410' => array('town' => 'Thierrens', 'canton' => 'VD'),
    '1066' => array('town' => 'Epalinges', 'canton' => 'VD'),
    '1073' => array('town' => 'Savigny', 'canton' => 'VD'),
    '1083' => array('town' => 'Mézières VD', 'canton' => 'VD'),
    '1092' => array('town' => 'Belmont-Lausanne', 'canton' => 'VD'),
    '1093' => array('town' => 'La Conversion', 'canton' => 'VD'),
    '1094' => array('town' => 'Paudex', 'canton' => 'VD'),
    '1095' => array('town' => 'Lutry', 'canton' => 'VD'),
    '1096' => array('town' => 'Cully', 'canton' => 'VD'),
    '1097' => array('town' => 'Riex', 'canton' => 'VD'),
    '1098' => array('town' => 'Epesses', 'canton' => 'VD'),
    '1058' => array('town' => 'Villars-Tiercelin', 'canton' => 'VD'),
    '1059' => array('town' => 'Peney-le-Jorat', 'canton' => 'VD'),
    '1061' => array('town' => 'Villars-Mendraz', 'canton' => 'VD'),
    '1062' => array('town' => 'Sottens', 'canton' => 'VD'),
    '1080' => array('town' => 'Les Cullayes', 'canton' => 'VD'),
    '1081' => array('town' => 'Montpreveyres', 'canton' => 'VD'),
    '1082' => array('town' => 'Corcelles-le-Jorat', 'canton' => 'VD'),
    '1088' => array('town' => 'Ropraz', 'canton' => 'VD'),
    '1084' => array('town' => 'Carrouge VD', 'canton' => 'VD'),
    '1085' => array('town' => 'Vulliens', 'canton' => 'VD'),
    '1509' => array('town' => 'Vucherens', 'canton' => 'VD'),
    '1510' => array('town' => 'Syens', 'canton' => 'VD'),
    '1076' => array('town' => 'Ferlens VD', 'canton' => 'VD'),
    '1077' => array('town' => 'Servion', 'canton' => 'VD'),
    '1078' => array('town' => 'Essertes', 'canton' => 'VD'),
    '1673' => array('town' => 'Auboranges', 'canton' => 'FR'),
    '1110' => array('town' => 'Morges', 'canton' => 'VD'),
    '1112' => array('town' => 'Echichens', 'canton' => 'VD'),
    '1167' => array('town' => 'Lussy-sur-Morges', 'canton' => 'VD'),
    '1132' => array('town' => 'Lully VD', 'canton' => 'VD'),
    '1131' => array('town' => 'Tolochenaz', 'canton' => 'VD'),
    '1125' => array('town' => 'Monnaz', 'canton' => 'VD'),
    '1126' => array('town' => 'Vaux-sur-Morges', 'canton' => 'VD'),
    '1127' => array('town' => 'Clarmont', 'canton' => 'VD'),
    '1128' => array('town' => 'Reverolle', 'canton' => 'VD'),
    '1113' => array('town' => 'St-Saphorin-Morges', 'canton' => 'VD'),
    '1114' => array('town' => 'Colombier VD', 'canton' => 'VD'),
    '1115' => array('town' => 'Vullierens', 'canton' => 'VD'),
    '1116' => array('town' => 'Cottens VD', 'canton' => 'VD'),
    '1117' => array('town' => 'Grancy', 'canton' => 'VD'),
    '1304' => array('town' => 'Senarclens', 'canton' => 'VD'),
    '1121' => array('town' => 'Bremblens', 'canton' => 'VD'),
    '1122' => array('town' => 'Romanel-sur-Morges', 'canton' => 'VD'),
    '1123' => array('town' => 'Aclens', 'canton' => 'VD'),
    '1124' => array('town' => 'Gollion', 'canton' => 'VD'),
    '1134' => array('town' => 'Vufflens-Château', 'canton' => 'VD'),
    '1135' => array('town' => 'Denens', 'canton' => 'VD'),
    '1136' => array('town' => 'Bussy-Chardonney', 'canton' => 'VD'),
    '1169' => array('town' => 'Yens', 'canton' => 'VD'),
    '1168' => array('town' => 'Villars-sous-Yens', 'canton' => 'VD'),
    '1144' => array('town' => 'Ballens', 'canton' => 'VD'),
    '1149' => array('town' => 'Berolle', 'canton' => 'VD'),
    '1146' => array('town' => 'Mollens VD', 'canton' => 'VD'),
    '1147' => array('town' => 'Montricher', 'canton' => 'VD'),
    '1142' => array('town' => 'Pampigny', 'canton' => 'VD'),
    '1141' => array('town' => 'Sévery', 'canton' => 'VD'),
    '1143' => array('town' => 'Apples', 'canton' => 'VD'),
    '1145' => array('town' => 'Bière', 'canton' => 'VD'),
    '1148' => array('town' => 'L\'Isle', 'canton' => 'VD'),
    '1162' => array('town' => 'St-Prex', 'canton' => 'VD'),
    '1163' => array('town' => 'Etoy', 'canton' => 'VD'),
    '1164' => array('town' => 'Buchillon', 'canton' => 'VD'),
    '1165' => array('town' => 'Allaman', 'canton' => 'VD'),
    '1166' => array('town' => 'Perroy', 'canton' => 'VD'),
    '1170' => array('town' => 'Aubonne', 'canton' => 'VD'),
    '1172' => array('town' => 'Bougy-Villars', 'canton' => 'VD'),
    '1173' => array('town' => 'Féchy', 'canton' => 'VD'),
    '1174' => array('town' => 'Montherod', 'canton' => 'VD'),
    '1175' => array('town' => 'Lavigny', 'canton' => 'VD'),
    '1176' => array('town' => 'St-Livres', 'canton' => 'VD'),
    '1180' => array('town' => 'Rolle', 'canton' => 'VD'),
    '1182' => array('town' => 'Gilly', 'canton' => 'VD'),
    '1183' => array('town' => 'Bursins', 'canton' => 'VD'),
    '1184' => array('town' => 'Vinzel', 'canton' => 'VD'),
    '1185' => array('town' => 'Mont-sur-Rolle', 'canton' => 'VD'),
    '1186' => array('town' => 'Essertines-Rolle', 'canton' => 'VD'),
    '1187' => array('town' => 'St-Oyens', 'canton' => 'VD'),
    '1189' => array('town' => 'Saubraz', 'canton' => 'VD'),
    '1188' => array('town' => 'Gimel', 'canton' => 'VD'),
    '1195' => array('town' => 'Dully-Bursinel', 'canton' => 'VD'),
    '1196' => array('town' => 'Gland', 'canton' => 'VD'),
    '1197' => array('town' => 'Prangins', 'canton' => 'VD'),
    '1200' => array('town' => 'Genève', 'canton' => 'GE'),
    '1201' => array('town' => 'Genève', 'canton' => 'GE'),
    '1202' => array('town' => 'Genève', 'canton' => 'GE'),
    '1203' => array('town' => 'Genève', 'canton' => 'GE'),
    '1204' => array('town' => 'Genève', 'canton' => 'GE'),
    '1205' => array('town' => 'Genève', 'canton' => 'GE'),
    '1206' => array('town' => 'Genève', 'canton' => 'GE'),
    '1207' => array('town' => 'Genève', 'canton' => 'GE'),
    '1208' => array('town' => 'Genève', 'canton' => 'GE'),
    '1209' => array('town' => 'Genève', 'canton' => 'GE'),
    '1211' => array('town' => 'Genève 1', 'canton' => 'GE'),
    '1212' => array('town' => 'Grand-Lancy', 'canton' => 'GE'),
    '1213' => array('town' => 'Petit-Lancy', 'canton' => 'GE'),
    '1214' => array('town' => 'Vernier', 'canton' => 'GE'),
    '1215' => array('town' => 'Genève', 'canton' => 'GE'),
    '1216' => array('town' => 'Cointrin', 'canton' => 'GE'),
    '1217' => array('town' => 'Meyrin', 'canton' => 'GE'),
    '1218' => array('town' => 'Le Grand-Saconnex', 'canton' => 'GE'),
    '1219' => array('town' => 'Le Lignon', 'canton' => 'GE'),
    '1220' => array('town' => 'Les Avanchets', 'canton' => 'GE'),
    '1222' => array('town' => 'Vésenaz', 'canton' => 'GE'),
    '1223' => array('town' => 'Cologny', 'canton' => 'GE'),
    '1224' => array('town' => 'Chêne-Bougeries', 'canton' => 'GE'),
    '1225' => array('town' => 'Chêne-Bourg', 'canton' => 'GE'),
    '1226' => array('town' => 'Thônex', 'canton' => 'GE'),
    '1227' => array('town' => 'Carouge GE', 'canton' => 'GE'),
    '1228' => array('town' => 'Plan-les-Ouates', 'canton' => 'GE'),
    '1231' => array('town' => 'Conches', 'canton' => 'GE'),
    '1232' => array('town' => 'Confignon', 'canton' => 'GE'),
    '1233' => array('town' => 'Bernex', 'canton' => 'GE'),
    '1234' => array('town' => 'Vessy', 'canton' => 'GE'),
    '1236' => array('town' => 'Cartigny', 'canton' => 'GE'),
    '1237' => array('town' => 'Avully', 'canton' => 'GE'),
    '1239' => array('town' => 'Collex', 'canton' => 'GE'),
    '1241' => array('town' => 'Puplinge', 'canton' => 'GE'),
    '1242' => array('town' => 'Satigny', 'canton' => 'GE'),
    '1243' => array('town' => 'Presinge', 'canton' => 'GE'),
    '1244' => array('town' => 'Choulex', 'canton' => 'GE'),
    '1245' => array('town' => 'Collonge-Bellerive', 'canton' => 'GE'),
    '1246' => array('town' => 'Corsier GE', 'canton' => 'GE'),
    '1247' => array('town' => 'Anières', 'canton' => 'GE'),
    '1248' => array('town' => 'Hermance', 'canton' => 'GE'),
    '1251' => array('town' => 'Gy', 'canton' => 'GE'),
    '1252' => array('town' => 'Meinier', 'canton' => 'GE'),
    '1253' => array('town' => 'Vandoeuvres', 'canton' => 'GE'),
    '1254' => array('town' => 'Jussy', 'canton' => 'GE'),
    '1255' => array('town' => 'Veyrier', 'canton' => 'GE'),
    '1256' => array('town' => 'Troinex', 'canton' => 'GE'),
    '1257' => array('town' => 'La Croix-de-Rozon', 'canton' => 'GE'),
    '1258' => array('town' => 'Perly', 'canton' => 'GE'),
    '1260' => array('town' => 'Nyon', 'canton' => 'VD'),
    '1277' => array('town' => 'Borex', 'canton' => 'VD'),
    '1278' => array('town' => 'La Rippe', 'canton' => 'VD'),
    '1279' => array('town' => 'Chavannes-de-Bogis', 'canton' => 'VD'),
    '1274' => array('town' => 'Grens', 'canton' => 'VD'),
    '1275' => array('town' => 'Chéserex', 'canton' => 'VD'),
    '1276' => array('town' => 'Gingins', 'canton' => 'VD'),
    '1270' => array('town' => 'Trélex', 'canton' => 'VD'),
    '1271' => array('town' => 'Givrins', 'canton' => 'VD'),
    '1272' => array('town' => 'Genolier', 'canton' => 'VD'),
    '1273' => array('town' => 'Le Muids', 'canton' => 'VD'),
    '1268' => array('town' => 'Burtigny', 'canton' => 'VD'),
    '1261' => array('town' => 'Marchissy', 'canton' => 'VD'),
    '1269' => array('town' => 'Bassins', 'canton' => 'VD'),
    '1262' => array('town' => 'Eysins', 'canton' => 'VD'),
    '1263' => array('town' => 'Crassier', 'canton' => 'VD'),
    '1264' => array('town' => 'St-Cergue', 'canton' => 'VD'),
    '1265' => array('town' => 'La Cure', 'canton' => 'VD'),
    '1266' => array('town' => 'Duillier', 'canton' => 'VD'),
    '1267' => array('town' => 'Vich-Coinsins', 'canton' => 'VD'),
    '1281' => array('town' => 'Russin', 'canton' => 'GE'),
    '1283' => array('town' => 'Dardagny', 'canton' => 'GE'),
    '1284' => array('town' => 'Chancy', 'canton' => 'GE'),
    '1285' => array('town' => 'Athenaz (Avusy)', 'canton' => 'GE'),
    '1286' => array('town' => 'Soral', 'canton' => 'GE'),
    '1287' => array('town' => 'Laconnex', 'canton' => 'GE'),
    '1288' => array('town' => 'Aire-la-Ville', 'canton' => 'GE'),
    '1290' => array('town' => 'Versoix', 'canton' => 'GE'),
    '1291' => array('town' => 'Commugny', 'canton' => 'VD'),
    '1292' => array('town' => 'Chambésy', 'canton' => 'GE'),
    '1293' => array('town' => 'Bellevue', 'canton' => 'GE'),
    '1294' => array('town' => 'Genthod', 'canton' => 'GE'),
    '1295' => array('town' => 'Mies-Tannay', 'canton' => 'VD'),
    '1296' => array('town' => 'Coppet', 'canton' => 'VD'),
    '1297' => array('town' => 'Founex', 'canton' => 'VD'),
    '1298' => array('town' => 'Céligny', 'canton' => 'GE'),
    '1299' => array('town' => 'Crans-près-Céligny', 'canton' => 'VD'),
    '1302' => array('town' => 'Vufflens-la-Ville', 'canton' => 'VD'),
    '1307' => array('town' => 'Lussery-Villars', 'canton' => 'VD'),
    '1305' => array('town' => 'Penthalaz', 'canton' => 'VD'),
    '1315' => array('town' => 'La Sarraz', 'canton' => 'VD'),
    '1317' => array('town' => 'Orny', 'canton' => 'VD'),
    '1316' => array('town' => 'Chevilly', 'canton' => 'VD'),
    '1337' => array('town' => 'Vallorbe', 'canton' => 'VD'),
    '1338' => array('town' => 'Ballaigues', 'canton' => 'VD'),
    '1341' => array('town' => 'Orient', 'canton' => 'VD'),
    '1346' => array('town' => 'Les Bioux', 'canton' => 'VD'),
    '1344' => array('town' => 'L\'Abbaye', 'canton' => 'VD'),
    '1342' => array('town' => 'Le Pont', 'canton' => 'VD'),
    '1343' => array('town' => 'Les Charbonnières', 'canton' => 'VD'),
    '1345' => array('town' => 'Le Lieu', 'canton' => 'VD'),
    '1347' => array('town' => 'Le Sentier', 'canton' => 'VD'),
    '1348' => array('town' => 'Le Brassus', 'canton' => 'VD'),
    '1306' => array('town' => 'Daillens', 'canton' => 'VD'),
    '1303' => array('town' => 'Penthaz', 'canton' => 'VD'),
    '1308' => array('town' => 'La Chaux-Cossonay', 'canton' => 'VD'),
    '1313' => array('town' => 'Ferreyres', 'canton' => 'VD'),
    '1321' => array('town' => 'Arnex-sur-Orbe', 'canton' => 'VD'),
    '1318' => array('town' => 'Pompaples', 'canton' => 'VD'),
    '1312' => array('town' => 'Eclépens', 'canton' => 'VD'),
    '1329' => array('town' => 'Bretonnières', 'canton' => 'VD'),
    '1322' => array('town' => 'Croy', 'canton' => 'VD'),
    '1323' => array('town' => 'Romainmôtier', 'canton' => 'VD'),
    '1324' => array('town' => 'Premier', 'canton' => 'VD'),
    '1325' => array('town' => 'Vaulion', 'canton' => 'VD'),
    '1326' => array('town' => 'Juriens', 'canton' => 'VD'),
    '1350' => array('town' => 'Orbe', 'canton' => 'VD'),
    '1352' => array('town' => 'Agiez', 'canton' => 'VD'),
    '1353' => array('town' => 'Bofflens', 'canton' => 'VD'),
    '1354' => array('town' => 'Montcherand', 'canton' => 'VD'),
    '1355' => array('town' => 'L\'Abergement', 'canton' => 'VD'),
    '1356' => array('town' => 'Les Clées', 'canton' => 'VD'),
    '1357' => array('town' => 'Lignerolle', 'canton' => 'VD'),
    '1358' => array('town' => 'Valeyres-Rances', 'canton' => 'VD'),
    '1439' => array('town' => 'Rances', 'canton' => 'VD'),
    '1373' => array('town' => 'Chavornay', 'canton' => 'VD'),
    '1372' => array('town' => 'Bavois', 'canton' => 'VD'),
    '1374' => array('town' => 'Corcelles-Chavorn', 'canton' => 'VD'),
    '1375' => array('town' => 'Penthéréaz', 'canton' => 'VD'),
    '1376' => array('town' => 'Goumoens-la-Ville', 'canton' => 'VD'),
    '1400' => array('town' => 'Yverdon-les-Bains', 'canton' => 'VD'),
    '1401' => array('town' => 'Yverdon-les-Bains', 'canton' => 'VD'),
    '1416' => array('town' => 'Pailly', 'canton' => 'VD'),
    '1418' => array('town' => 'Vuarrens', 'canton' => 'VD'),
    '1420' => array('town' => 'Fiez', 'canton' => 'VD'),
    '1421' => array('town' => 'Fontaines-Grandson', 'canton' => 'VD'),
    '1423' => array('town' => 'Villars-Burquin', 'canton' => 'VD'),
    '1453' => array('town' => 'Mauborget', 'canton' => 'VD'),
    '1429' => array('town' => 'Giez', 'canton' => 'VD'),
    '1430' => array('town' => 'Orges', 'canton' => 'VD'),
    '1431' => array('town' => 'Vugelles-La Mothe', 'canton' => 'VD'),
    '1405' => array('town' => 'Pomy', 'canton' => 'VD'),
    '1406' => array('town' => 'Cronay', 'canton' => 'VD'),
    '1408' => array('town' => 'Prahins', 'canton' => 'VD'),
    '1409' => array('town' => 'Chanéaz', 'canton' => 'VD'),
    '1412' => array('town' => 'Valeyres-Ursins', 'canton' => 'VD'),
    '1413' => array('town' => 'Orzens', 'canton' => 'VD'),
    '1046' => array('town' => 'Rueyres', 'canton' => 'VD'),
    '1404' => array('town' => 'Cuarny', 'canton' => 'VD'),
    '1427' => array('town' => 'Bonvillars', 'canton' => 'VD'),
    '1424' => array('town' => 'Champagne', 'canton' => 'VD'),
    '1415' => array('town' => 'Molondin', 'canton' => 'VD'),
    '1422' => array('town' => 'Grandson', 'canton' => 'VD'),
    '1425' => array('town' => 'Onnens VD', 'canton' => 'VD'),
    '1426' => array('town' => 'Concise', 'canton' => 'VD'),
    '1432' => array('town' => 'Belmont-Yverdon', 'canton' => 'VD'),
    '1433' => array('town' => 'Suchy', 'canton' => 'VD'),
    '1434' => array('town' => 'Ependes VD', 'canton' => 'VD'),
    '1435' => array('town' => 'Essert-Pittet', 'canton' => 'VD'),
    '1436' => array('town' => 'Treycovagnes', 'canton' => 'VD'),
    '1437' => array('town' => 'Suscévaz', 'canton' => 'VD'),
    '1438' => array('town' => 'Mathod', 'canton' => 'VD'),
    '1441' => array('town' => 'Valeyres-Montagny', 'canton' => 'VD'),
    '1442' => array('town' => 'Montagny-Yverdon', 'canton' => 'VD'),
    '1443' => array('town' => 'Champvent', 'canton' => 'VD'),
    '1445' => array('town' => 'Vuiteboeuf', 'canton' => 'VD'),
    '1446' => array('town' => 'Baulmes', 'canton' => 'VD'),
    '1450' => array('town' => 'Ste-Croix', 'canton' => 'VD'),
    '1454' => array('town' => 'L\'Auberson', 'canton' => 'VD'),
    '1452' => array('town' => 'Les Rasses', 'canton' => 'VD'),
    '1462' => array('town' => 'Yvonand', 'canton' => 'VD'),
    '1463' => array('town' => 'Rovray', 'canton' => 'VD'),
    '1464' => array('town' => 'Chavannes-le-Chêne', 'canton' => 'VD'),
    '1468' => array('town' => 'Cheyres', 'canton' => 'FR'),
    '1470' => array('town' => 'Estavayer-le-Lac', 'canton' => 'FR'),
    '1473' => array('town' => 'Font', 'canton' => 'FR'),
    '1474' => array('town' => 'Châbles FR', 'canton' => 'FR'),
    '1483' => array('town' => 'Montet (Broye)', 'canton' => 'FR'),
    '1482' => array('town' => 'Cugy FR', 'canton' => 'FR'),
    '1541' => array('town' => 'Bussy FR', 'canton' => 'FR'),
    '1484' => array('town' => 'Aumont', 'canton' => 'FR'),
    '1485' => array('town' => 'Nuvilly', 'canton' => 'FR'),
    '1486' => array('town' => 'Vuissens', 'canton' => 'FR'),
    '1537' => array('town' => 'Champtauroz', 'canton' => 'VD'),
    '1538' => array('town' => 'Treytorrens-Payern', 'canton' => 'VD'),
    '1489' => array('town' => 'Murist', 'canton' => 'FR'),
    '1512' => array('town' => 'Chavannes-s-Moudon', 'canton' => 'VD'),
    '1513' => array('town' => 'Hermenches', 'canton' => 'VD'),
    '1514' => array('town' => 'Bussy-sur-Moudon', 'canton' => 'VD'),
    '1522' => array('town' => 'Oulens-sur-Lucens', 'canton' => 'VD'),
    '1515' => array('town' => 'Villars-le-Comte', 'canton' => 'VD'),
    '1521' => array('town' => 'Curtilles', 'canton' => 'VD'),
    '1523' => array('town' => 'Granges-Marnand', 'canton' => 'VD'),
    '1527' => array('town' => 'Villeneuve FR', 'canton' => 'FR'),
    '1528' => array('town' => 'Surpierre', 'canton' => 'FR'),
    '1529' => array('town' => 'Cheiry', 'canton' => 'FR'),
    '1530' => array('town' => 'Payerne', 'canton' => 'VD'),
    '1532' => array('town' => 'Fétigny', 'canton' => 'FR'),
    '1533' => array('town' => 'Ménières', 'canton' => 'FR'),
    '1534' => array('town' => 'Sassel', 'canton' => 'VD'),
    '1536' => array('town' => 'Combremont-Petit', 'canton' => 'VD'),
    '1526' => array('town' => 'Forel-sur-Lucens', 'canton' => 'VD'),
    '1542' => array('town' => 'Rueyres-les-Prés', 'canton' => 'FR'),
    '1543' => array('town' => 'Grandcour', 'canton' => 'VD'),
    '1544' => array('town' => 'Gletterens', 'canton' => 'FR'),
    '1545' => array('town' => 'Chevroux', 'canton' => 'VD'),
    '1551' => array('town' => 'Vers-chez-Perrin', 'canton' => 'VD'),
    '1552' => array('town' => 'Trey', 'canton' => 'VD'),
    '1553' => array('town' => 'Châtonnaye', 'canton' => 'FR'),
    '1554' => array('town' => 'Sédeilles', 'canton' => 'VD'),
    '1555' => array('town' => 'Villarzel', 'canton' => 'VD'),
    '1682' => array('town' => 'Villars-Bramard', 'canton' => 'VD'),
    '1535' => array('town' => 'Combremont-Grand', 'canton' => 'VD'),
    '1562' => array('town' => 'Corcelles-Payerne', 'canton' => 'VD'),
    '1563' => array('town' => 'Dompierre FR', 'canton' => 'FR'),
    '1564' => array('town' => 'Domdidier', 'canton' => 'FR'),
    '1565' => array('town' => 'Missy', 'canton' => 'VD'),
    '1475' => array('town' => 'Autavaux', 'canton' => 'FR'),
    '1567' => array('town' => 'Delley', 'canton' => 'FR'),
    '1568' => array('town' => 'Portalban', 'canton' => 'FR'),
    '1566' => array('town' => 'St-Aubin FR', 'canton' => 'FR'),
    '1580' => array('town' => 'Avenches', 'canton' => 'VD'),
    '1582' => array('town' => 'Donatyre', 'canton' => 'VD'),
    '1583' => array('town' => 'Villarepos', 'canton' => 'FR'),
    '1584' => array('town' => 'Villars-le-Grand', 'canton' => 'VD'),
    '1585' => array('town' => 'Salavaux', 'canton' => 'VD'),
    '1586' => array('town' => 'Vallamand', 'canton' => 'VD'),
    '1587' => array('town' => 'Montmagny', 'canton' => 'VD'),
    '1589' => array('town' => 'Chabrey', 'canton' => 'VD'),
    '1588' => array('town' => 'Cudrefin', 'canton' => 'VD'),
    '1595' => array('town' => 'Faoug', 'canton' => 'VD'),
    '1607' => array('town' => 'Palézieux-Village', 'canton' => 'VD'),
    '1610' => array('town' => 'Châtillens', 'canton' => 'VD'),
    '1525' => array('town' => 'Henniez', 'canton' => 'VD'),
    '1524' => array('town' => 'Marnand', 'canton' => 'VD'),
    '1090' => array('town' => 'La Croix (Lutry)', 'canton' => 'VD'),
    '1091' => array('town' => 'Grandvaux', 'canton' => 'VD'),
    '1070' => array('town' => 'Puidoux-Gare', 'canton' => 'VD'),
    '1071' => array('town' => 'Chexbres', 'canton' => 'VD'),
    '1072' => array('town' => 'Forel (Lavaux)', 'canton' => 'VD'),
    '1614' => array('town' => 'Granges (Veveyse)', 'canton' => 'FR'),
    '1615' => array('town' => 'Bossonnens', 'canton' => 'FR'),
    '1616' => array('town' => 'Attalens', 'canton' => 'FR'),
    '1617' => array('town' => 'Remaufens', 'canton' => 'FR'),
    '1618' => array('town' => 'Châtel-St-Denis', 'canton' => 'FR'),
    '1619' => array('town' => 'Les Paccots', 'canton' => 'FR'),
    '1623' => array('town' => 'Semsales', 'canton' => 'FR'),
    '1624' => array('town' => 'La Verrerie', 'canton' => 'FR'),
    '1627' => array('town' => 'Vaulruz', 'canton' => 'FR'),
    '1628' => array('town' => 'Vuadens', 'canton' => 'FR'),
    '1630' => array('town' => 'Bulle', 'canton' => 'FR'),
    '1633' => array('town' => 'Vuippens', 'canton' => 'FR'),
    '1642' => array('town' => 'Sorens', 'canton' => 'FR'),
    '1643' => array('town' => 'Gumefens', 'canton' => 'FR'),
    '1644' => array('town' => 'Avry-devant-Pont', 'canton' => 'FR'),
    '1645' => array('town' => 'Le Bry', 'canton' => 'FR'),
    '1646' => array('town' => 'Echarlens', 'canton' => 'FR'),
    '1647' => array('town' => 'Corbières', 'canton' => 'FR'),
    '1648' => array('town' => 'Hauteville', 'canton' => 'FR'),
    '1656' => array('town' => 'Im Fang', 'canton' => 'FR'),
    '1657' => array('town' => 'Abländschen', 'canton' => 'BE'),
    '1654' => array('town' => 'Cerniat FR', 'canton' => 'FR'),
    '1651' => array('town' => 'Villarvolard', 'canton' => 'FR'),
    '1652' => array('town' => 'Botterens', 'canton' => 'FR'),
    '1638' => array('town' => 'Morlon', 'canton' => 'FR'),
    '1663' => array('town' => 'Moléson-s-Gruyères', 'canton' => 'FR'),
    '1632' => array('town' => 'Riaz', 'canton' => 'FR'),
    '1634' => array('town' => 'La Roche FR', 'canton' => 'FR'),
    '1649' => array('town' => 'Pont-la-Ville', 'canton' => 'FR'),
    '1635' => array('town' => 'La Tour-de-Trême', 'canton' => 'FR'),
    '1636' => array('town' => 'Broc', 'canton' => 'FR'),
    '1637' => array('town' => 'Charmey (Gruyère)', 'canton' => 'FR'),
    '1661' => array('town' => 'Pâquier-Montbarry', 'canton' => 'FR'),
    '1665' => array('town' => 'Estavannens', 'canton' => 'FR'),
    '1667' => array('town' => 'Enney', 'canton' => 'FR'),
    '1669' => array('town' => 'Neirivue', 'canton' => 'FR'),
    '1666' => array('town' => 'Grandvillard', 'canton' => 'FR'),
    '1675' => array('town' => 'Vauderens', 'canton' => 'FR'),
    '1670' => array('town' => 'Ursy', 'canton' => 'FR'),
    '1674' => array('town' => 'Vuarmarens', 'canton' => 'FR'),
    '1678' => array('town' => 'Siviriez', 'canton' => 'FR'),
    '1679' => array('town' => 'Villaraboud', 'canton' => 'FR'),
    '1676' => array('town' => 'Chavannes-Forts', 'canton' => 'FR'),
    '1677' => array('town' => 'Prez-vers-Siviriez', 'canton' => 'FR'),
    '1680' => array('town' => 'Romont FR', 'canton' => 'FR'),
    '1681' => array('town' => 'Billens', 'canton' => 'FR'),
    '1683' => array('town' => 'Brenles', 'canton' => 'VD'),
    '1694' => array('town' => 'Orsonnens', 'canton' => 'FR'),
    '1695' => array('town' => 'Villarlod', 'canton' => 'FR'),
    '1696' => array('town' => 'Vuisternens-Ogoz', 'canton' => 'FR'),
    '1684' => array('town' => 'Mézières FR', 'canton' => 'FR'),
    '1685' => array('town' => 'Villariaz', 'canton' => 'FR'),
    '1687' => array('town' => 'Estévenens', 'canton' => 'FR'),
    '1686' => array('town' => 'Grangettes-Romont', 'canton' => 'FR'),
    '1689' => array('town' => 'Châtelard-p-Romont', 'canton' => 'FR'),
    '1688' => array('town' => 'Sommentier', 'canton' => 'FR'),
    '1626' => array('town' => 'Romanens', 'canton' => 'FR'),
    '1692' => array('town' => 'Massonnens', 'canton' => 'FR'),
    '1625' => array('town' => 'Sâles (Gruyère)', 'canton' => 'FR'),
    '1612' => array('town' => 'Ecoteaux', 'canton' => 'VD'),
    '1613' => array('town' => 'Maracon', 'canton' => 'VD'),
    '1608' => array('town' => 'Oron-le-Châtel', 'canton' => 'VD'),
    '1609' => array('town' => 'St-Martin FR', 'canton' => 'FR'),
    '1611' => array('town' => 'Le Crêt-p-Semsales', 'canton' => 'FR'),
    '1697' => array('town' => 'La Joux FR', 'canton' => 'FR'),
    '1699' => array('town' => 'Bouloz', 'canton' => 'FR'),
    '1700' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1702' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1704' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1705' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1707' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1708' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1763' => array('town' => 'Granges-Paccot', 'canton' => 'FR'),
    '1701' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '1720' => array('town' => 'Corminboeuf', 'canton' => 'FR'),
    '1721' => array('town' => 'Misery-Courtion', 'canton' => 'FR'),
    '1735' => array('town' => 'Giffers', 'canton' => 'FR'),
    '1736' => array('town' => 'St. Silvester', 'canton' => 'FR'),
    '1737' => array('town' => 'Plasselb', 'canton' => 'FR'),
    '1738' => array('town' => 'Sangernboden', 'canton' => 'BE'),
    '1716' => array('town' => 'Schwarzsee', 'canton' => 'FR'),
    '1724' => array('town' => 'Bonnefontaine', 'canton' => 'FR'),
    '1727' => array('town' => 'Corpataux-Magneden', 'canton' => 'FR'),
    '1728' => array('town' => 'Rossens FR', 'canton' => 'FR'),
    '1719' => array('town' => 'Brünisried', 'canton' => 'FR'),
    '1731' => array('town' => 'Ependes FR', 'canton' => 'FR'),
    '1732' => array('town' => 'Arconciel', 'canton' => 'FR'),
    '1733' => array('town' => 'Treyvaux', 'canton' => 'FR'),
    '1712' => array('town' => 'Tafers', 'canton' => 'FR'),
    '1713' => array('town' => 'St. Antoni', 'canton' => 'FR'),
    '1714' => array('town' => 'Heitenried', 'canton' => 'FR'),
    '1715' => array('town' => 'Alterswil FR', 'canton' => 'FR'),
    '1717' => array('town' => 'St. Ursen', 'canton' => 'FR'),
    '1718' => array('town' => 'Rechthalten', 'canton' => 'FR'),
    '1722' => array('town' => 'Bourguillon', 'canton' => 'FR'),
    '1723' => array('town' => 'Marly', 'canton' => 'FR'),
    '1725' => array('town' => 'Posieux', 'canton' => 'FR'),
    '1726' => array('town' => 'Farvagny', 'canton' => 'FR'),
    '1746' => array('town' => 'Prez-vers-Noréaz', 'canton' => 'FR'),
    '1747' => array('town' => 'Corserey', 'canton' => 'FR'),
    '1748' => array('town' => 'Torny-le-Grand', 'canton' => 'FR'),
    '1749' => array('town' => 'Middes', 'canton' => 'FR'),
    '1740' => array('town' => 'Neyruz FR', 'canton' => 'FR'),
    '1741' => array('town' => 'Cottens FR', 'canton' => 'FR'),
    '1744' => array('town' => 'Chénens', 'canton' => 'FR'),
    '1745' => array('town' => 'Lentigny', 'canton' => 'FR'),
    '1742' => array('town' => 'Autigny', 'canton' => 'FR'),
    '1691' => array('town' => 'Villarimboud', 'canton' => 'FR'),
    '1752' => array('town' => 'Villars-sur-Glâne', 'canton' => 'FR'),
    '1753' => array('town' => 'Matran', 'canton' => 'FR'),
    '1754' => array('town' => 'Rosé', 'canton' => 'FR'),
    '1756' => array('town' => 'Onnens FR', 'canton' => 'FR'),
    '1757' => array('town' => 'Noréaz', 'canton' => 'FR'),
    '1690' => array('town' => 'Villaz-St-Pierre', 'canton' => 'FR'),
    '1762' => array('town' => 'Givisiez', 'canton' => 'FR'),
    '1772' => array('town' => 'Grolley', 'canton' => 'FR'),
    '1773' => array('town' => 'Léchelles', 'canton' => 'FR'),
    '1774' => array('town' => 'Cousset', 'canton' => 'FR'),
    '1776' => array('town' => 'Montagny-la-Ville', 'canton' => 'FR'),
    '1795' => array('town' => 'Courlevon', 'canton' => 'FR'),
    '1796' => array('town' => 'Courgevaux', 'canton' => 'FR'),
    '1797' => array('town' => 'Münchenwiler', 'canton' => 'BE'),
    '1794' => array('town' => 'Salvenach', 'canton' => 'FR'),
    '1793' => array('town' => 'Jeuss', 'canton' => 'FR'),
    '1792' => array('town' => 'Cordast', 'canton' => 'FR'),
    '1791' => array('town' => 'Courtaman', 'canton' => 'FR'),
    '1788' => array('town' => 'Praz (Vully)', 'canton' => 'FR'),
    '1789' => array('town' => 'Lugnorre', 'canton' => 'FR'),
    '1782' => array('town' => 'Belfaux', 'canton' => 'FR'),
    '1783' => array('town' => 'Pensier', 'canton' => 'FR'),
    '1784' => array('town' => 'Courtepin', 'canton' => 'FR'),
    '1785' => array('town' => 'Cressier FR', 'canton' => 'FR'),
    '1786' => array('town' => 'Sugiez', 'canton' => 'FR'),
    '1787' => array('town' => 'Môtier (Vully)', 'canton' => 'FR'),
    '1800' => array('town' => 'Vevey', 'canton' => 'VD'),
    '1801' => array('town' => 'Le Mont-Pèlerin', 'canton' => 'VD'),
    '1808' => array('town' => 'Monts-de-Corsier', 'canton' => 'VD'),
    '1809' => array('town' => 'Fenil-sur-Corsier', 'canton' => 'VD'),
    '1802' => array('town' => 'Corseaux', 'canton' => 'VD'),
    '1803' => array('town' => 'Chardonne', 'canton' => 'VD'),
    '1804' => array('town' => 'Corsier-sur-Vevey', 'canton' => 'VD'),
    '1805' => array('town' => 'Jongny', 'canton' => 'VD'),
    '1806' => array('town' => 'St-Légier-Chiésaz', 'canton' => 'VD'),
    '1807' => array('town' => 'Blonay', 'canton' => 'VD'),
    '1814' => array('town' => 'La Tour-de-Peilz', 'canton' => 'VD'),
    '1815' => array('town' => 'Clarens', 'canton' => 'VD'),
    '1816' => array('town' => 'Chailly-Montreux', 'canton' => 'VD'),
    '1817' => array('town' => 'Brent', 'canton' => 'VD'),
    '1820' => array('town' => 'Montreux', 'canton' => 'VD'),
    '1822' => array('town' => 'Chernex', 'canton' => 'VD'),
    '1823' => array('town' => 'Glion', 'canton' => 'VD'),
    '1824' => array('town' => 'Caux', 'canton' => 'VD'),
    '1832' => array('town' => 'Villard-sur-Chamby', 'canton' => 'VD'),
    '1658' => array('town' => 'La Tine', 'canton' => 'VD'),
    '1660' => array('town' => 'Les Moulins', 'canton' => 'VD'),
    '1659' => array('town' => 'Flendruz', 'canton' => 'VD'),
    '1833' => array('town' => 'Les Avants', 'canton' => 'VD'),
    '1844' => array('town' => 'Villeneuve VD', 'canton' => 'VD'),
    '1847' => array('town' => 'Rennaz', 'canton' => 'VD'),
    '1845' => array('town' => 'Noville', 'canton' => 'VD'),
    '1846' => array('town' => 'Chessel', 'canton' => 'VD'),
    '1852' => array('town' => 'Roche VD', 'canton' => 'VD'),
    '1853' => array('town' => 'Yvorne', 'canton' => 'VD'),
    '1854' => array('town' => 'Leysin', 'canton' => 'VD'),
    '1867' => array('town' => 'St-Triphon', 'canton' => 'VD'),
    '1860' => array('town' => 'Aigle', 'canton' => 'VD'),
    '1856' => array('town' => 'Corbeyrier', 'canton' => 'VD'),
    '1862' => array('town' => 'La Comballaz', 'canton' => 'VD'),
    '1866' => array('town' => 'La Forclaz VD', 'canton' => 'VD'),
    '1884' => array('town' => 'Huémoz', 'canton' => 'VD'),
    '1863' => array('town' => 'Le Sépey', 'canton' => 'VD'),
    '1864' => array('town' => 'Vers-l\'Eglise', 'canton' => 'VD'),
    '1865' => array('town' => 'Les Diablerets', 'canton' => 'VD'),
    '1868' => array('town' => 'Collombey', 'canton' => 'VS'),
    '1870' => array('town' => 'Monthey', 'canton' => 'VS'),
    '1871' => array('town' => 'Choëx', 'canton' => 'VS'),
    '1872' => array('town' => 'Troistorrents', 'canton' => 'VS'),
    '1873' => array('town' => 'Val-d\'Illiez', 'canton' => 'VS'),
    '1874' => array('town' => 'Champéry', 'canton' => 'VS'),
    '1875' => array('town' => 'Morgins', 'canton' => 'VS'),
    '1880' => array('town' => 'Bex', 'canton' => 'VD'),
    '1882' => array('town' => 'Les Posses-sur-Bex', 'canton' => 'VD'),
    '1885' => array('town' => 'Chesières', 'canton' => 'VD'),
    '1890' => array('town' => 'St-Maurice', 'canton' => 'VS'),
    '1891' => array('town' => 'Vérossaz', 'canton' => 'VS'),
    '1869' => array('town' => 'Massongex', 'canton' => 'VS'),
    '1895' => array('town' => 'Vionnaz', 'canton' => 'VS'),
    '1897' => array('town' => 'Les Evouettes', 'canton' => 'VS'),
    '1899' => array('town' => 'Torgon', 'canton' => 'VS'),
    '1892' => array('town' => 'Lavey-Village', 'canton' => 'VD'),
    '1893' => array('town' => 'Muraz (Collombey)', 'canton' => 'VS'),
    '1896' => array('town' => 'Vouvry', 'canton' => 'VS'),
    '1898' => array('town' => 'St-Gingolph', 'canton' => 'VS'),
    '1902' => array('town' => 'Evionnaz', 'canton' => 'VS'),
    '1903' => array('town' => 'Collonges', 'canton' => 'VS'),
    '1904' => array('town' => 'Vernayaz', 'canton' => 'VS'),
    '1905' => array('town' => 'Dorénaz', 'canton' => 'VS'),
    '1906' => array('town' => 'Charrat', 'canton' => 'VS'),
    '1907' => array('town' => 'Saxon', 'canton' => 'VS'),
    '1908' => array('town' => 'Riddes', 'canton' => 'VS'),
    '1912' => array('town' => 'Leytron', 'canton' => 'VS'),
    '1911' => array('town' => 'Ovronnaz', 'canton' => 'VS'),
    '1913' => array('town' => 'Saillon', 'canton' => 'VS'),
    '1914' => array('town' => 'Isérables', 'canton' => 'VS'),
    '1918' => array('town' => 'La Tzoumaz', 'canton' => 'VS'),
    '1955' => array('town' => 'Chamoson', 'canton' => 'VS'),
    '1957' => array('town' => 'Ardon', 'canton' => 'VS'),
    '1920' => array('town' => 'Martigny', 'canton' => 'VS'),
    '1921' => array('town' => 'Martigny-Croix', 'canton' => 'VS'),
    '1923' => array('town' => 'Le Trétien', 'canton' => 'VS'),
    '1925' => array('town' => 'Le Châtelard VS', 'canton' => 'VS'),
    '1927' => array('town' => 'Chemin', 'canton' => 'VS'),
    '1929' => array('town' => 'Trient', 'canton' => 'VS'),
    '1928' => array('town' => 'Ravoire', 'canton' => 'VS'),
    '1922' => array('town' => 'Salvan', 'canton' => 'VS'),
    '1926' => array('town' => 'Fully', 'canton' => 'VS'),
    '1932' => array('town' => 'Bovernier', 'canton' => 'VS'),
    '1947' => array('town' => 'Versegères', 'canton' => 'VS'),
    '1941' => array('town' => 'Vollèges', 'canton' => 'VS'),
    '1942' => array('town' => 'Levron', 'canton' => 'VS'),
    '1948' => array('town' => 'Lourtier', 'canton' => 'VS'),
    '1945' => array('town' => 'Liddes', 'canton' => 'VS'),
    '1946' => array('town' => 'Bourg-St-Pierre', 'canton' => 'VS'),
    '1943' => array('town' => 'Praz-de-Fort', 'canton' => 'VS'),
    '1944' => array('town' => 'La Fouly VS', 'canton' => 'VS'),
    '1933' => array('town' => 'Sembrancher', 'canton' => 'VS'),
    '1934' => array('town' => 'Le Châble VS', 'canton' => 'VS'),
    '1936' => array('town' => 'Verbier', 'canton' => 'VS'),
    '1937' => array('town' => 'Orsières', 'canton' => 'VS'),
    '1938' => array('town' => 'Champex-Lac', 'canton' => 'VS'),
    '1950' => array('town' => 'Sion', 'canton' => 'VS'),
    '1951' => array('town' => 'Sion', 'canton' => 'VS'),
    '1975' => array('town' => 'St-Séverin', 'canton' => 'VS'),
    '1976' => array('town' => 'Erde', 'canton' => 'VS'),
    '1971' => array('town' => 'Grimisuat', 'canton' => 'VS'),
    '1974' => array('town' => 'Arbaz', 'canton' => 'VS'),
    '1961' => array('town' => 'Vernamiège', 'canton' => 'VS'),
    '1973' => array('town' => 'Nax', 'canton' => 'VS'),
    '1968' => array('town' => 'Mase', 'canton' => 'VS'),
    '1969' => array('town' => 'St-Martin VS', 'canton' => 'VS'),
    '1981' => array('town' => 'Vex', 'canton' => 'VS'),
    '1982' => array('town' => 'Euseigne', 'canton' => 'VS'),
    '1984' => array('town' => 'Les Haudères', 'canton' => 'VS'),
    '1986' => array('town' => 'Arolla', 'canton' => 'VS'),
    '1985' => array('town' => 'La Sage', 'canton' => 'VS'),
    '1987' => array('town' => 'Hérémence', 'canton' => 'VS'),
    '1988' => array('town' => 'Les Collons', 'canton' => 'VS'),
    '1991' => array('town' => 'Salins', 'canton' => 'VS'),
    '1992' => array('town' => 'Les Agettes', 'canton' => 'VS'),
    '1993' => array('town' => 'Veysonnaz', 'canton' => 'VS'),
    '1997' => array('town' => 'Siviez (Nendaz)', 'canton' => 'VS'),
    '1996' => array('town' => 'Fey (Nendaz)', 'canton' => 'VS'),
    '1994' => array('town' => 'Aproz (Nendaz)', 'canton' => 'VS'),
    '1962' => array('town' => 'Pont-de-la-Morge', 'canton' => 'VS'),
    '1963' => array('town' => 'Vétroz', 'canton' => 'VS'),
    '1964' => array('town' => 'Conthey', 'canton' => 'VS'),
    '1965' => array('town' => 'Savièse', 'canton' => 'VS'),
    '1966' => array('town' => 'Ayent', 'canton' => 'VS'),
    '1967' => array('town' => 'Bramois', 'canton' => 'VS'),
    '1983' => array('town' => 'Evolène', 'canton' => 'VS'),
    '1972' => array('town' => 'Anzère', 'canton' => 'VS'),
    '2000' => array('town' => 'Neuchâtel', 'canton' => 'NE'),
    '2004' => array('town' => 'Neuchâtel 4', 'canton' => 'NE'),
    '2007' => array('town' => 'Neuchâtel 7', 'canton' => 'NE'),
    '2008' => array('town' => 'Neuchâtel', 'canton' => 'NE'),
    '2009' => array('town' => 'Neuchâtel 9', 'canton' => 'NE'),
    '2001' => array('town' => 'Neuchâtel 1', 'canton' => 'NE'),
    '2002' => array('town' => 'Neuchâtel 2', 'canton' => 'NE'),
    '2003' => array('town' => 'Neuchâtel 3', 'canton' => 'NE'),
    '2006' => array('town' => 'Neuchâtel 6', 'canton' => 'NE'),
    '2012' => array('town' => 'Auvernier', 'canton' => 'NE'),
    '2013' => array('town' => 'Colombier NE', 'canton' => 'NE'),
    '2014' => array('town' => 'Bôle', 'canton' => 'NE'),
    '2015' => array('town' => 'Areuse', 'canton' => 'NE'),
    '2016' => array('town' => 'Cortaillod', 'canton' => 'NE'),
    '2017' => array('town' => 'Boudry', 'canton' => 'NE'),
    '2022' => array('town' => 'Bevaix', 'canton' => 'NE'),
    '2023' => array('town' => 'Gorgier', 'canton' => 'NE'),
    '2024' => array('town' => 'St-Aubin-Sauges', 'canton' => 'NE'),
    '2025' => array('town' => 'Chez-le-Bart', 'canton' => 'NE'),
    '2028' => array('town' => 'Vaumarcus', 'canton' => 'NE'),
    '2034' => array('town' => 'Peseux', 'canton' => 'NE'),
    '2035' => array('town' => 'Corcelles NE', 'canton' => 'NE'),
    '2036' => array('town' => 'Cormondrèche', 'canton' => 'NE'),
    '2042' => array('town' => 'Valangin', 'canton' => 'NE'),
    '2043' => array('town' => 'Boudevilliers', 'canton' => 'NE'),
    '2046' => array('town' => 'Fontaines NE', 'canton' => 'NE'),
    '2052' => array('town' => 'Fontainemelon', 'canton' => 'NE'),
    '2053' => array('town' => 'Cernier', 'canton' => 'NE'),
    '2054' => array('town' => 'Chézard-St-Martin', 'canton' => 'NE'),
    '2056' => array('town' => 'Dombresson', 'canton' => 'NE'),
    '2057' => array('town' => 'Villiers', 'canton' => 'NE'),
    '2058' => array('town' => 'Le Pâquier NE', 'canton' => 'NE'),
    '2063' => array('town' => 'Vilars NE', 'canton' => 'NE'),
    '2065' => array('town' => 'Savagnier', 'canton' => 'NE'),
    '2067' => array('town' => 'Chaumont', 'canton' => 'NE'),
    '2068' => array('town' => 'Hauterive NE', 'canton' => 'NE'),
    '2072' => array('town' => 'St-Blaise', 'canton' => 'NE'),
    '2073' => array('town' => 'Enges', 'canton' => 'NE'),
    '2074' => array('town' => 'Marin-Epagnier', 'canton' => 'NE'),
    '3238' => array('town' => 'Gals', 'canton' => 'BE'),
    '2087' => array('town' => 'Cornaux NE', 'canton' => 'NE'),
    '2088' => array('town' => 'Cressier NE', 'canton' => 'NE'),
    '2318' => array('town' => 'Brot-Plamboz', 'canton' => 'NE'),
    '2103' => array('town' => 'Noiraigue', 'canton' => 'NE'),
    '2105' => array('town' => 'Travers', 'canton' => 'NE'),
    '2108' => array('town' => 'Couvet', 'canton' => 'NE'),
    '2112' => array('town' => 'Môtiers NE', 'canton' => 'NE'),
    '2113' => array('town' => 'Boveresse', 'canton' => 'NE'),
    '2114' => array('town' => 'Fleurier', 'canton' => 'NE'),
    '2115' => array('town' => 'Buttes', 'canton' => 'NE'),
    '2117' => array('town' => 'La Côte-aux-Fées', 'canton' => 'NE'),
    '2123' => array('town' => 'St-Sulpice NE', 'canton' => 'NE'),
    '2406' => array('town' => 'La Brévine', 'canton' => 'NE'),
    '2126' => array('town' => 'Les Verrières', 'canton' => 'NE'),
    '2127' => array('town' => 'Les Bayards', 'canton' => 'NE'),
    '2149' => array('town' => 'Champ-du-Moulin', 'canton' => 'NE'),
    '2124' => array('town' => 'Les Sagnettes', 'canton' => 'NE'),
    '2116' => array('town' => 'Mont-de-Buttes', 'canton' => 'NE'),
    '2019' => array('town' => 'Chambrelien', 'canton' => 'NE'),
    '2037' => array('town' => 'Montmollin', 'canton' => 'NE'),
    '2206' => array('town' => 'Geneveys-Coffrane', 'canton' => 'NE'),
    '2207' => array('town' => 'Coffrane', 'canton' => 'NE'),
    '2208' => array('town' => 'Les Hauts-Geneveys', 'canton' => 'NE'),
    '2300' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2302' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2303' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2306' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2301' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2304' => array('town' => 'La Chaux-de-Fonds', 'canton' => 'NE'),
    '2316' => array('town' => 'Petit-Martel', 'canton' => 'NE'),
    '2338' => array('town' => 'Les Emibois', 'canton' => 'JU'),
    '2314' => array('town' => 'La Sagne NE', 'canton' => 'NE'),
    '2322' => array('town' => 'Le Crêt-du-Locle', 'canton' => 'NE'),
    '2325' => array('town' => 'Les Planchettes', 'canton' => 'NE'),
    '2333' => array('town' => 'La Ferrière', 'canton' => 'BE'),
    '2336' => array('town' => 'Les Bois', 'canton' => 'JU'),
    '2400' => array('town' => 'Le Locle', 'canton' => 'NE'),
    '2405' => array('town' => 'La Chaux-du-Milieu', 'canton' => 'NE'),
    '2414' => array('town' => 'Cerneux-Péquignot', 'canton' => 'NE'),
    '2416' => array('town' => 'Les Brenets', 'canton' => 'NE'),
    '2500' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2501' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2502' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2503' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2504' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2505' => array('town' => 'Biel/Bienne', 'canton' => 'BE'),
    '2512' => array('town' => 'Tüscherz-Alfermée', 'canton' => 'BE'),
    '2513' => array('town' => 'Twann', 'canton' => 'BE'),
    '2514' => array('town' => 'Ligerz', 'canton' => 'BE'),
    '2515' => array('town' => 'Prêles', 'canton' => 'BE'),
    '2516' => array('town' => 'Lamboing', 'canton' => 'BE'),
    '2517' => array('town' => 'Diesse', 'canton' => 'BE'),
    '2518' => array('town' => 'Nods', 'canton' => 'BE'),
    '2520' => array('town' => 'La Neuveville', 'canton' => 'BE'),
    '2523' => array('town' => 'Lignières', 'canton' => 'NE'),
    '2525' => array('town' => 'Le Landeron', 'canton' => 'NE'),
    '2532' => array('town' => 'Magglingen/Macolin', 'canton' => 'BE'),
    '2533' => array('town' => 'Evilard', 'canton' => 'BE'),
    '2534' => array('town' => 'Orvin', 'canton' => 'BE'),
    '2535' => array('town' => 'Frinvillier', 'canton' => 'BE'),
    '2536' => array('town' => 'Plagne', 'canton' => 'BE'),
    '2537' => array('town' => 'Vauffelin', 'canton' => 'BE'),
    '2538' => array('town' => 'Romont BE', 'canton' => 'BE'),
    '2540' => array('town' => 'Grenchen', 'canton' => 'SO'),
    '2542' => array('town' => 'Pieterlen', 'canton' => 'BE'),
    '2543' => array('town' => 'Lengnau BE', 'canton' => 'BE'),
    '2544' => array('town' => 'Bettlach', 'canton' => 'SO'),
    '2545' => array('town' => 'Selzach', 'canton' => 'SO'),
    '2552' => array('town' => 'Orpund', 'canton' => 'BE'),
    '2553' => array('town' => 'Safnern', 'canton' => 'BE'),
    '2554' => array('town' => 'Meinisberg', 'canton' => 'BE'),
    '2555' => array('town' => 'Brügg BE', 'canton' => 'BE'),
    '2556' => array('town' => 'Scheuren', 'canton' => 'BE'),
    '2557' => array('town' => 'Studen BE', 'canton' => 'BE'),
    '2558' => array('town' => 'Aegerten', 'canton' => 'BE'),
    '2560' => array('town' => 'Nidau', 'canton' => 'BE'),
    '2562' => array('town' => 'Port', 'canton' => 'BE'),
    '2563' => array('town' => 'Ipsach', 'canton' => 'BE'),
    '2564' => array('town' => 'Bellmund', 'canton' => 'BE'),
    '2565' => array('town' => 'Jens', 'canton' => 'BE'),
    '2572' => array('town' => 'Sutz', 'canton' => 'BE'),
    '2575' => array('town' => 'Täuffelen', 'canton' => 'BE'),
    '2576' => array('town' => 'Lüscherz', 'canton' => 'BE'),
    '2577' => array('town' => 'Siselen BE', 'canton' => 'BE'),
    '3237' => array('town' => 'Brüttelen', 'canton' => 'BE'),
    '2603' => array('town' => 'Péry', 'canton' => 'BE'),
    '2604' => array('town' => 'La Heutte', 'canton' => 'BE'),
    '2605' => array('town' => 'Sonceboz-Sombeval', 'canton' => 'BE'),
    '2606' => array('town' => 'Corgémont', 'canton' => 'BE'),
    '2607' => array('town' => 'Cortébert', 'canton' => 'BE'),
    '2608' => array('town' => 'Courtelary', 'canton' => 'BE'),
    '2610' => array('town' => 'St-Imier', 'canton' => 'BE'),
    '2612' => array('town' => 'Cormoret', 'canton' => 'BE'),
    '2613' => array('town' => 'Villeret', 'canton' => 'BE'),
    '2615' => array('town' => 'Sonvilier', 'canton' => 'BE'),
    '2616' => array('town' => 'Renan BE', 'canton' => 'BE'),
    '2710' => array('town' => 'Tavannes', 'canton' => 'BE'),
    '2712' => array('town' => 'Le Fuet', 'canton' => 'BE'),
    '2714' => array('town' => 'Le Prédame', 'canton' => 'JU'),
    '2717' => array('town' => 'Fornet-Dessous', 'canton' => 'BE'),
    '2718' => array('town' => 'Fornet-Dessus', 'canton' => 'JU'),
    '2716' => array('town' => 'Sornetan', 'canton' => 'BE'),
    '2713' => array('town' => 'Bellelay', 'canton' => 'BE'),
    '2720' => array('town' => 'Tramelan', 'canton' => 'BE'),
    '2722' => array('town' => 'Les Reussilles', 'canton' => 'BE'),
    '2723' => array('town' => 'Mont-Tramelan', 'canton' => 'BE'),
    '2345' => array('town' => 'Les Breuleux', 'canton' => 'JU'),
    '2340' => array('town' => 'Le Noirmont', 'canton' => 'JU'),
    '2350' => array('town' => 'Saignelégier', 'canton' => 'JU'),
    '2353' => array('town' => 'Les Pommerats', 'canton' => 'JU'),
    '2354' => array('town' => 'Goumois', 'canton' => 'JU'),
    '2732' => array('town' => 'Reconvilier', 'canton' => 'BE'),
    '2733' => array('town' => 'Pontenet', 'canton' => 'BE'),
    '2735' => array('town' => 'Malleray-Bévilard', 'canton' => 'BE'),
    '2736' => array('town' => 'Sorvilier', 'canton' => 'BE'),
    '2738' => array('town' => 'Court', 'canton' => 'BE'),
    '2740' => array('town' => 'Moutier', 'canton' => 'BE'),
    '2742' => array('town' => 'Perrefitte', 'canton' => 'BE'),
    '2748' => array('town' => 'Souboz', 'canton' => 'BE'),
    '2743' => array('town' => 'Eschert', 'canton' => 'BE'),
    '2744' => array('town' => 'Belprahon', 'canton' => 'BE'),
    '2747' => array('town' => 'Seehof', 'canton' => 'BE'),
    '2745' => array('town' => 'Grandval', 'canton' => 'BE'),
    '2746' => array('town' => 'Crémines', 'canton' => 'BE'),
    '2762' => array('town' => 'Roches BE', 'canton' => 'BE'),
    '2832' => array('town' => 'Rebeuvelier', 'canton' => 'JU'),
    '2830' => array('town' => 'Courrendlin', 'canton' => 'JU'),
    '2800' => array('town' => 'Delémont', 'canton' => 'JU'),
    '2802' => array('town' => 'Develier', 'canton' => 'JU'),
    '2803' => array('town' => 'Bourrignon', 'canton' => 'JU'),
    '2805' => array('town' => 'Soyhières', 'canton' => 'JU'),
    '2806' => array('town' => 'Mettembert', 'canton' => 'JU'),
    '2807' => array('town' => 'Pleigne', 'canton' => 'JU'),
    '2812' => array('town' => 'Movelier', 'canton' => 'JU'),
    '2813' => array('town' => 'Ederswiler', 'canton' => 'JU'),
    '2814' => array('town' => 'Roggenburg', 'canton' => 'BL'),
    '2822' => array('town' => 'Courroux', 'canton' => 'JU'),
    '2823' => array('town' => 'Courcelon', 'canton' => 'JU'),
    '2824' => array('town' => 'Vicques', 'canton' => 'JU'),
    '2825' => array('town' => 'Courchapoix', 'canton' => 'JU'),
    '2826' => array('town' => 'Corban', 'canton' => 'JU'),
    '2827' => array('town' => 'Mervelier', 'canton' => 'JU'),
    '2828' => array('town' => 'Montsevelier', 'canton' => 'JU'),
    '2829' => array('town' => 'Vermes', 'canton' => 'JU'),
    '2842' => array('town' => 'Rossemaison', 'canton' => 'JU'),
    '2843' => array('town' => 'Châtillon JU', 'canton' => 'JU'),
    '2852' => array('town' => 'Courtételle', 'canton' => 'JU'),
    '2853' => array('town' => 'Courfaivre', 'canton' => 'JU'),
    '2854' => array('town' => 'Bassecourt', 'canton' => 'JU'),
    '2855' => array('town' => 'Glovelier', 'canton' => 'JU'),
    '2856' => array('town' => 'Boécourt', 'canton' => 'JU'),
    '2857' => array('town' => 'Montavon', 'canton' => 'JU'),
    '2863' => array('town' => 'Undervelier', 'canton' => 'JU'),
    '2864' => array('town' => 'Soulce', 'canton' => 'JU'),
    '2873' => array('town' => 'Saulcy', 'canton' => 'JU'),
    '2882' => array('town' => 'St-Ursanne', 'canton' => 'JU'),
    '2883' => array('town' => 'Montmelon', 'canton' => 'JU'),
    '2884' => array('town' => 'Montenol', 'canton' => 'JU'),
    '2885' => array('town' => 'Epauvillers', 'canton' => 'JU'),
    '2886' => array('town' => 'Epiquerez', 'canton' => 'JU'),
    '2887' => array('town' => 'Soubey', 'canton' => 'JU'),
    '2888' => array('town' => 'Seleute', 'canton' => 'JU'),
    '2889' => array('town' => 'Ocourt', 'canton' => 'JU'),
    '2950' => array('town' => 'Courgenay', 'canton' => 'JU'),
    '2900' => array('town' => 'Porrentruy', 'canton' => 'JU'),
    '2902' => array('town' => 'Fontenais', 'canton' => 'JU'),
    '2903' => array('town' => 'Villars-Fontenais', 'canton' => 'JU'),
    '2904' => array('town' => 'Bressaucourt', 'canton' => 'JU'),
    '2905' => array('town' => 'Courtedoux', 'canton' => 'JU'),
    '2906' => array('town' => 'Chevenez', 'canton' => 'JU'),
    '2907' => array('town' => 'Rocourt', 'canton' => 'JU'),
    '2908' => array('town' => 'Grandfontaine', 'canton' => 'JU'),
    '2912' => array('town' => 'Roche-d\'Or', 'canton' => 'JU'),
    '2914' => array('town' => 'Damvant', 'canton' => 'JU'),
    '2915' => array('town' => 'Bure', 'canton' => 'JU'),
    '2916' => array('town' => 'Fahy', 'canton' => 'JU'),
    '2922' => array('town' => 'Courchavon', 'canton' => 'JU'),
    '2923' => array('town' => 'Courtemaîche', 'canton' => 'JU'),
    '2924' => array('town' => 'Montignez', 'canton' => 'JU'),
    '2925' => array('town' => 'Buix', 'canton' => 'JU'),
    '2926' => array('town' => 'Boncourt', 'canton' => 'JU'),
    '2932' => array('town' => 'Coeuve', 'canton' => 'JU'),
    '2935' => array('town' => 'Beurnevésin', 'canton' => 'JU'),
    '2942' => array('town' => 'Alle', 'canton' => 'JU'),
    '2943' => array('town' => 'Vendlincourt', 'canton' => 'JU'),
    '2944' => array('town' => 'Bonfol', 'canton' => 'JU'),
    '2946' => array('town' => 'Miécourt', 'canton' => 'JU'),
    '2947' => array('town' => 'Charmoille', 'canton' => 'JU'),
    '2952' => array('town' => 'Cornol', 'canton' => 'JU'),
    '2953' => array('town' => 'Fregiécourt-Pleuj', 'canton' => 'JU'),
    '2954' => array('town' => 'Asuel', 'canton' => 'JU'),
    '3000' => array('town' => 'Bern', 'canton' => 'BE'),
    '3001' => array('town' => 'Bern', 'canton' => 'BE'),
    '3002' => array('town' => 'Bern Postfinance', 'canton' => 'BE'),
    '3003' => array('town' => 'Bern', 'canton' => 'BE'),
    '3004' => array('town' => 'Bern', 'canton' => 'BE'),
    '3005' => array('town' => 'Bern', 'canton' => 'BE'),
    '3006' => array('town' => 'Bern', 'canton' => 'BE'),
    '3007' => array('town' => 'Bern', 'canton' => 'BE'),
    '3008' => array('town' => 'Bern', 'canton' => 'BE'),
    '3010' => array('town' => 'Bern', 'canton' => 'BE'),
    '3011' => array('town' => 'Bern', 'canton' => 'BE'),
    '3012' => array('town' => 'Bern', 'canton' => 'BE'),
    '3013' => array('town' => 'Bern', 'canton' => 'BE'),
    '3014' => array('town' => 'Bern', 'canton' => 'BE'),
    '3015' => array('town' => 'Bern', 'canton' => 'BE'),
    '3018' => array('town' => 'Bern', 'canton' => 'BE'),
    '3019' => array('town' => 'Bern', 'canton' => 'BE'),
    '3020' => array('town' => 'Bern', 'canton' => 'BE'),
    '3027' => array('town' => 'Bern', 'canton' => 'BE'),
    '3095' => array('town' => 'Spiegel b. Bern', 'canton' => 'BE'),
    '3032' => array('town' => 'Hinterkappelen', 'canton' => 'BE'),
    '3033' => array('town' => 'Wohlen b. Bern', 'canton' => 'BE'),
    '3034' => array('town' => 'Murzelen', 'canton' => 'BE'),
    '3035' => array('town' => 'Frieswil', 'canton' => 'BE'),
    '3036' => array('town' => 'Detligen', 'canton' => 'BE'),
    '3037' => array('town' => 'Herrenschwanden', 'canton' => 'BE'),
    '3038' => array('town' => 'Kirchlindach', 'canton' => 'BE'),
    '3042' => array('town' => 'Ortschwaben', 'canton' => 'BE'),
    '3043' => array('town' => 'Uettligen', 'canton' => 'BE'),
    '3049' => array('town' => 'Säriswil', 'canton' => 'BE'),
    '3045' => array('town' => 'Meikirch', 'canton' => 'BE'),
    '3046' => array('town' => 'Wahlendorf', 'canton' => 'BE'),
    '3047' => array('town' => 'Bremgarten b. Bern', 'canton' => 'BE'),
    '3048' => array('town' => 'Worblaufen', 'canton' => 'BE'),
    '3052' => array('town' => 'Zollikofen', 'canton' => 'BE'),
    '3053' => array('town' => 'Münchenbuchsee', 'canton' => 'BE'),
    '3054' => array('town' => 'Schüpfen', 'canton' => 'BE'),
    '3063' => array('town' => 'Ittigen', 'canton' => 'BE'),
    '3065' => array('town' => 'Bolligen', 'canton' => 'BE'),
    '3066' => array('town' => 'Stettlen', 'canton' => 'BE'),
    '3067' => array('town' => 'Boll', 'canton' => 'BE'),
    '3068' => array('town' => 'Utzigen', 'canton' => 'BE'),
    '3072' => array('town' => 'Ostermundigen', 'canton' => 'BE'),
    '3073' => array('town' => 'Gümligen', 'canton' => 'BE'),
    '3074' => array('town' => 'Muri b. Bern', 'canton' => 'BE'),
    '3075' => array('town' => 'Rüfenacht BE', 'canton' => 'BE'),
    '3076' => array('town' => 'Worb', 'canton' => 'BE'),
    '3077' => array('town' => 'Enggistein', 'canton' => 'BE'),
    '3078' => array('town' => 'Richigen', 'canton' => 'BE'),
    '3082' => array('town' => 'Schlosswil', 'canton' => 'BE'),
    '3083' => array('town' => 'Trimstein', 'canton' => 'BE'),
    '3084' => array('town' => 'Wabern', 'canton' => 'BE'),
    '3088' => array('town' => 'Oberbütschel', 'canton' => 'BE'),
    '3086' => array('town' => 'Zimmerwald', 'canton' => 'BE'),
    '3087' => array('town' => 'Niedermuhlern', 'canton' => 'BE'),
    '3089' => array('town' => 'Hinterfultigen', 'canton' => 'BE'),
    '3096' => array('town' => 'Oberbalm', 'canton' => 'BE'),
    '3097' => array('town' => 'Liebefeld', 'canton' => 'BE'),
    '3098' => array('town' => 'Köniz', 'canton' => 'BE'),
    '3099' => array('town' => 'Rüti b. Riggisberg', 'canton' => 'BE'),
    '3110' => array('town' => 'Münsingen', 'canton' => 'BE'),
    '3112' => array('town' => 'Allmendingen b. BE', 'canton' => 'BE'),
    '3114' => array('town' => 'Wichtrach', 'canton' => 'BE'),
    '3115' => array('town' => 'Gerzensee', 'canton' => 'BE'),
    '3116' => array('town' => 'Kirchdorf BE', 'canton' => 'BE'),
    '3629' => array('town' => 'Kiesen', 'canton' => 'BE'),
    '3628' => array('town' => 'Uttigen', 'canton' => 'BE'),
    '3122' => array('town' => 'Kehrsatz', 'canton' => 'BE'),
    '3123' => array('town' => 'Belp', 'canton' => 'BE'),
    '3124' => array('town' => 'Belpberg', 'canton' => 'BE'),
    '3125' => array('town' => 'Toffen', 'canton' => 'BE'),
    '3126' => array('town' => 'Kaufdorf', 'canton' => 'BE'),
    '3127' => array('town' => 'Mühlethurnen', 'canton' => 'BE'),
    '3128' => array('town' => 'Kirchenthurnen', 'canton' => 'BE'),
    '3132' => array('town' => 'Riggisberg', 'canton' => 'BE'),
    '3664' => array('town' => 'Burgistein', 'canton' => 'BE'),
    '3665' => array('town' => 'Wattenwil', 'canton' => 'BE'),
    '3662' => array('town' => 'Seftigen', 'canton' => 'BE'),
    '3663' => array('town' => 'Gurzelen', 'canton' => 'BE'),
    '3661' => array('town' => 'Uetendorf', 'canton' => 'BE'),
    '3144' => array('town' => 'Gasel', 'canton' => 'BE'),
    '3145' => array('town' => 'Niederscherli', 'canton' => 'BE'),
    '3147' => array('town' => 'Mittelhäusern', 'canton' => 'BE'),
    '3148' => array('town' => 'Lanzenhäusern', 'canton' => 'BE'),
    '3150' => array('town' => 'Schwarzenburg', 'canton' => 'BE'),
    '3152' => array('town' => 'Mamishaus', 'canton' => 'BE'),
    '3153' => array('town' => 'Rüschegg Gambach', 'canton' => 'BE'),
    '3154' => array('town' => 'Rüschegg Heubach', 'canton' => 'BE'),
    '3155' => array('town' => 'Helgisried', 'canton' => 'BE'),
    '3156' => array('town' => 'Riffenmatt', 'canton' => 'BE'),
    '3157' => array('town' => 'Milken', 'canton' => 'BE'),
    '3158' => array('town' => 'Guggisberg', 'canton' => 'BE'),
    '3159' => array('town' => 'Riedstätt', 'canton' => 'BE'),
    '3172' => array('town' => 'Niederwangen BE', 'canton' => 'BE'),
    '3173' => array('town' => 'Oberwangen b. Bern', 'canton' => 'BE'),
    '3174' => array('town' => 'Thörishaus', 'canton' => 'BE'),
    '3175' => array('town' => 'Flamatt', 'canton' => 'FR'),
    '3176' => array('town' => 'Neuenegg', 'canton' => 'BE'),
    '3177' => array('town' => 'Laupen BE', 'canton' => 'BE'),
    '3178' => array('town' => 'Bösingen', 'canton' => 'FR'),
    '3179' => array('town' => 'Kriechenwil', 'canton' => 'BE'),
    '3182' => array('town' => 'Ueberstorf', 'canton' => 'FR'),
    '3183' => array('town' => 'Albligen', 'canton' => 'BE'),
    '3184' => array('town' => 'Wünnewil', 'canton' => 'FR'),
    '3186' => array('town' => 'Düdingen', 'canton' => 'FR'),
    '3202' => array('town' => 'Frauenkappelen', 'canton' => 'BE'),
    '3203' => array('town' => 'Mühleberg', 'canton' => 'BE'),
    '3204' => array('town' => 'Rosshäusern', 'canton' => 'BE'),
    '3205' => array('town' => 'Gümmenen', 'canton' => 'BE'),
    '3206' => array('town' => 'Rizenbach', 'canton' => 'BE'),
    '3207' => array('town' => 'Wileroltigen', 'canton' => 'BE'),
    '3208' => array('town' => 'Gurbrü', 'canton' => 'BE'),
    '3210' => array('town' => 'Kerzers', 'canton' => 'FR'),
    '3216' => array('town' => 'Ried b. Kerzers', 'canton' => 'FR'),
    '3215' => array('town' => 'Gempenach', 'canton' => 'FR'),
    '3214' => array('town' => 'Ulmiz', 'canton' => 'FR'),
    '3213' => array('town' => 'Liebistorf', 'canton' => 'FR'),
    '3212' => array('town' => 'Gurmels', 'canton' => 'FR'),
    '3225' => array('town' => 'Müntschemier', 'canton' => 'BE'),
    '3226' => array('town' => 'Treiten', 'canton' => 'BE'),
    '3232' => array('town' => 'Ins', 'canton' => 'BE'),
    '3233' => array('town' => 'Tschugg', 'canton' => 'BE'),
    '3234' => array('town' => 'Vinelz', 'canton' => 'BE'),
    '3235' => array('town' => 'Erlach', 'canton' => 'BE'),
    '3236' => array('town' => 'Gampelen', 'canton' => 'BE'),
    '3250' => array('town' => 'Lyss', 'canton' => 'BE'),
    '3251' => array('town' => 'Wengi b. Büren', 'canton' => 'BE'),
    '3252' => array('town' => 'Worben', 'canton' => 'BE'),
    '3253' => array('town' => 'Schnottwil', 'canton' => 'SO'),
    '3254' => array('town' => 'Messen', 'canton' => 'SO'),
    '3255' => array('town' => 'Rapperswil BE', 'canton' => 'BE'),
    '3256' => array('town' => 'Dieterswil', 'canton' => 'BE'),
    '3257' => array('town' => 'Grossaffoltern', 'canton' => 'BE'),
    '3262' => array('town' => 'Suberg', 'canton' => 'BE'),
    '3263' => array('town' => 'Büetigen', 'canton' => 'BE'),
    '3264' => array('town' => 'Diessbach b. Büren', 'canton' => 'BE'),
    '3266' => array('town' => 'Wiler b. Seedorf', 'canton' => 'BE'),
    '3267' => array('town' => 'Seedorf BE', 'canton' => 'BE'),
    '3268' => array('town' => 'Lobsigen', 'canton' => 'BE'),
    '3270' => array('town' => 'Aarberg', 'canton' => 'BE'),
    '3271' => array('town' => 'Radelfingen', 'canton' => 'BE'),
    '3272' => array('town' => 'Walperswil', 'canton' => 'BE'),
    '3273' => array('town' => 'Kappelen', 'canton' => 'BE'),
    '3274' => array('town' => 'Hermrigen', 'canton' => 'BE'),
    '3280' => array('town' => 'Murten', 'canton' => 'FR'),
    '3282' => array('town' => 'Bargen BE', 'canton' => 'BE'),
    '3283' => array('town' => 'Kallnach', 'canton' => 'BE'),
    '3284' => array('town' => 'Fräschels', 'canton' => 'FR'),
    '3285' => array('town' => 'Galmiz', 'canton' => 'FR'),
    '3286' => array('town' => 'Muntelier', 'canton' => 'FR'),
    '3292' => array('town' => 'Busswil b. Büren', 'canton' => 'BE'),
    '3293' => array('town' => 'Dotzigen', 'canton' => 'BE'),
    '3294' => array('town' => 'Büren an der Aare', 'canton' => 'BE'),
    '3295' => array('town' => 'Rüti b. Büren', 'canton' => 'BE'),
    '3296' => array('town' => 'Arch', 'canton' => 'BE'),
    '3297' => array('town' => 'Leuzigen', 'canton' => 'BE'),
    '3298' => array('town' => 'Oberwil b. Büren', 'canton' => 'BE'),
    '3302' => array('town' => 'Moosseedorf', 'canton' => 'BE'),
    '3303' => array('town' => 'Jegenstorf', 'canton' => 'BE'),
    '3308' => array('town' => 'Grafenried', 'canton' => 'BE'),
    '3312' => array('town' => 'Fraubrunnen', 'canton' => 'BE'),
    '3313' => array('town' => 'Büren zum Hof', 'canton' => 'BE'),
    '3314' => array('town' => 'Schalunen', 'canton' => 'BE'),
    '3315' => array('town' => 'Bätterkinden', 'canton' => 'BE'),
    '3321' => array('town' => 'Schönbühl EKZ', 'canton' => 'BE'),
    '3322' => array('town' => 'Urtenen-Schönbühl', 'canton' => 'BE'),
    '3323' => array('town' => 'Bäriswil BE', 'canton' => 'BE'),
    '3324' => array('town' => 'Hindelbank', 'canton' => 'BE'),
    '3325' => array('town' => 'Hettiswil', 'canton' => 'BE'),
    '3326' => array('town' => 'Krauchthal', 'canton' => 'BE'),
    '3305' => array('town' => 'Iffwil', 'canton' => 'BE'),
    '3306' => array('town' => 'Etzelkofen', 'canton' => 'BE'),
    '3307' => array('town' => 'Brunnenthal', 'canton' => 'SO'),
    '3309' => array('town' => 'Kernenried', 'canton' => 'BE'),
    '3317' => array('town' => 'Limpach', 'canton' => 'BE'),
    '3360' => array('town' => 'Herzogenbuchsee', 'canton' => 'BE'),
    '4556' => array('town' => 'Aeschi SO', 'canton' => 'SO'),
    '3376' => array('town' => 'Graben', 'canton' => 'BE'),
    '3372' => array('town' => 'Wanzwil', 'canton' => 'BE'),
    '3373' => array('town' => 'Heimenhausen', 'canton' => 'BE'),
    '3374' => array('town' => 'Wangenried', 'canton' => 'BE'),
    '3362' => array('town' => 'Niederönz', 'canton' => 'BE'),
    '3363' => array('town' => 'Oberönz', 'canton' => 'BE'),
    '3365' => array('town' => 'Seeberg', 'canton' => 'BE'),
    '3366' => array('town' => 'Bettenhausen', 'canton' => 'BE'),
    '3367' => array('town' => 'Thörigen', 'canton' => 'BE'),
    '3368' => array('town' => 'Bleienbach', 'canton' => 'BE'),
    '3400' => array('town' => 'Burgdorf', 'canton' => 'BE'),
    '3401' => array('town' => 'Burgdorf', 'canton' => 'BE'),
    '3402' => array('town' => 'Burgdorf', 'canton' => 'BE'),
    '3412' => array('town' => 'Heimiswil', 'canton' => 'BE'),
    '3413' => array('town' => 'Kaltacker', 'canton' => 'BE'),
    '3414' => array('town' => 'Oberburg', 'canton' => 'BE'),
    '3415' => array('town' => 'Hasle-Rüegsau', 'canton' => 'BE'),
    '3416' => array('town' => 'Affoltern BE', 'canton' => 'BE'),
    '3417' => array('town' => 'Rüegsau', 'canton' => 'BE'),
    '3418' => array('town' => 'Rüegsbach', 'canton' => 'BE'),
    '3419' => array('town' => 'Biembach', 'canton' => 'BE'),
    '3421' => array('town' => 'Lyssach', 'canton' => 'BE'),
    '3422' => array('town' => 'Kirchberg BE', 'canton' => 'BE'),
    '3423' => array('town' => 'Ersigen', 'canton' => 'BE'),
    '3424' => array('town' => 'Niederösch', 'canton' => 'BE'),
    '3425' => array('town' => 'Koppigen', 'canton' => 'BE'),
    '3426' => array('town' => 'Aefligen', 'canton' => 'BE'),
    '3427' => array('town' => 'Utzenstorf', 'canton' => 'BE'),
    '3428' => array('town' => 'Wiler b.Utzenstorf', 'canton' => 'BE'),
    '3432' => array('town' => 'Lützelflüh-Goldb', 'canton' => 'BE'),
    '3433' => array('town' => 'Schwanden i. E.', 'canton' => 'BE'),
    '3434' => array('town' => 'Obergoldbach', 'canton' => 'BE'),
    '3435' => array('town' => 'Ramsei', 'canton' => 'BE'),
    '3436' => array('town' => 'Zollbrück', 'canton' => 'BE'),
    '3437' => array('town' => 'Rüderswil', 'canton' => 'BE'),
    '3438' => array('town' => 'Lauperswil', 'canton' => 'BE'),
    '3439' => array('town' => 'Ranflüh', 'canton' => 'BE'),
    '3452' => array('town' => 'Grünenmatt', 'canton' => 'BE'),
    '3453' => array('town' => 'Heimisbach', 'canton' => 'BE'),
    '3454' => array('town' => 'Sumiswald', 'canton' => 'BE'),
    '3455' => array('town' => 'Grünen', 'canton' => 'BE'),
    '3456' => array('town' => 'Trachselwald', 'canton' => 'BE'),
    '3457' => array('town' => 'Wasen im Emmental', 'canton' => 'BE'),
    '3462' => array('town' => 'Weier im Emmental', 'canton' => 'BE'),
    '3463' => array('town' => 'Häusernmoos', 'canton' => 'BE'),
    '3464' => array('town' => 'Schmidigen-Mühlew', 'canton' => 'BE'),
    '3465' => array('town' => 'Dürrenroth', 'canton' => 'BE'),
    '3472' => array('town' => 'Wynigen', 'canton' => 'BE'),
    '3473' => array('town' => 'Alchenstorf', 'canton' => 'BE'),
    '3474' => array('town' => 'Rüedisbach', 'canton' => 'BE'),
    '3475' => array('town' => 'Riedtwil', 'canton' => 'BE'),
    '3476' => array('town' => 'Oschwand', 'canton' => 'BE'),
    '3111' => array('town' => 'Tägertschi', 'canton' => 'BE'),
    '3503' => array('town' => 'Gysenstein', 'canton' => 'BE'),
    '3504' => array('town' => 'Niederhünigen', 'canton' => 'BE'),
    '3506' => array('town' => 'Grosshöchstetten', 'canton' => 'BE'),
    '3507' => array('town' => 'Biglen', 'canton' => 'BE'),
    '3508' => array('town' => 'Arni BE', 'canton' => 'BE'),
    '3510' => array('town' => 'Konolfingen', 'canton' => 'BE'),
    '3512' => array('town' => 'Walkringen', 'canton' => 'BE'),
    '3513' => array('town' => 'Bigenthal', 'canton' => 'BE'),
    '3672' => array('town' => 'Oberdiessbach', 'canton' => 'BE'),
    '3673' => array('town' => 'Linden', 'canton' => 'BE'),
    '3674' => array('town' => 'Bleiken', 'canton' => 'BE'),
    '3671' => array('town' => 'Brenzikofen', 'canton' => 'BE'),
    '3531' => array('town' => 'Oberthal', 'canton' => 'BE'),
    '3532' => array('town' => 'Zäziwil', 'canton' => 'BE'),
    '3533' => array('town' => 'Bowil', 'canton' => 'BE'),
    '3534' => array('town' => 'Signau', 'canton' => 'BE'),
    '3535' => array('town' => 'Schüpbach', 'canton' => 'BE'),
    '3536' => array('town' => 'Aeschau', 'canton' => 'BE'),
    '3537' => array('town' => 'Eggiwil', 'canton' => 'BE'),
    '3538' => array('town' => 'Röthenbach i. E.', 'canton' => 'BE'),
    '3543' => array('town' => 'Emmenmatt', 'canton' => 'BE'),
    '3550' => array('town' => 'Langnau i. E.', 'canton' => 'BE'),
    '3551' => array('town' => 'Oberfrittenbach', 'canton' => 'BE'),
    '3552' => array('town' => 'Bärau', 'canton' => 'BE'),
    '3553' => array('town' => 'Gohl', 'canton' => 'BE'),
    '3555' => array('town' => 'Trubschachen', 'canton' => 'BE'),
    '3556' => array('town' => 'Trub', 'canton' => 'BE'),
    '3557' => array('town' => 'Fankhaus (Trub)', 'canton' => 'BE'),
    '3600' => array('town' => 'Thun', 'canton' => 'BE'),
    '3601' => array('town' => 'Thun', 'canton' => 'BE'),
    '3602' => array('town' => 'Thun 2', 'canton' => 'BE'),
    '3603' => array('town' => 'Thun', 'canton' => 'BE'),
    '3604' => array('town' => 'Thun', 'canton' => 'BE'),
    '3605' => array('town' => 'Thun', 'canton' => 'BE'),
    '3607' => array('town' => 'Thun', 'canton' => 'BE'),
    '3608' => array('town' => 'Thun', 'canton' => 'BE'),
    '3617' => array('town' => 'Fahrni b. Thun', 'canton' => 'BE'),
    '3618' => array('town' => 'Süderen', 'canton' => 'BE'),
    '3619' => array('town' => 'Eriz', 'canton' => 'BE'),
    '3622' => array('town' => 'Homberg b. Thun', 'canton' => 'BE'),
    '3635' => array('town' => 'Uebeschi', 'canton' => 'BE'),
    '3631' => array('town' => 'Höfen b. Thun', 'canton' => 'BE'),
    '3636' => array('town' => 'Längenbühl', 'canton' => 'BE'),
    '3612' => array('town' => 'Steffisburg', 'canton' => 'BE'),
    '3613' => array('town' => 'Steffisburg', 'canton' => 'BE'),
    '3614' => array('town' => 'Unterlangenegg', 'canton' => 'BE'),
    '3615' => array('town' => 'Heimenschwand', 'canton' => 'BE'),
    '3616' => array('town' => 'Schwarzenegg', 'canton' => 'BE'),
    '3623' => array('town' => 'Teuffenthal BE', 'canton' => 'BE'),
    '3624' => array('town' => 'Goldiwil (Thun)', 'canton' => 'BE'),
    '3625' => array('town' => 'Heiligenschwendi', 'canton' => 'BE'),
    '3626' => array('town' => 'Hünibach', 'canton' => 'BE'),
    '3627' => array('town' => 'Heimberg', 'canton' => 'BE'),
    '3633' => array('town' => 'Amsoldingen', 'canton' => 'BE'),
    '3634' => array('town' => 'Thierachern', 'canton' => 'BE'),
    '3638' => array('town' => 'Blumenstein', 'canton' => 'BE'),
    '3645' => array('town' => 'Gwatt (Thun)', 'canton' => 'BE'),
    '3646' => array('town' => 'Einigen', 'canton' => 'BE'),
    '3647' => array('town' => 'Reutigen', 'canton' => 'BE'),
    '3652' => array('town' => 'Hilterfingen', 'canton' => 'BE'),
    '3653' => array('town' => 'Oberhofen Thun\'see', 'canton' => 'BE'),
    '3654' => array('town' => 'Gunten', 'canton' => 'BE'),
    '3655' => array('town' => 'Sigriswil', 'canton' => 'BE'),
    '3656' => array('town' => 'Tschingel', 'canton' => 'BE'),
    '3657' => array('town' => 'Schwanden Sigrisw', 'canton' => 'BE'),
    '3658' => array('town' => 'Merligen', 'canton' => 'BE'),
    '3700' => array('town' => 'Spiez', 'canton' => 'BE'),
    '3702' => array('town' => 'Hondrich', 'canton' => 'BE'),
    '3703' => array('town' => 'Aeschi b. Spiez', 'canton' => 'BE'),
    '3704' => array('town' => 'Krattigen', 'canton' => 'BE'),
    '3705' => array('town' => 'Faulensee', 'canton' => 'BE'),
    '3706' => array('town' => 'Leissigen', 'canton' => 'BE'),
    '3707' => array('town' => 'Därligen', 'canton' => 'BE'),
    '3711' => array('town' => 'Emdthal', 'canton' => 'BE'),
    '3713' => array('town' => 'Reichenbach i. K.', 'canton' => 'BE'),
    '3714' => array('town' => 'Frutigen', 'canton' => 'BE'),
    '3715' => array('town' => 'Adelboden', 'canton' => 'BE'),
    '3716' => array('town' => 'Kandergrund', 'canton' => 'BE'),
    '3717' => array('town' => 'Blausee-Mitholz', 'canton' => 'BE'),
    '3718' => array('town' => 'Kandersteg', 'canton' => 'BE'),
    '3722' => array('town' => 'Scharnachtal', 'canton' => 'BE'),
    '3723' => array('town' => 'Kiental', 'canton' => 'BE'),
    '3724' => array('town' => 'Ried (Frutigen)', 'canton' => 'BE'),
    '3725' => array('town' => 'Achseten', 'canton' => 'BE'),
    '3752' => array('town' => 'Wimmis', 'canton' => 'BE'),
    '3753' => array('town' => 'Oey', 'canton' => 'BE'),
    '3754' => array('town' => 'Diemtigen', 'canton' => 'BE'),
    '3755' => array('town' => 'Horboden', 'canton' => 'BE'),
    '3756' => array('town' => 'Zwischenflüh', 'canton' => 'BE'),
    '3757' => array('town' => 'Schwenden', 'canton' => 'BE'),
    '3758' => array('town' => 'Latterbach', 'canton' => 'BE'),
    '3762' => array('town' => 'Erlenbach i. S.', 'canton' => 'BE'),
    '3763' => array('town' => 'Därstetten', 'canton' => 'BE'),
    '3764' => array('town' => 'Weissenburg', 'canton' => 'BE'),
    '3765' => array('town' => 'Oberwil i. S.', 'canton' => 'BE'),
    '3766' => array('town' => 'Boltigen', 'canton' => 'BE'),
    '3770' => array('town' => 'Zweisimmen', 'canton' => 'BE'),
    '3771' => array('town' => 'Blankenburg', 'canton' => 'BE'),
    '3772' => array('town' => 'St. Stephan', 'canton' => 'BE'),
    '3773' => array('town' => 'Matten(St.Stephan)', 'canton' => 'BE'),
    '3775' => array('town' => 'Lenk im Simmental', 'canton' => 'BE'),
    '3776' => array('town' => 'Oeschseite', 'canton' => 'BE'),
    '3777' => array('town' => 'Saanenmöser', 'canton' => 'BE'),
    '3778' => array('town' => 'Schönried', 'canton' => 'BE'),
    '3780' => array('town' => 'Gstaad', 'canton' => 'BE'),
    '3781' => array('town' => 'Turbach', 'canton' => 'BE'),
    '3782' => array('town' => 'Lauenen b. Gstaad', 'canton' => 'BE'),
    '3783' => array('town' => 'Grund b. Gstaad', 'canton' => 'BE'),
    '3784' => array('town' => 'Feutersoey', 'canton' => 'BE'),
    '3785' => array('town' => 'Gsteig b. Gstaad', 'canton' => 'BE'),
    '3792' => array('town' => 'Saanen', 'canton' => 'BE'),
    '3800' => array('town' => 'Interlaken', 'canton' => 'BE'),
    '3801' => array('town' => 'Jungfraujoch', 'canton' => 'VS'),
    '3803' => array('town' => 'Beatenberg', 'canton' => 'BE'),
    '3804' => array('town' => 'Habkern', 'canton' => 'BE'),
    '3805' => array('town' => 'Goldswil', 'canton' => 'BE'),
    '3806' => array('town' => 'Bönigen', 'canton' => 'BE'),
    '3807' => array('town' => 'Iseltwald', 'canton' => 'BE'),
    '3812' => array('town' => 'Wilderswil', 'canton' => 'BE'),
    '3813' => array('town' => 'Saxeten', 'canton' => 'BE'),
    '3814' => array('town' => 'Gsteigwiler', 'canton' => 'BE'),
    '3815' => array('town' => 'Zweilütschinen', 'canton' => 'BE'),
    '3816' => array('town' => 'Lütschental', 'canton' => 'BE'),
    '3818' => array('town' => 'Grindelwald', 'canton' => 'BE'),
    '3822' => array('town' => 'Lauterbrunnen', 'canton' => 'BE'),
    '3823' => array('town' => 'Wengen', 'canton' => 'BE'),
    '3824' => array('town' => 'Stechelberg', 'canton' => 'BE'),
    '3825' => array('town' => 'Mürren', 'canton' => 'BE'),
    '3826' => array('town' => 'Gimmelwald', 'canton' => 'BE'),
    '3852' => array('town' => 'Ringgenberg BE', 'canton' => 'BE'),
    '3853' => array('town' => 'Niederried Interl', 'canton' => 'BE'),
    '3854' => array('town' => 'Oberried Brienz', 'canton' => 'BE'),
    '3855' => array('town' => 'Brienz BE', 'canton' => 'BE'),
    '3856' => array('town' => 'Brienzwiler', 'canton' => 'BE'),
    '3857' => array('town' => 'Unterbach BE', 'canton' => 'BE'),
    '3858' => array('town' => 'Hofstetten BE', 'canton' => 'BE'),
    '3860' => array('town' => 'Meiringen', 'canton' => 'BE'),
    '3862' => array('town' => 'Innertkirchen', 'canton' => 'BE'),
    '3863' => array('town' => 'Gadmen', 'canton' => 'BE'),
    '3864' => array('town' => 'Guttannen', 'canton' => 'BE'),
    '3900' => array('town' => 'Brig', 'canton' => 'VS'),
    '3949' => array('town' => 'Hohtenn', 'canton' => 'VS'),
    '3903' => array('town' => 'Birgisch', 'canton' => 'VS'),
    '3914' => array('town' => 'Blatten b. Naters', 'canton' => 'VS'),
    '3913' => array('town' => 'Rosswald', 'canton' => 'VS'),
    '3911' => array('town' => 'Ried-Brig', 'canton' => 'VS'),
    '3912' => array('town' => 'Termen', 'canton' => 'VS'),
    '3901' => array('town' => 'Rothwald', 'canton' => 'VS'),
    '3907' => array('town' => 'Simplon Hospiz', 'canton' => 'VS'),
    '3922' => array('town' => 'Eisten', 'canton' => 'VS'),
    '3908' => array('town' => 'Saas-Balen', 'canton' => 'VS'),
    '3910' => array('town' => 'Saas-Grund', 'canton' => 'VS'),
    '3902' => array('town' => 'Glis', 'canton' => 'VS'),
    '3917' => array('town' => 'Goppenstein', 'canton' => 'VS'),
    '3916' => array('town' => 'Ferden', 'canton' => 'VS'),
    '3918' => array('town' => 'Wiler (Lötschen)', 'canton' => 'VS'),
    '3919' => array('town' => 'Blatten(Lötschen)', 'canton' => 'VS'),
    '3904' => array('town' => 'Naters', 'canton' => 'VS'),
    '3905' => array('town' => 'Saas-Almagell', 'canton' => 'VS'),
    '3906' => array('town' => 'Saas-Fee', 'canton' => 'VS'),
    '3920' => array('town' => 'Zermatt', 'canton' => 'VS'),
    '3923' => array('town' => 'Törbel', 'canton' => 'VS'),
    '3926' => array('town' => 'Embd', 'canton' => 'VS'),
    '3927' => array('town' => 'Herbriggen', 'canton' => 'VS'),
    '3928' => array('town' => 'Randa', 'canton' => 'VS'),
    '3929' => array('town' => 'Täsch', 'canton' => 'VS'),
    '3924' => array('town' => 'St. Niklaus VS', 'canton' => 'VS'),
    '3925' => array('town' => 'Grächen', 'canton' => 'VS'),
    '3930' => array('town' => 'Visp', 'canton' => 'VS'),
    '3942' => array('town' => 'St. German', 'canton' => 'VS'),
    '3933' => array('town' => 'Staldenried', 'canton' => 'VS'),
    '3937' => array('town' => 'Baltschieder', 'canton' => 'VS'),
    '3938' => array('town' => 'Ausserberg', 'canton' => 'VS'),
    '3939' => array('town' => 'Eggerberg', 'canton' => 'VS'),
    '3931' => array('town' => 'Lalden', 'canton' => 'VS'),
    '3932' => array('town' => 'Visperterminen', 'canton' => 'VS'),
    '3934' => array('town' => 'Zeneggen', 'canton' => 'VS'),
    '3935' => array('town' => 'Bürchen', 'canton' => 'VS'),
    '3943' => array('town' => 'Eischoll', 'canton' => 'VS'),
    '3944' => array('town' => 'Unterbäch VS', 'canton' => 'VS'),
    '3947' => array('town' => 'Ergisch', 'canton' => 'VS'),
    '3948' => array('town' => 'Unterems', 'canton' => 'VS'),
    '3946' => array('town' => 'Gruben', 'canton' => 'VS'),
    '3951' => array('town' => 'Agarn', 'canton' => 'VS'),
    '3955' => array('town' => 'Albinen', 'canton' => 'VS'),
    '3956' => array('town' => 'Guttet-Feschel', 'canton' => 'VS'),
    '3957' => array('town' => 'Erschmatt', 'canton' => 'VS'),
    '3953' => array('town' => 'Varen', 'canton' => 'VS'),
    '3976' => array('town' => 'Noës', 'canton' => 'VS'),
    '3978' => array('town' => 'Flanthey', 'canton' => 'VS'),
    '1978' => array('town' => 'Lens', 'canton' => 'VS'),
    '1977' => array('town' => 'Icogne', 'canton' => 'VS'),
    '3979' => array('town' => 'Grône', 'canton' => 'VS'),
    '3945' => array('town' => 'Gampel', 'canton' => 'VS'),
    '3952' => array('town' => 'Susten', 'canton' => 'VS'),
    '3954' => array('town' => 'Leukerbad', 'canton' => 'VS'),
    '3970' => array('town' => 'Salgesch', 'canton' => 'VS'),
    '3977' => array('town' => 'Granges VS', 'canton' => 'VS'),
    '1958' => array('town' => 'St-Léonard', 'canton' => 'VS'),
    '3960' => array('town' => 'Sierre', 'canton' => 'VS'),
    '3971' => array('town' => 'Chermignon', 'canton' => 'VS'),
    '3972' => array('town' => 'Miège', 'canton' => 'VS'),
    '3973' => array('town' => 'Venthône', 'canton' => 'VS'),
    '3974' => array('town' => 'Mollens VS', 'canton' => 'VS'),
    '3975' => array('town' => 'Randogne', 'canton' => 'VS'),
    '3961' => array('town' => 'Vissoie', 'canton' => 'VS'),
    '3967' => array('town' => 'Vercorin', 'canton' => 'VS'),
    '3963' => array('town' => 'Montana', 'canton' => 'VS'),
    '3965' => array('town' => 'Chippis', 'canton' => 'VS'),
    '3966' => array('town' => 'Chalais', 'canton' => 'VS'),
    '3968' => array('town' => 'Veyras', 'canton' => 'VS'),
    '3982' => array('town' => 'Bitsch', 'canton' => 'VS'),
    '3993' => array('town' => 'Grengiols', 'canton' => 'VS'),
    '3994' => array('town' => 'Lax', 'canton' => 'VS'),
    '3997' => array('town' => 'Bellwald', 'canton' => 'VS'),
    '3989' => array('town' => 'Niederwald', 'canton' => 'VS'),
    '3998' => array('town' => 'Gluringen', 'canton' => 'VS'),
    '3985' => array('town' => 'Geschinen', 'canton' => 'VS'),
    '3988' => array('town' => 'Obergesteln', 'canton' => 'VS'),
    '3999' => array('town' => 'Oberwald', 'canton' => 'VS'),
    '3986' => array('town' => 'Ried-Mörel', 'canton' => 'VS'),
    '3987' => array('town' => 'Riederalp', 'canton' => 'VS'),
    '3991' => array('town' => 'Betten', 'canton' => 'VS'),
    '3992' => array('town' => 'Bettmeralp', 'canton' => 'VS'),
    '3995' => array('town' => 'Ernen', 'canton' => 'VS'),
    '3996' => array('town' => 'Binn', 'canton' => 'VS'),
    '3983' => array('town' => 'Mörel', 'canton' => 'VS'),
    '3984' => array('town' => 'Fiesch', 'canton' => 'VS'),
    '4000' => array('town' => 'Basel', 'canton' => 'BS'),
    '4001' => array('town' => 'Basel', 'canton' => 'BS'),
    '4002' => array('town' => 'Basel', 'canton' => 'BS'),
    '4003' => array('town' => 'Basel', 'canton' => 'BS'),
    '4004' => array('town' => 'Basel', 'canton' => 'BS'),
    '4005' => array('town' => 'Basel', 'canton' => 'BS'),
    '4007' => array('town' => 'Basel', 'canton' => 'BS'),
    '4008' => array('town' => 'Basel', 'canton' => 'BS'),
    '4009' => array('town' => 'Basel', 'canton' => 'BS'),
    '4010' => array('town' => 'Basel', 'canton' => 'BS'),
    '4011' => array('town' => 'Basel', 'canton' => 'BS'),
    '4012' => array('town' => 'Basel', 'canton' => 'BS'),
    '4013' => array('town' => 'Basel', 'canton' => 'BS'),
    '4015' => array('town' => 'Basel', 'canton' => 'BS'),
    '4016' => array('town' => 'Basel', 'canton' => 'BS'),
    '4017' => array('town' => 'Basel', 'canton' => 'BS'),
    '4018' => array('town' => 'Basel', 'canton' => 'BS'),
    '4019' => array('town' => 'Basel', 'canton' => 'BS'),
    '4020' => array('town' => 'Basel', 'canton' => 'BS'),
    '4023' => array('town' => 'Basel', 'canton' => 'BL'),
    '4024' => array('town' => 'Basel', 'canton' => 'BS'),
    '4025' => array('town' => 'Basel', 'canton' => 'BS'),
    '4030' => array('town' => 'Basel', 'canton' => 'BS'),
    '4031' => array('town' => 'Basel UniSpital', 'canton' => 'BS'),
    '4032' => array('town' => 'Basel', 'canton' => 'BS'),
    '4051' => array('town' => 'Basel', 'canton' => 'BS'),
    '4052' => array('town' => 'Basel', 'canton' => 'BS'),
    '4053' => array('town' => 'Basel', 'canton' => 'BS'),
    '4054' => array('town' => 'Basel', 'canton' => 'BS'),
    '4055' => array('town' => 'Basel', 'canton' => 'BS'),
    '4056' => array('town' => 'Basel', 'canton' => 'BS'),
    '4057' => array('town' => 'Basel', 'canton' => 'BS'),
    '4058' => array('town' => 'Basel', 'canton' => 'BS'),
    '4059' => array('town' => 'Basel', 'canton' => 'BS'),
    '4091' => array('town' => 'Basel', 'canton' => 'BS'),
    '4101' => array('town' => 'Bruderholz', 'canton' => 'BL'),
    '4102' => array('town' => 'Binningen', 'canton' => 'BL'),
    '4103' => array('town' => 'Bottmingen', 'canton' => 'BL'),
    '4104' => array('town' => 'Oberwil BL', 'canton' => 'BL'),
    '4105' => array('town' => 'Biel-Benken BL', 'canton' => 'BL'),
    '4106' => array('town' => 'Therwil', 'canton' => 'BL'),
    '4107' => array('town' => 'Ettingen', 'canton' => 'BL'),
    '4108' => array('town' => 'Witterswil', 'canton' => 'SO'),
    '4112' => array('town' => 'Bättwil-Flüh', 'canton' => 'SO'),
    '4114' => array('town' => 'Hofstetten SO', 'canton' => 'SO'),
    '4115' => array('town' => 'Mariastein', 'canton' => 'SO'),
    '4116' => array('town' => 'Metzerlen', 'canton' => 'SO'),
    '4117' => array('town' => 'Burg im Leimental', 'canton' => 'BL'),
    '4118' => array('town' => 'Rodersdorf', 'canton' => 'SO'),
    '4123' => array('town' => 'Allschwil', 'canton' => 'BL'),
    '4124' => array('town' => 'Schönenbuch', 'canton' => 'BL'),
    '4125' => array('town' => 'Riehen', 'canton' => 'BS'),
    '4126' => array('town' => 'Bettingen', 'canton' => 'BS'),
    '4127' => array('town' => 'Birsfelden', 'canton' => 'BL'),
    '4132' => array('town' => 'Muttenz', 'canton' => 'BL'),
    '4133' => array('town' => 'Pratteln', 'canton' => 'BL'),
    '4142' => array('town' => 'Münchenstein', 'canton' => 'BL'),
    '4143' => array('town' => 'Dornach', 'canton' => 'SO'),
    '4144' => array('town' => 'Arlesheim', 'canton' => 'BL'),
    '4145' => array('town' => 'Gempen', 'canton' => 'SO'),
    '4146' => array('town' => 'Hochwald', 'canton' => 'SO'),
    '4147' => array('town' => 'Aesch BL', 'canton' => 'BL'),
    '4148' => array('town' => 'Pfeffingen', 'canton' => 'BL'),
    '4153' => array('town' => 'Reinach BL', 'canton' => 'BL'),
    '4202' => array('town' => 'Duggingen', 'canton' => 'BL'),
    '4203' => array('town' => 'Grellingen', 'canton' => 'BL'),
    '4206' => array('town' => 'Seewen SO', 'canton' => 'SO'),
    '4207' => array('town' => 'Bretzwil', 'canton' => 'BL'),
    '4208' => array('town' => 'Nunningen', 'canton' => 'SO'),
    '4222' => array('town' => 'Zwingen', 'canton' => 'BL'),
    '4225' => array('town' => 'Brislach', 'canton' => 'BL'),
    '4226' => array('town' => 'Breitenbach', 'canton' => 'SO'),
    '4227' => array('town' => 'Büsserach', 'canton' => 'SO'),
    '4228' => array('town' => 'Erschwil', 'canton' => 'SO'),
    '4242' => array('town' => 'Laufen', 'canton' => 'BL'),
    '4243' => array('town' => 'Dittingen', 'canton' => 'BL'),
    '4244' => array('town' => 'Röschenz', 'canton' => 'BL'),
    '4245' => array('town' => 'Kleinlützel', 'canton' => 'SO'),
    '4204' => array('town' => 'Himmelried', 'canton' => 'SO'),
    '4223' => array('town' => 'Blauen', 'canton' => 'BL'),
    '4224' => array('town' => 'Nenzlingen', 'canton' => 'BL'),
    '4229' => array('town' => 'Beinwil SO', 'canton' => 'SO'),
    '4232' => array('town' => 'Fehren', 'canton' => 'SO'),
    '4233' => array('town' => 'Meltingen', 'canton' => 'SO'),
    '4234' => array('town' => 'Zullwil', 'canton' => 'SO'),
    '4246' => array('town' => 'Wahlen b. Laufen', 'canton' => 'BL'),
    '4247' => array('town' => 'Grindel', 'canton' => 'SO'),
    '4252' => array('town' => 'Bärschwil', 'canton' => 'SO'),
    '4253' => array('town' => 'Liesberg', 'canton' => 'BL'),
    '4254' => array('town' => 'Liesberg Dorf', 'canton' => 'BL'),
    '4302' => array('town' => 'Augst BL', 'canton' => 'BL'),
    '4303' => array('town' => 'Kaiseraugst', 'canton' => 'AG'),
    '4304' => array('town' => 'Giebenach', 'canton' => 'BL'),
    '4305' => array('town' => 'Olsberg', 'canton' => 'AG'),
    '4310' => array('town' => 'Rheinfelden', 'canton' => 'AG'),
    '4312' => array('town' => 'Magden', 'canton' => 'AG'),
    '4313' => array('town' => 'Möhlin', 'canton' => 'AG'),
    '4314' => array('town' => 'Zeiningen', 'canton' => 'AG'),
    '4315' => array('town' => 'Zuzgen', 'canton' => 'AG'),
    '4316' => array('town' => 'Hellikon', 'canton' => 'AG'),
    '4317' => array('town' => 'Wegenstetten', 'canton' => 'AG'),
    '4322' => array('town' => 'Mumpf', 'canton' => 'AG'),
    '4323' => array('town' => 'Wallbach', 'canton' => 'AG'),
    '4324' => array('town' => 'Obermumpf', 'canton' => 'AG'),
    '4325' => array('town' => 'Schupfart', 'canton' => 'AG'),
    '4332' => array('town' => 'Stein AG', 'canton' => 'AG'),
    '4333' => array('town' => 'Münchwilen AG', 'canton' => 'AG'),
    '4334' => array('town' => 'Sisseln AG', 'canton' => 'AG'),
    '5080' => array('town' => 'Laufenburg', 'canton' => 'AG'),
    '5082' => array('town' => 'Kaisten', 'canton' => 'AG'),
    '5083' => array('town' => 'Ittenthal', 'canton' => 'AG'),
    '5084' => array('town' => 'Rheinsulz', 'canton' => 'AG'),
    '5085' => array('town' => 'Sulz AG', 'canton' => 'AG'),
    '5275' => array('town' => 'Etzgen', 'canton' => 'AG'),
    '5274' => array('town' => 'Mettau', 'canton' => 'AG'),
    '5273' => array('town' => 'Oberhofen AG', 'canton' => 'AG'),
    '5272' => array('town' => 'Gansingen', 'canton' => 'AG'),
    '5276' => array('town' => 'Wil AG', 'canton' => 'AG'),
    '5277' => array('town' => 'Hottwil', 'canton' => 'AG'),
    '5326' => array('town' => 'Schwaderloch', 'canton' => 'AG'),
    '5325' => array('town' => 'Leibstadt', 'canton' => 'AG'),
    '5324' => array('town' => 'Full-Reuenthal', 'canton' => 'AG'),
    '4402' => array('town' => 'Frenkendorf', 'canton' => 'BL'),
    '4410' => array('town' => 'Liestal', 'canton' => 'BL'),
    '4411' => array('town' => 'Seltisberg', 'canton' => 'BL'),
    '4412' => array('town' => 'Nuglar', 'canton' => 'SO'),
    '4413' => array('town' => 'Büren SO', 'canton' => 'SO'),
    '4414' => array('town' => 'Füllinsdorf', 'canton' => 'BL'),
    '4415' => array('town' => 'Lausen', 'canton' => 'BL'),
    '4416' => array('town' => 'Bubendorf', 'canton' => 'BL'),
    '4417' => array('town' => 'Ziefen', 'canton' => 'BL'),
    '4418' => array('town' => 'Reigoldswil', 'canton' => 'BL'),
    '4419' => array('town' => 'Lupsingen', 'canton' => 'BL'),
    '4421' => array('town' => 'St. Pantaleon', 'canton' => 'SO'),
    '4422' => array('town' => 'Arisdorf', 'canton' => 'BL'),
    '4423' => array('town' => 'Hersberg', 'canton' => 'BL'),
    '4424' => array('town' => 'Arboldswil', 'canton' => 'BL'),
    '4425' => array('town' => 'Titterten', 'canton' => 'BL'),
    '4426' => array('town' => 'Lauwil', 'canton' => 'BL'),
    '4431' => array('town' => 'Bennwil', 'canton' => 'BL'),
    '4432' => array('town' => 'Lampenberg', 'canton' => 'BL'),
    '4433' => array('town' => 'Ramlinsburg', 'canton' => 'BL'),
    '4434' => array('town' => 'Hölstein', 'canton' => 'BL'),
    '4435' => array('town' => 'Niederdorf', 'canton' => 'BL'),
    '4436' => array('town' => 'Oberdorf BL', 'canton' => 'BL'),
    '4437' => array('town' => 'Waldenburg', 'canton' => 'BL'),
    '4438' => array('town' => 'Langenbruck', 'canton' => 'BL'),
    '4441' => array('town' => 'Thürnen', 'canton' => 'BL'),
    '4442' => array('town' => 'Diepflingen', 'canton' => 'BL'),
    '4443' => array('town' => 'Wittinsburg', 'canton' => 'BL'),
    '4444' => array('town' => 'Rümlingen', 'canton' => 'BL'),
    '4445' => array('town' => 'Häfelfingen', 'canton' => 'BL'),
    '4446' => array('town' => 'Buckten', 'canton' => 'BL'),
    '4447' => array('town' => 'Känerkinden', 'canton' => 'BL'),
    '4448' => array('town' => 'Läufelfingen', 'canton' => 'BL'),
    '4450' => array('town' => 'Sissach', 'canton' => 'BL'),
    '4451' => array('town' => 'Wintersingen', 'canton' => 'BL'),
    '4452' => array('town' => 'Itingen', 'canton' => 'BL'),
    '4453' => array('town' => 'Nusshof', 'canton' => 'BL'),
    '4455' => array('town' => 'Zunzgen', 'canton' => 'BL'),
    '4456' => array('town' => 'Tenniken', 'canton' => 'BL'),
    '4457' => array('town' => 'Diegten', 'canton' => 'BL'),
    '4458' => array('town' => 'Eptingen', 'canton' => 'BL'),
    '4460' => array('town' => 'Gelterkinden', 'canton' => 'BL'),
    '4461' => array('town' => 'Böckten', 'canton' => 'BL'),
    '4465' => array('town' => 'Hemmiken', 'canton' => 'BL'),
    '4469' => array('town' => 'Anwil', 'canton' => 'BL'),
    '4462' => array('town' => 'Rickenbach BL', 'canton' => 'BL'),
    '4463' => array('town' => 'Buus', 'canton' => 'BL'),
    '4464' => array('town' => 'Maisprach', 'canton' => 'BL'),
    '4466' => array('town' => 'Ormalingen', 'canton' => 'BL'),
    '4467' => array('town' => 'Rothenfluh', 'canton' => 'BL'),
    '4468' => array('town' => 'Kienberg', 'canton' => 'SO'),
    '4492' => array('town' => 'Tecknau', 'canton' => 'BL'),
    '4493' => array('town' => 'Wenslingen', 'canton' => 'BL'),
    '4494' => array('town' => 'Oltingen', 'canton' => 'BL'),
    '4495' => array('town' => 'Zeglingen', 'canton' => 'BL'),
    '4496' => array('town' => 'Kilchberg BL', 'canton' => 'BL'),
    '4497' => array('town' => 'Rünenberg', 'canton' => 'BL'),
    '4500' => array('town' => 'Solothurn', 'canton' => 'SO'),
    '4501' => array('town' => 'Solothurn', 'canton' => 'SO'),
    '4502' => array('town' => 'Solothurn', 'canton' => 'SO'),
    '4503' => array('town' => 'Solothurn', 'canton' => 'SO'),
    '4515' => array('town' => 'Weissenstein', 'canton' => 'SO'),
    '4525' => array('town' => 'Balm b. Günsberg', 'canton' => 'SO'),
    '4523' => array('town' => 'Niederwil SO', 'canton' => 'SO'),
    '4535' => array('town' => 'Hubersdorf', 'canton' => 'SO'),
    '4539' => array('town' => 'Rumisberg', 'canton' => 'BE'),
    '4557' => array('town' => 'Horriwil', 'canton' => 'SO'),
    '4558' => array('town' => 'Hersiwil', 'canton' => 'SO'),
    '4512' => array('town' => 'Bellach', 'canton' => 'SO'),
    '4513' => array('town' => 'Langendorf', 'canton' => 'SO'),
    '4514' => array('town' => 'Lommiswil', 'canton' => 'SO'),
    '4522' => array('town' => 'Rüttenen', 'canton' => 'SO'),
    '4524' => array('town' => 'Günsberg', 'canton' => 'SO'),
    '4528' => array('town' => 'Zuchwil', 'canton' => 'SO'),
    '4532' => array('town' => 'Feldbrunnen', 'canton' => 'SO'),
    '4533' => array('town' => 'Riedholz', 'canton' => 'SO'),
    '4534' => array('town' => 'Flumenthal', 'canton' => 'SO'),
    '4536' => array('town' => 'Attiswil', 'canton' => 'BE'),
    '4537' => array('town' => 'Wiedlisbach', 'canton' => 'BE'),
    '4538' => array('town' => 'Oberbipp', 'canton' => 'BE'),
    '4552' => array('town' => 'Derendingen', 'canton' => 'SO'),
    '4553' => array('town' => 'Subingen', 'canton' => 'SO'),
    '4554' => array('town' => 'Etziken', 'canton' => 'SO'),
    '3375' => array('town' => 'Inkwil', 'canton' => 'BE'),
    '4562' => array('town' => 'Biberist', 'canton' => 'SO'),
    '4563' => array('town' => 'Gerlafingen', 'canton' => 'SO'),
    '4564' => array('town' => 'Obergerlafingen', 'canton' => 'SO'),
    '4565' => array('town' => 'Recherswil', 'canton' => 'SO'),
    '4566' => array('town' => 'Kriegstetten', 'canton' => 'SO'),
    '4581' => array('town' => 'Küttigkofen', 'canton' => 'SO'),
    '4586' => array('town' => 'Kyburg-Buchegg', 'canton' => 'SO'),
    '4582' => array('town' => 'Brügglen', 'canton' => 'SO'),
    '4583' => array('town' => 'Mühledorf SO', 'canton' => 'SO'),
    '4579' => array('town' => 'Gossliwil', 'canton' => 'SO'),
    '4578' => array('town' => 'Bibern SO', 'canton' => 'SO'),
    '4571' => array('town' => 'Lüterkofen-Ichert', 'canton' => 'SO'),
    '4576' => array('town' => 'Tscheppach', 'canton' => 'SO'),
    '4577' => array('town' => 'Hessigkofen', 'canton' => 'SO'),
    '4585' => array('town' => 'Biezwil', 'canton' => 'SO'),
    '4587' => array('town' => 'Aetingen', 'canton' => 'SO'),
    '4588' => array('town' => 'Unterramsern', 'canton' => 'SO'),
    '4574' => array('town' => 'Nennigkofen', 'canton' => 'SO'),
    '4600' => array('town' => 'Olten', 'canton' => 'SO'),
    '4601' => array('town' => 'Olten', 'canton' => 'SO'),
    '4603' => array('town' => 'Olten', 'canton' => 'SO'),
    '4612' => array('town' => 'Wangen b. Olten', 'canton' => 'SO'),
    '4613' => array('town' => 'Rickenbach SO', 'canton' => 'SO'),
    '4614' => array('town' => 'Hägendorf', 'canton' => 'SO'),
    '4616' => array('town' => 'Kappel SO', 'canton' => 'SO'),
    '4617' => array('town' => 'Gunzgen', 'canton' => 'SO'),
    '4618' => array('town' => 'Boningen', 'canton' => 'SO'),
    '4622' => array('town' => 'Egerkingen', 'canton' => 'SO'),
    '4623' => array('town' => 'Neuendorf', 'canton' => 'SO'),
    '4624' => array('town' => 'Härkingen', 'canton' => 'SO'),
    '4625' => array('town' => 'Oberbuchsiten', 'canton' => 'SO'),
    '4626' => array('town' => 'Niederbuchsiten', 'canton' => 'SO'),
    '4632' => array('town' => 'Trimbach', 'canton' => 'SO'),
    '4652' => array('town' => 'Winznau', 'canton' => 'SO'),
    '4653' => array('town' => 'Obergösgen', 'canton' => 'SO'),
    '4654' => array('town' => 'Lostorf', 'canton' => 'SO'),
    '4655' => array('town' => 'Stüsslingen', 'canton' => 'SO'),
    '4656' => array('town' => 'Starrkirch-Wil', 'canton' => 'SO'),
    '4657' => array('town' => 'Dulliken', 'canton' => 'SO'),
    '4658' => array('town' => 'Däniken SO', 'canton' => 'SO'),
    '5010' => array('town' => 'Däniken PZ', 'canton' => 'SO'),
    '4663' => array('town' => 'Aarburg', 'canton' => 'AG'),
    '4665' => array('town' => 'Oftringen', 'canton' => 'AG'),
    '4615' => array('town' => 'Allerheiligenberg', 'canton' => 'SO'),
    '4633' => array('town' => 'Hauenstein', 'canton' => 'SO'),
    '4634' => array('town' => 'Wisen SO', 'canton' => 'SO'),
    '4702' => array('town' => 'Oensingen', 'canton' => 'SO'),
    '4703' => array('town' => 'Kestenholz', 'canton' => 'SO'),
    '4704' => array('town' => 'Niederbipp', 'canton' => 'BE'),
    '3380' => array('town' => 'Wangen an der Aare', 'canton' => 'BE'),
    '3377' => array('town' => 'Walliswil b.Wangen', 'canton' => 'BE'),
    '4543' => array('town' => 'Deitingen', 'canton' => 'SO'),
    '4542' => array('town' => 'Luterbach', 'canton' => 'SO'),
    '4710' => array('town' => 'Balsthal', 'canton' => 'SO'),
    '4714' => array('town' => 'Aedermannsdorf', 'canton' => 'SO'),
    '4715' => array('town' => 'Herbetswil', 'canton' => 'SO'),
    '4719' => array('town' => 'Ramiswil', 'canton' => 'SO'),
    '4712' => array('town' => 'Laupersdorf', 'canton' => 'SO'),
    '4713' => array('town' => 'Matzendorf', 'canton' => 'SO'),
    '4716' => array('town' => 'Welschenrohr', 'canton' => 'SO'),
    '4717' => array('town' => 'Mümliswil', 'canton' => 'SO'),
    '4718' => array('town' => 'Holderbank SO', 'canton' => 'SO'),
    '4800' => array('town' => 'Zofingen', 'canton' => 'AG'),
    '4801' => array('town' => 'Zofingen', 'canton' => 'AG'),
    '4802' => array('town' => 'Strengelbach', 'canton' => 'AG'),
    '4803' => array('town' => 'Vordemwald', 'canton' => 'AG'),
    '4805' => array('town' => 'Brittnau', 'canton' => 'AG'),
    '4806' => array('town' => 'Wikon', 'canton' => 'LU'),
    '4812' => array('town' => 'Mühlethal', 'canton' => 'AG'),
    '4813' => array('town' => 'Uerkheim', 'canton' => 'AG'),
    '4814' => array('town' => 'Bottenwil', 'canton' => 'AG'),
    '4852' => array('town' => 'Rothrist', 'canton' => 'AG'),
    '4853' => array('town' => 'Murgenthal', 'canton' => 'AG'),
    '4629' => array('town' => 'Fulenbach', 'canton' => 'SO'),
    '4628' => array('town' => 'Wolfwil', 'canton' => 'SO'),
    '4856' => array('town' => 'Glashütten', 'canton' => 'AG'),
    '4900' => array('town' => 'Langenthal', 'canton' => 'BE'),
    '4901' => array('town' => 'Langenthal', 'canton' => 'BE'),
    '4902' => array('town' => 'Langenthal', 'canton' => 'BE'),
    '4911' => array('town' => 'Schwarzhäusern', 'canton' => 'BE'),
    '4912' => array('town' => 'Aarwangen', 'canton' => 'BE'),
    '4913' => array('town' => 'Bannwil', 'canton' => 'BE'),
    '4914' => array('town' => 'Roggwil BE', 'canton' => 'BE'),
    '4915' => array('town' => 'St. Urban', 'canton' => 'LU'),
    '4916' => array('town' => 'Untersteckholz', 'canton' => 'BE'),
    '4917' => array('town' => 'Melchnau', 'canton' => 'BE'),
    '4955' => array('town' => 'Gondiswil', 'canton' => 'BE'),
    '4919' => array('town' => 'Reisiswil', 'canton' => 'BE'),
    '4922' => array('town' => 'Bützberg', 'canton' => 'BE'),
    '4923' => array('town' => 'Wynau', 'canton' => 'BE'),
    '4924' => array('town' => 'Obersteckholz', 'canton' => 'BE'),
    '4932' => array('town' => 'Lotzwil', 'canton' => 'BE'),
    '4933' => array('town' => 'Rütschelen', 'canton' => 'BE'),
    '4934' => array('town' => 'Madiswil', 'canton' => 'BE'),
    '4935' => array('town' => 'Leimiswil', 'canton' => 'BE'),
    '4936' => array('town' => 'Kleindietwil', 'canton' => 'BE'),
    '4937' => array('town' => 'Ursenbach', 'canton' => 'BE'),
    '4938' => array('town' => 'Rohrbach', 'canton' => 'BE'),
    '4942' => array('town' => 'Walterswil BE', 'canton' => 'BE'),
    '4943' => array('town' => 'Oeschenbach', 'canton' => 'BE'),
    '4944' => array('town' => 'Auswil', 'canton' => 'BE'),
    '4950' => array('town' => 'Huttwil', 'canton' => 'BE'),
    '4952' => array('town' => 'Eriswil', 'canton' => 'BE'),
    '4953' => array('town' => 'Schwarzenbach BE', 'canton' => 'BE'),
    '4954' => array('town' => 'Wyssachen', 'canton' => 'BE'),
    '5000' => array('town' => 'Aarau', 'canton' => 'AG'),
    '5001' => array('town' => 'Aarau', 'canton' => 'AG'),
    '5004' => array('town' => 'Aarau', 'canton' => 'AG'),
    '5012' => array('town' => 'Schönenwerd', 'canton' => 'SO'),
    '5013' => array('town' => 'Niedergösgen', 'canton' => 'SO'),
    '5014' => array('town' => 'Gretzenbach', 'canton' => 'SO'),
    '5015' => array('town' => 'Erlinsbach SO', 'canton' => 'SO'),
    '5017' => array('town' => 'Barmelweid', 'canton' => 'AG'),
    '5022' => array('town' => 'Rombach', 'canton' => 'AG'),
    '5023' => array('town' => 'Biberstein', 'canton' => 'AG'),
    '5024' => array('town' => 'Küttigen', 'canton' => 'AG'),
    '5025' => array('town' => 'Asp', 'canton' => 'AG'),
    '5026' => array('town' => 'Densbüren', 'canton' => 'AG'),
    '5027' => array('town' => 'Herznach', 'canton' => 'AG'),
    '5028' => array('town' => 'Ueken', 'canton' => 'AG'),
    '5032' => array('town' => 'Aarau Rohr', 'canton' => 'AG'),
    '5033' => array('town' => 'Buchs AG', 'canton' => 'AG'),
    '5034' => array('town' => 'Suhr', 'canton' => 'AG'),
    '5035' => array('town' => 'Unterentfelden', 'canton' => 'AG'),
    '5036' => array('town' => 'Oberentfelden', 'canton' => 'AG'),
    '5037' => array('town' => 'Muhen', 'canton' => 'AG'),
    '5040' => array('town' => 'Schöftland', 'canton' => 'AG'),
    '5042' => array('town' => 'Hirschthal', 'canton' => 'AG'),
    '5043' => array('town' => 'Holziken', 'canton' => 'AG'),
    '5044' => array('town' => 'Schlossrued', 'canton' => 'AG'),
    '5046' => array('town' => 'Schmiedrued', 'canton' => 'AG'),
    '5053' => array('town' => 'Staffelbach', 'canton' => 'AG'),
    '5054' => array('town' => 'Kirchleerau-Moosle', 'canton' => 'AG'),
    '5056' => array('town' => 'Attelwil', 'canton' => 'AG'),
    '5057' => array('town' => 'Reitnau', 'canton' => 'AG'),
    '5102' => array('town' => 'Rupperswil', 'canton' => 'AG'),
    '5103' => array('town' => 'Wildegg', 'canton' => 'AG'),
    '5105' => array('town' => 'Auenstein', 'canton' => 'AG'),
    '5106' => array('town' => 'Veltheim AG', 'canton' => 'AG'),
    '5107' => array('town' => 'Schinznach Dorf', 'canton' => 'AG'),
    '5108' => array('town' => 'Oberflachs', 'canton' => 'AG'),
    '5112' => array('town' => 'Thalheim AG', 'canton' => 'AG'),
    '5113' => array('town' => 'Holderbank AG', 'canton' => 'AG'),
    '5116' => array('town' => 'Schinznach Bad', 'canton' => 'AG'),
    '5245' => array('town' => 'Habsburg', 'canton' => 'AG'),
    '5246' => array('town' => 'Scherz', 'canton' => 'AG'),
    '5200' => array('town' => 'Brugg AG', 'canton' => 'AG'),
    '5210' => array('town' => 'Windisch', 'canton' => 'AG'),
    '5201' => array('town' => 'Brugg AG', 'canton' => 'AG'),
    '5212' => array('town' => 'Hausen AG', 'canton' => 'AG'),
    '5213' => array('town' => 'Villnachern', 'canton' => 'AG'),
    '5222' => array('town' => 'Umiken', 'canton' => 'AG'),
    '5223' => array('town' => 'Riniken', 'canton' => 'AG'),
    '5224' => array('town' => 'Unterbözberg', 'canton' => 'AG'),
    '5225' => array('town' => 'Oberbözberg', 'canton' => 'AG'),
    '5233' => array('town' => 'Stilli', 'canton' => 'AG'),
    '5234' => array('town' => 'Villigen', 'canton' => 'AG'),
    '5235' => array('town' => 'Rüfenach AG', 'canton' => 'AG'),
    '5236' => array('town' => 'Remigen', 'canton' => 'AG'),
    '5237' => array('town' => 'Mönthal', 'canton' => 'AG'),
    '5242' => array('town' => 'Birr-Lupfig', 'canton' => 'AG'),
    '5243' => array('town' => 'Mülligen', 'canton' => 'AG'),
    '5244' => array('town' => 'Birrhard', 'canton' => 'AG'),
    '5078' => array('town' => 'Effingen', 'canton' => 'AG'),
    '5076' => array('town' => 'Bözen', 'canton' => 'AG'),
    '5077' => array('town' => 'Elfingen', 'canton' => 'AG'),
    '5079' => array('town' => 'Zeihen', 'canton' => 'AG'),
    '5075' => array('town' => 'Hornussen', 'canton' => 'AG'),
    '5070' => array('town' => 'Frick', 'canton' => 'AG'),
    '5072' => array('town' => 'Oeschgen', 'canton' => 'AG'),
    '5073' => array('town' => 'Gipf-Oberfrick', 'canton' => 'AG'),
    '5064' => array('town' => 'Wittnau', 'canton' => 'AG'),
    '5063' => array('town' => 'Wölflinswil', 'canton' => 'AG'),
    '5062' => array('town' => 'Oberhof', 'canton' => 'AG'),
    '5074' => array('town' => 'Eiken', 'canton' => 'AG'),
    '5300' => array('town' => 'Turgi', 'canton' => 'AG'),
    '5301' => array('town' => 'Siggenthal Station', 'canton' => 'AG'),
    '5303' => array('town' => 'Würenlingen', 'canton' => 'AG'),
    '5304' => array('town' => 'Endingen', 'canton' => 'AG'),
    '5305' => array('town' => 'Unterendingen', 'canton' => 'AG'),
    '5306' => array('town' => 'Tegerfelden', 'canton' => 'AG'),
    '5312' => array('town' => 'Döttingen', 'canton' => 'AG'),
    '5313' => array('town' => 'Klingnau', 'canton' => 'AG'),
    '5314' => array('town' => 'Kleindöttingen', 'canton' => 'AG'),
    '5315' => array('town' => 'Böttstein', 'canton' => 'AG'),
    '5316' => array('town' => 'Leuggern', 'canton' => 'AG'),
    '5317' => array('town' => 'Hettenschwil', 'canton' => 'AG'),
    '5318' => array('town' => 'Mandach', 'canton' => 'AG'),
    '5322' => array('town' => 'Koblenz', 'canton' => 'AG'),
    '5400' => array('town' => 'Baden', 'canton' => 'AG'),
    '5408' => array('town' => 'Ennetbaden', 'canton' => 'AG'),
    '5401' => array('town' => 'Baden', 'canton' => 'AG'),
    '5402' => array('town' => 'Baden', 'canton' => 'AG'),
    '5404' => array('town' => 'Baden', 'canton' => 'AG'),
    '5405' => array('town' => 'Baden', 'canton' => 'AG'),
    '5406' => array('town' => 'Baden', 'canton' => 'AG'),
    '5412' => array('town' => 'Gebenstorf', 'canton' => 'AG'),
    '5413' => array('town' => 'Birmenstorf AG', 'canton' => 'AG'),
    '5415' => array('town' => 'Nussbaumen AG', 'canton' => 'AG'),
    '5416' => array('town' => 'Kirchdorf AG', 'canton' => 'AG'),
    '5417' => array('town' => 'Untersiggenthal', 'canton' => 'AG'),
    '5420' => array('town' => 'Ehrendingen', 'canton' => 'AG'),
    '5423' => array('town' => 'Freienwil', 'canton' => 'AG'),
    '5425' => array('town' => 'Schneisingen', 'canton' => 'AG'),
    '5426' => array('town' => 'Lengnau AG', 'canton' => 'AG'),
    '5430' => array('town' => 'Wettingen', 'canton' => 'AG'),
    '5431' => array('town' => 'Wettingen Sonderd', 'canton' => 'AG'),
    '5432' => array('town' => 'Neuenhof', 'canton' => 'AG'),
    '5442' => array('town' => 'Fislisbach', 'canton' => 'AG'),
    '5443' => array('town' => 'Niederrohrdorf', 'canton' => 'AG'),
    '5444' => array('town' => 'Künten', 'canton' => 'AG'),
    '5445' => array('town' => 'Eggenwil', 'canton' => 'AG'),
    '5452' => array('town' => 'Oberrohrdorf', 'canton' => 'AG'),
    '5453' => array('town' => 'Remetschwil', 'canton' => 'AG'),
    '5454' => array('town' => 'Bellikon', 'canton' => 'AG'),
    '5502' => array('town' => 'Hunzenschwil', 'canton' => 'AG'),
    '5503' => array('town' => 'Schafisheim', 'canton' => 'AG'),
    '5504' => array('town' => 'Othmarsingen', 'canton' => 'AG'),
    '5505' => array('town' => 'Brunegg', 'canton' => 'AG'),
    '5506' => array('town' => 'Mägenwil', 'canton' => 'AG'),
    '5507' => array('town' => 'Mellingen', 'canton' => 'AG'),
    '5512' => array('town' => 'Wohlenschwil', 'canton' => 'AG'),
    '5522' => array('town' => 'Tägerig', 'canton' => 'AG'),
    '5524' => array('town' => 'Nesselnbach', 'canton' => 'AG'),
    '5525' => array('town' => 'Fischbach-Göslikon', 'canton' => 'AG'),
    '5600' => array('town' => 'Lenzburg', 'canton' => 'AG'),
    '5603' => array('town' => 'Staufen', 'canton' => 'AG'),
    '5604' => array('town' => 'Hendschiken', 'canton' => 'AG'),
    '5605' => array('town' => 'Dottikon', 'canton' => 'AG'),
    '5606' => array('town' => 'Dintikon', 'canton' => 'AG'),
    '5607' => array('town' => 'Hägglingen', 'canton' => 'AG'),
    '5608' => array('town' => 'Stetten AG', 'canton' => 'AG'),
    '5610' => array('town' => 'Wohlen AG', 'canton' => 'AG'),
    '5611' => array('town' => 'Anglikon', 'canton' => 'AG'),
    '5619' => array('town' => 'Büttikon AG', 'canton' => 'AG'),
    '5612' => array('town' => 'Villmergen', 'canton' => 'AG'),
    '5613' => array('town' => 'Hilfikon', 'canton' => 'AG'),
    '5614' => array('town' => 'Sarmenstorf', 'canton' => 'AG'),
    '5615' => array('town' => 'Fahrwangen', 'canton' => 'AG'),
    '5616' => array('town' => 'Meisterschwanden', 'canton' => 'AG'),
    '5617' => array('town' => 'Tennwil', 'canton' => 'AG'),
    '5618' => array('town' => 'Bettwil', 'canton' => 'AG'),
    '5620' => array('town' => 'Bremgarten AG', 'canton' => 'AG'),
    '5621' => array('town' => 'Zufikon', 'canton' => 'AG'),
    '5622' => array('town' => 'Waltenschwil', 'canton' => 'AG'),
    '5623' => array('town' => 'Boswil', 'canton' => 'AG'),
    '5624' => array('town' => 'Bünzen', 'canton' => 'AG'),
    '5625' => array('town' => 'Kallern', 'canton' => 'AG'),
    '5626' => array('town' => 'Hermetschwil-Staff', 'canton' => 'AG'),
    '5627' => array('town' => 'Besenbüren', 'canton' => 'AG'),
    '5628' => array('town' => 'Aristau', 'canton' => 'AG'),
    '5630' => array('town' => 'Muri AG', 'canton' => 'AG'),
    '5632' => array('town' => 'Buttwil', 'canton' => 'AG'),
    '5634' => array('town' => 'Merenschwand', 'canton' => 'AG'),
    '5636' => array('town' => 'Benzenschwil', 'canton' => 'AG'),
    '5637' => array('town' => 'Beinwil (Freiamt)', 'canton' => 'AG'),
    '5642' => array('town' => 'Mühlau', 'canton' => 'AG'),
    '5643' => array('town' => 'Sins', 'canton' => 'AG'),
    '5644' => array('town' => 'Auw', 'canton' => 'AG'),
    '5645' => array('town' => 'Aettenschwil', 'canton' => 'AG'),
    '5646' => array('town' => 'Abtwil AG', 'canton' => 'AG'),
    '5647' => array('town' => 'Oberrüti', 'canton' => 'AG'),
    '5702' => array('town' => 'Niederlenz', 'canton' => 'AG'),
    '5703' => array('town' => 'Seon', 'canton' => 'AG'),
    '5704' => array('town' => 'Egliswil', 'canton' => 'AG'),
    '5705' => array('town' => 'Hallwil', 'canton' => 'AG'),
    '5706' => array('town' => 'Boniswil', 'canton' => 'AG'),
    '5707' => array('town' => 'Seengen', 'canton' => 'AG'),
    '5708' => array('town' => 'Birrwil', 'canton' => 'AG'),
    '5712' => array('town' => 'Beinwil am See', 'canton' => 'AG'),
    '5722' => array('town' => 'Gränichen', 'canton' => 'AG'),
    '5723' => array('town' => 'Teufenthal AG', 'canton' => 'AG'),
    '5724' => array('town' => 'Dürrenäsch', 'canton' => 'AG'),
    '5725' => array('town' => 'Leutwil', 'canton' => 'AG'),
    '5726' => array('town' => 'Unterkulm', 'canton' => 'AG'),
    '5727' => array('town' => 'Oberkulm', 'canton' => 'AG'),
    '5728' => array('town' => 'Gontenschwil', 'canton' => 'AG'),
    '5732' => array('town' => 'Zetzwil', 'canton' => 'AG'),
    '5733' => array('town' => 'Leimbach AG', 'canton' => 'AG'),
    '5734' => array('town' => 'Reinach AG', 'canton' => 'AG'),
    '5735' => array('town' => 'Pfeffikon LU', 'canton' => 'LU'),
    '5736' => array('town' => 'Burg AG', 'canton' => 'AG'),
    '5737' => array('town' => 'Menziken', 'canton' => 'AG'),
    '5742' => array('town' => 'Kölliken', 'canton' => 'AG'),
    '5745' => array('town' => 'Safenwil', 'canton' => 'AG'),
    '5746' => array('town' => 'Walterswil SO', 'canton' => 'SO'),
    '6000' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6002' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6003' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6004' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6005' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6006' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6010' => array('town' => 'Kriens', 'canton' => 'LU'),
    '6012' => array('town' => 'Obernau', 'canton' => 'LU'),
    '6013' => array('town' => 'Eigenthal', 'canton' => 'LU'),
    '6014' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6015' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6016' => array('town' => 'Hellbühl', 'canton' => 'LU'),
    '6017' => array('town' => 'Ruswil', 'canton' => 'LU'),
    '6019' => array('town' => 'Sigigen', 'canton' => 'LU'),
    '6018' => array('town' => 'Buttisholz', 'canton' => 'LU'),
    '6020' => array('town' => 'Emmenbrücke', 'canton' => 'LU'),
    '6022' => array('town' => 'Grosswangen', 'canton' => 'LU'),
    '6023' => array('town' => 'Rothenburg', 'canton' => 'LU'),
    '6024' => array('town' => 'Hildisrieden', 'canton' => 'LU'),
    '6025' => array('town' => 'Neudorf', 'canton' => 'LU'),
    '6026' => array('town' => 'Rain', 'canton' => 'LU'),
    '6027' => array('town' => 'Römerswil LU', 'canton' => 'LU'),
    '6028' => array('town' => 'Herlisberg', 'canton' => 'LU'),
    '6030' => array('town' => 'Ebikon', 'canton' => 'LU'),
    '6032' => array('town' => 'Emmen', 'canton' => 'LU'),
    '6033' => array('town' => 'Buchrain', 'canton' => 'LU'),
    '6034' => array('town' => 'Inwil', 'canton' => 'LU'),
    '6035' => array('town' => 'Perlen', 'canton' => 'LU'),
    '6036' => array('town' => 'Dierikon', 'canton' => 'LU'),
    '6037' => array('town' => 'Root', 'canton' => 'LU'),
    '6038' => array('town' => 'Gisikon', 'canton' => 'LU'),
    '6042' => array('town' => 'Dietwil', 'canton' => 'AG'),
    '6043' => array('town' => 'Adligenswil', 'canton' => 'LU'),
    '6044' => array('town' => 'Udligenswil', 'canton' => 'LU'),
    '6045' => array('town' => 'Meggen', 'canton' => 'LU'),
    '6047' => array('town' => 'Kastanienbaum', 'canton' => 'LU'),
    '6048' => array('town' => 'Horw', 'canton' => 'LU'),
    '6052' => array('town' => 'Hergiswil NW', 'canton' => 'NW'),
    '6053' => array('town' => 'Alpnachstad', 'canton' => 'OW'),
    '6055' => array('town' => 'Alpnach Dorf', 'canton' => 'OW'),
    '6056' => array('town' => 'Kägiswil', 'canton' => 'OW'),
    '6060' => array('town' => 'Sarnen', 'canton' => 'OW'),
    '6068' => array('town' => 'Melchsee-Frutt', 'canton' => 'OW'),
    '6062' => array('town' => 'Wilen (Sarnen)', 'canton' => 'OW'),
    '6063' => array('town' => 'Stalden (Sarnen)', 'canton' => 'OW'),
    '6064' => array('town' => 'Kerns', 'canton' => 'OW'),
    '6066' => array('town' => 'St. Niklausen OW', 'canton' => 'OW'),
    '6067' => array('town' => 'Melchtal', 'canton' => 'OW'),
    '6072' => array('town' => 'Sachseln', 'canton' => 'OW'),
    '6073' => array('town' => 'Flüeli-Ranft', 'canton' => 'OW'),
    '6074' => array('town' => 'Giswil', 'canton' => 'OW'),
    '6078' => array('town' => 'Bürglen OW', 'canton' => 'OW'),
    '6083' => array('town' => 'Hasliberg Hohfluh', 'canton' => 'BE'),
    '6084' => array('town' => 'Hasliberg Wasserw', 'canton' => 'BE'),
    '6085' => array('town' => 'Hasliberg Goldern', 'canton' => 'BE'),
    '6086' => array('town' => 'Hasliberg Reuti', 'canton' => 'BE'),
    '6102' => array('town' => 'Malters', 'canton' => 'LU'),
    '6103' => array('town' => 'Schwarzenberg LU', 'canton' => 'LU'),
    '6105' => array('town' => 'Schachen LU', 'canton' => 'LU'),
    '6106' => array('town' => 'Werthenstein', 'canton' => 'LU'),
    '6110' => array('town' => 'Wolhusen', 'canton' => 'LU'),
    '6114' => array('town' => 'Steinhuserberg', 'canton' => 'LU'),
    '6112' => array('town' => 'Doppleschwand', 'canton' => 'LU'),
    '6113' => array('town' => 'Romoos', 'canton' => 'LU'),
    '6122' => array('town' => 'Menznau', 'canton' => 'LU'),
    '6123' => array('town' => 'Geiss', 'canton' => 'LU'),
    '6125' => array('town' => 'Menzberg', 'canton' => 'LU'),
    '6126' => array('town' => 'Daiwil', 'canton' => 'LU'),
    '6130' => array('town' => 'Willisau', 'canton' => 'LU'),
    '6132' => array('town' => 'Rohrmatt', 'canton' => 'LU'),
    '6133' => array('town' => 'Hergiswil LU', 'canton' => 'LU'),
    '6142' => array('town' => 'Gettnau', 'canton' => 'LU'),
    '6143' => array('town' => 'Ohmstal', 'canton' => 'LU'),
    '6144' => array('town' => 'Zell LU', 'canton' => 'LU'),
    '6145' => array('town' => 'Fischbach LU', 'canton' => 'LU'),
    '6146' => array('town' => 'Grossdietwil', 'canton' => 'LU'),
    '6147' => array('town' => 'Altbüron', 'canton' => 'LU'),
    '6152' => array('town' => 'Hüswil', 'canton' => 'LU'),
    '6153' => array('town' => 'Ufhusen', 'canton' => 'LU'),
    '6154' => array('town' => 'Hofstatt', 'canton' => 'LU'),
    '6156' => array('town' => 'Luthern', 'canton' => 'LU'),
    '6160' => array('town' => 'Entlebuch', 'canton' => 'LU'),
    '6162' => array('town' => 'Entlebuch', 'canton' => 'LU'),
    '6163' => array('town' => 'Ebnet', 'canton' => 'LU'),
    '6166' => array('town' => 'Hasle LU', 'canton' => 'LU'),
    '6167' => array('town' => 'Bramboden', 'canton' => 'LU'),
    '6170' => array('town' => 'Schüpfheim', 'canton' => 'LU'),
    '6173' => array('town' => 'Flühli LU', 'canton' => 'LU'),
    '6174' => array('town' => 'Sörenberg', 'canton' => 'LU'),
    '6182' => array('town' => 'Escholzmatt', 'canton' => 'LU'),
    '6192' => array('town' => 'Wiggen', 'canton' => 'LU'),
    '6196' => array('town' => 'Marbach LU', 'canton' => 'LU'),
    '6197' => array('town' => 'Schangnau', 'canton' => 'BE'),
    '6203' => array('town' => 'Sempach Station', 'canton' => 'LU'),
    '6204' => array('town' => 'Sempach', 'canton' => 'LU'),
    '6205' => array('town' => 'Eich', 'canton' => 'LU'),
    '6206' => array('town' => 'Neuenkirch', 'canton' => 'LU'),
    '6207' => array('town' => 'Nottwil', 'canton' => 'LU'),
    '6208' => array('town' => 'Oberkirch LU', 'canton' => 'LU'),
    '6210' => array('town' => 'Sursee', 'canton' => 'LU'),
    '6211' => array('town' => 'Buchs LU', 'canton' => 'LU'),
    '6212' => array('town' => 'St. Erhard', 'canton' => 'LU'),
    '6213' => array('town' => 'Knutwil', 'canton' => 'LU'),
    '6214' => array('town' => 'Schenkon', 'canton' => 'LU'),
    '6215' => array('town' => 'Beromünster', 'canton' => 'LU'),
    '6216' => array('town' => 'Mauensee', 'canton' => 'LU'),
    '6217' => array('town' => 'Kottwil', 'canton' => 'LU'),
    '6218' => array('town' => 'Ettiswil', 'canton' => 'LU'),
    '6221' => array('town' => 'Rickenbach LU', 'canton' => 'LU'),
    '6222' => array('town' => 'Gunzwil', 'canton' => 'LU'),
    '6231' => array('town' => 'Schlierbach', 'canton' => 'LU'),
    '6232' => array('town' => 'Geuensee', 'canton' => 'LU'),
    '6233' => array('town' => 'Büron', 'canton' => 'LU'),
    '6234' => array('town' => 'Triengen', 'canton' => 'LU'),
    '6236' => array('town' => 'Wilihof', 'canton' => 'LU'),
    '6235' => array('town' => 'Winikon', 'canton' => 'LU'),
    '6242' => array('town' => 'Wauwil', 'canton' => 'LU'),
    '6243' => array('town' => 'Egolzwil', 'canton' => 'LU'),
    '6244' => array('town' => 'Nebikon', 'canton' => 'LU'),
    '6245' => array('town' => 'Ebersecken', 'canton' => 'LU'),
    '6246' => array('town' => 'Altishofen', 'canton' => 'LU'),
    '6247' => array('town' => 'Schötz', 'canton' => 'LU'),
    '6248' => array('town' => 'Alberswil', 'canton' => 'LU'),
    '6252' => array('town' => 'Dagmersellen', 'canton' => 'LU'),
    '6253' => array('town' => 'Uffikon', 'canton' => 'LU'),
    '6260' => array('town' => 'Reiden', 'canton' => 'LU'),
    '6262' => array('town' => 'Langnau b. Reiden', 'canton' => 'LU'),
    '6263' => array('town' => 'Richenthal', 'canton' => 'LU'),
    '6264' => array('town' => 'Pfaffnau', 'canton' => 'LU'),
    '6265' => array('town' => 'Roggliswil', 'canton' => 'LU'),
    '6274' => array('town' => 'Eschenbach LU', 'canton' => 'LU'),
    '6275' => array('town' => 'Ballwil', 'canton' => 'LU'),
    '6276' => array('town' => 'Hohenrain', 'canton' => 'LU'),
    '6277' => array('town' => 'Kleinwangen', 'canton' => 'LU'),
    '6280' => array('town' => 'Hochdorf', 'canton' => 'LU'),
    '6283' => array('town' => 'Baldegg', 'canton' => 'LU'),
    '6284' => array('town' => 'Gelfingen', 'canton' => 'LU'),
    '6285' => array('town' => 'Hitzkirch', 'canton' => 'LU'),
    '6289' => array('town' => 'Müswangen', 'canton' => 'LU'),
    '6286' => array('town' => 'Altwis', 'canton' => 'LU'),
    '6287' => array('town' => 'Aesch LU', 'canton' => 'LU'),
    '6288' => array('town' => 'Schongau', 'canton' => 'LU'),
    '6294' => array('town' => 'Ermensee', 'canton' => 'LU'),
    '6295' => array('town' => 'Mosen', 'canton' => 'LU'),
    '6300' => array('town' => 'Zug', 'canton' => 'ZG'),
    '6330' => array('town' => 'Cham 2', 'canton' => 'ZG'),
    '6301' => array('town' => 'Zug', 'canton' => 'ZG'),
    '6310' => array('town' => 'Zug', 'canton' => 'ZG'),
    '6313' => array('town' => 'Edlibach', 'canton' => 'ZG'),
    '6319' => array('town' => 'Allenwinden', 'canton' => 'ZG'),
    '6315' => array('town' => 'Morgarten', 'canton' => 'ZG'),
    '6312' => array('town' => 'Steinhausen', 'canton' => 'ZG'),
    '6314' => array('town' => 'Unterägeri', 'canton' => 'ZG'),
    '6317' => array('town' => 'Oberwil b. Zug', 'canton' => 'ZG'),
    '6318' => array('town' => 'Walchwil', 'canton' => 'ZG'),
    '6331' => array('town' => 'Hünenberg', 'canton' => 'ZG'),
    '6332' => array('town' => 'Hagendorn', 'canton' => 'ZG'),
    '6340' => array('town' => 'Baar', 'canton' => 'ZG'),
    '6343' => array('town' => 'Rotkreuz', 'canton' => 'ZG'),
    '6344' => array('town' => 'Meierskappel', 'canton' => 'LU'),
    '6345' => array('town' => 'Neuheim', 'canton' => 'ZG'),
    '6353' => array('town' => 'Weggis', 'canton' => 'LU'),
    '6354' => array('town' => 'Vitznau', 'canton' => 'LU'),
    '6356' => array('town' => 'Rigi Kaltbad', 'canton' => 'LU'),
    '6362' => array('town' => 'Stansstad', 'canton' => 'NW'),
    '6363' => array('town' => 'Obbürgen', 'canton' => 'NW'),
    '6365' => array('town' => 'Kehrsiten', 'canton' => 'NW'),
    '6370' => array('town' => 'Stans', 'canton' => 'NW'),
    '6372' => array('town' => 'Ennetmoos', 'canton' => 'NW'),
    '6373' => array('town' => 'Ennetbürgen', 'canton' => 'NW'),
    '6374' => array('town' => 'Buochs', 'canton' => 'NW'),
    '6375' => array('town' => 'Beckenried', 'canton' => 'NW'),
    '6376' => array('town' => 'Emmetten', 'canton' => 'NW'),
    '6377' => array('town' => 'Seelisberg', 'canton' => 'UR'),
    '6382' => array('town' => 'Büren NW', 'canton' => 'NW'),
    '6383' => array('town' => 'Dallenwil', 'canton' => 'NW'),
    '6386' => array('town' => 'Wolfenschiessen', 'canton' => 'NW'),
    '6387' => array('town' => 'Oberrickenbach', 'canton' => 'NW'),
    '6388' => array('town' => 'Grafenort', 'canton' => 'OW'),
    '6390' => array('town' => 'Engelberg', 'canton' => 'OW'),
    '6402' => array('town' => 'Merlischachen', 'canton' => 'SZ'),
    '6403' => array('town' => 'Küssnacht am Rigi', 'canton' => 'SZ'),
    '6404' => array('town' => 'Greppen', 'canton' => 'LU'),
    '6405' => array('town' => 'Immensee', 'canton' => 'SZ'),
    '6410' => array('town' => 'Goldau', 'canton' => 'SZ'),
    '6414' => array('town' => 'Oberarth', 'canton' => 'SZ'),
    '6415' => array('town' => 'Arth', 'canton' => 'SZ'),
    '6416' => array('town' => 'Steinerberg', 'canton' => 'SZ'),
    '6417' => array('town' => 'Sattel', 'canton' => 'SZ'),
    '6418' => array('town' => 'Rothenthurm', 'canton' => 'SZ'),
    '6422' => array('town' => 'Steinen', 'canton' => 'SZ'),
    '6423' => array('town' => 'Seewen SZ', 'canton' => 'SZ'),
    '6424' => array('town' => 'Lauerz', 'canton' => 'SZ'),
    '6430' => array('town' => 'Schwyz', 'canton' => 'SZ'),
    '6436' => array('town' => 'Ried (Muotathal)', 'canton' => 'SZ'),
    '6432' => array('town' => 'Rickenbach SZ', 'canton' => 'SZ'),
    '6433' => array('town' => 'Stoos SZ', 'canton' => 'SZ'),
    '6434' => array('town' => 'Illgau', 'canton' => 'SZ'),
    '6438' => array('town' => 'Ibach', 'canton' => 'SZ'),
    '6440' => array('town' => 'Brunnen', 'canton' => 'SZ'),
    '6441' => array('town' => 'Rütli', 'canton' => 'UR'),
    '6442' => array('town' => 'Gersau', 'canton' => 'SZ'),
    '6443' => array('town' => 'Morschach', 'canton' => 'SZ'),
    '6452' => array('town' => 'Sisikon', 'canton' => 'UR'),
    '6454' => array('town' => 'Flüelen', 'canton' => 'UR'),
    '6460' => array('town' => 'Altdorf UR', 'canton' => 'UR'),
    '6461' => array('town' => 'Isenthal', 'canton' => 'UR'),
    '6462' => array('town' => 'Seedorf UR', 'canton' => 'UR'),
    '6463' => array('town' => 'Bürglen UR', 'canton' => 'UR'),
    '6464' => array('town' => 'Spiringen', 'canton' => 'UR'),
    '6465' => array('town' => 'Unterschächen', 'canton' => 'UR'),
    '6466' => array('town' => 'Bauen', 'canton' => 'UR'),
    '6467' => array('town' => 'Schattdorf', 'canton' => 'UR'),
    '6469' => array('town' => 'Haldi b.Schattdorf', 'canton' => 'UR'),
    '6468' => array('town' => 'Attinghausen', 'canton' => 'UR'),
    '6472' => array('town' => 'Erstfeld', 'canton' => 'UR'),
    '6473' => array('town' => 'Silenen', 'canton' => 'UR'),
    '6474' => array('town' => 'Amsteg', 'canton' => 'UR'),
    '6475' => array('town' => 'Bristen', 'canton' => 'UR'),
    '6476' => array('town' => 'Intschi', 'canton' => 'UR'),
    '6482' => array('town' => 'Gurtnellen', 'canton' => 'UR'),
    '6484' => array('town' => 'Wassen UR', 'canton' => 'UR'),
    '6485' => array('town' => 'Meien', 'canton' => 'UR'),
    '6487' => array('town' => 'Göschenen', 'canton' => 'UR'),
    '6490' => array('town' => 'Andermatt', 'canton' => 'UR'),
    '6491' => array('town' => 'Realp', 'canton' => 'UR'),
    '6493' => array('town' => 'Hospental', 'canton' => 'UR'),
    '6500' => array('town' => 'Bellinzona', 'canton' => 'TI'),
    '6501' => array('town' => 'Bellinzona', 'canton' => 'TI'),
    '6503' => array('town' => 'Bellinzona', 'canton' => 'TI'),
    '6506' => array('town' => 'Bellinzona 6 Autop', 'canton' => 'TI'),
    '6512' => array('town' => 'Giubiasco', 'canton' => 'TI'),
    '6513' => array('town' => 'Monte Carasso', 'canton' => 'TI'),
    '6514' => array('town' => 'Sementina', 'canton' => 'TI'),
    '6515' => array('town' => 'Gudo', 'canton' => 'TI'),
    '6516' => array('town' => 'Cugnasco', 'canton' => 'TI'),
    '6517' => array('town' => 'Arbedo', 'canton' => 'TI'),
    '6518' => array('town' => 'Gorduno', 'canton' => 'TI'),
    '6525' => array('town' => 'Gnosca', 'canton' => 'TI'),
    '6526' => array('town' => 'Prosito', 'canton' => 'TI'),
    '6527' => array('town' => 'Lodrino', 'canton' => 'TI'),
    '6528' => array('town' => 'Camorino', 'canton' => 'TI'),
    '6532' => array('town' => 'Castione', 'canton' => 'TI'),
    '6533' => array('town' => 'Lumino', 'canton' => 'TI'),
    '6534' => array('town' => 'S. Vittore', 'canton' => 'GR'),
    '6535' => array('town' => 'Roveredo GR', 'canton' => 'GR'),
    '6537' => array('town' => 'Grono', 'canton' => 'GR'),
    '6523' => array('town' => 'Preonzo', 'canton' => 'TI'),
    '6524' => array('town' => 'Moleno', 'canton' => 'TI'),
    '6582' => array('town' => 'Pianezzo', 'canton' => 'TI'),
    '6583' => array('town' => 'S. Antonio', 'canton' => 'TI'),
    '6584' => array('town' => 'Carena', 'canton' => 'TI'),
    '6549' => array('town' => 'Laura', 'canton' => 'GR'),
    '6540' => array('town' => 'Castaneda', 'canton' => 'GR'),
    '6541' => array('town' => 'Sta. Maria', 'canton' => 'GR'),
    '6538' => array('town' => 'Verdabbio', 'canton' => 'GR'),
    '6542' => array('town' => 'Buseno', 'canton' => 'GR'),
    '6543' => array('town' => 'Arvigo', 'canton' => 'GR'),
    '6544' => array('town' => 'Braggio', 'canton' => 'GR'),
    '6545' => array('town' => 'Selma', 'canton' => 'GR'),
    '6546' => array('town' => 'Cauco', 'canton' => 'GR'),
    '6547' => array('town' => 'Augio', 'canton' => 'GR'),
    '6548' => array('town' => 'Rossa', 'canton' => 'GR'),
    '6556' => array('town' => 'Leggia', 'canton' => 'GR'),
    '6565' => array('town' => 'S. Bernardino', 'canton' => 'GR'),
    '6557' => array('town' => 'Cama', 'canton' => 'GR'),
    '6558' => array('town' => 'Lostallo', 'canton' => 'GR'),
    '6562' => array('town' => 'Soazza', 'canton' => 'GR'),
    '6563' => array('town' => 'Mesocco', 'canton' => 'GR'),
    '6572' => array('town' => 'Quartino', 'canton' => 'TI'),
    '6573' => array('town' => 'Magadino', 'canton' => 'TI'),
    '6574' => array('town' => 'Vira (Gambarogno)', 'canton' => 'TI'),
    '6575' => array('town' => 'S. Nazzaro', 'canton' => 'TI'),
    '6576' => array('town' => 'Gerra (Gambarogno)', 'canton' => 'TI'),
    '6577' => array('town' => 'Ranzo', 'canton' => 'TI'),
    '6578' => array('town' => 'Caviano', 'canton' => 'TI'),
    '6579' => array('town' => 'Piazzogna', 'canton' => 'TI'),
    '6571' => array('town' => 'Indemini', 'canton' => 'TI'),
    '6592' => array('town' => 'S. Antonino', 'canton' => 'TI'),
    '6593' => array('town' => 'Cadenazzo', 'canton' => 'TI'),
    '6594' => array('town' => 'Contone', 'canton' => 'TI'),
    '6595' => array('town' => 'Riazzino', 'canton' => 'TI'),
    '6596' => array('town' => 'Gordola', 'canton' => 'TI'),
    '6597' => array('town' => 'Agarone', 'canton' => 'TI'),
    '6598' => array('town' => 'Tenero', 'canton' => 'TI'),
    '6599' => array('town' => 'Robasacco', 'canton' => 'TI'),
    '6600' => array('town' => 'Locarno', 'canton' => 'TI'),
    '6601' => array('town' => 'Locarno', 'canton' => 'TI'),
    '6604' => array('town' => 'Locarno', 'canton' => 'TI'),
    '6605' => array('town' => 'Locarno', 'canton' => 'TI'),
    '6656' => array('town' => 'Golino', 'canton' => 'TI'),
    '6618' => array('town' => 'Arcegno', 'canton' => 'TI'),
    '6646' => array('town' => 'Contra', 'canton' => 'TI'),
    '6647' => array('town' => 'Mergoscia', 'canton' => 'TI'),
    '6661' => array('town' => 'Auressio', 'canton' => 'TI'),
    '6611' => array('town' => 'Mosogno', 'canton' => 'TI'),
    '6662' => array('town' => 'Russo', 'canton' => 'TI'),
    '6664' => array('town' => 'Vergeletto', 'canton' => 'TI'),
    '6663' => array('town' => 'Comologno', 'canton' => 'TI'),
    '6632' => array('town' => 'Vogorno', 'canton' => 'TI'),
    '6631' => array('town' => 'Corippo', 'canton' => 'TI'),
    '6633' => array('town' => 'Lavertezzo', 'canton' => 'TI'),
    '6634' => array('town' => 'Brione (Verzasca)', 'canton' => 'TI'),
    '6635' => array('town' => 'Gerra (Verzasca)', 'canton' => 'TI'),
    '6636' => array('town' => 'Frasco', 'canton' => 'TI'),
    '6637' => array('town' => 'Sonogno', 'canton' => 'TI'),
    '6612' => array('town' => 'Ascona', 'canton' => 'TI'),
    '6613' => array('town' => 'Porto Ronco', 'canton' => 'TI'),
    '6614' => array('town' => 'Brissago', 'canton' => 'TI'),
    '6616' => array('town' => 'Losone', 'canton' => 'TI'),
    '6622' => array('town' => 'Ronco sopra Ascona', 'canton' => 'TI'),
    '6644' => array('town' => 'Orselina', 'canton' => 'TI'),
    '6645' => array('town' => 'Brione s. Minusio', 'canton' => 'TI'),
    '6648' => array('town' => 'Minusio', 'canton' => 'TI'),
    '6655' => array('town' => 'Verdasio', 'canton' => 'TI'),
    '6657' => array('town' => 'Palagnedra', 'canton' => 'TI'),
    '6658' => array('town' => 'Borgnone', 'canton' => 'TI'),
    '6659' => array('town' => 'Camedo', 'canton' => 'TI'),
    '6652' => array('town' => 'Tegna', 'canton' => 'TI'),
    '6653' => array('town' => 'Verscio', 'canton' => 'TI'),
    '6654' => array('town' => 'Cavigliano', 'canton' => 'TI'),
    '6670' => array('town' => 'Avegno', 'canton' => 'TI'),
    '6677' => array('town' => 'Moghegno', 'canton' => 'TI'),
    '6678' => array('town' => 'Coglio', 'canton' => 'TI'),
    '6674' => array('town' => 'Riveo', 'canton' => 'TI'),
    '6682' => array('town' => 'Linescio', 'canton' => 'TI'),
    '6683' => array('town' => 'Cerentino', 'canton' => 'TI'),
    '6685' => array('town' => 'Bosco/Gurin', 'canton' => 'TI'),
    '6684' => array('town' => 'Campo (VM)', 'canton' => 'TI'),
    '6690' => array('town' => 'Cavergno', 'canton' => 'TI'),
    '6692' => array('town' => 'Brontallo', 'canton' => 'TI'),
    '6693' => array('town' => 'Broglio', 'canton' => 'TI'),
    '6694' => array('town' => 'Prato-Sornico', 'canton' => 'TI'),
    '6695' => array('town' => 'Peccia', 'canton' => 'TI'),
    '6696' => array('town' => 'Fusio', 'canton' => 'TI'),
    '6672' => array('town' => 'Gordevio', 'canton' => 'TI'),
    '6673' => array('town' => 'Maggia', 'canton' => 'TI'),
    '6675' => array('town' => 'Cevio', 'canton' => 'TI'),
    '6676' => array('town' => 'Bignasco', 'canton' => 'TI'),
    '6702' => array('town' => 'Claro', 'canton' => 'TI'),
    '6703' => array('town' => 'Osogna', 'canton' => 'TI'),
    '6705' => array('town' => 'Cresciano', 'canton' => 'TI'),
    '6707' => array('town' => 'Iragna', 'canton' => 'TI'),
    '6710' => array('town' => 'Biasca', 'canton' => 'TI'),
    '6721' => array('town' => 'Ludiano', 'canton' => 'TI'),
    '6722' => array('town' => 'Corzoneso', 'canton' => 'TI'),
    '6716' => array('town' => 'Leontica', 'canton' => 'TI'),
    '6723' => array('town' => 'Prugiasco', 'canton' => 'TI'),
    '6724' => array('town' => 'Ponto Valentino', 'canton' => 'TI'),
    '6719' => array('town' => 'Aquila', 'canton' => 'TI'),
    '6720' => array('town' => 'Campo (Blenio)', 'canton' => 'TI'),
    '6713' => array('town' => 'Malvaglia', 'canton' => 'TI'),
    '6714' => array('town' => 'Semione', 'canton' => 'TI'),
    '6715' => array('town' => 'Dongio', 'canton' => 'TI'),
    '6717' => array('town' => 'Dangio-Torre', 'canton' => 'TI'),
    '6718' => array('town' => 'Olivone', 'canton' => 'TI'),
    '6742' => array('town' => 'Pollegio', 'canton' => 'TI'),
    '6743' => array('town' => 'Bodio TI', 'canton' => 'TI'),
    '6745' => array('town' => 'Giornico', 'canton' => 'TI'),
    '6746' => array('town' => 'Lavorgo', 'canton' => 'TI'),
    '6747' => array('town' => 'Chironico', 'canton' => 'TI'),
    '6760' => array('town' => 'Faido', 'canton' => 'TI'),
    '6772' => array('town' => 'Rodi-Fiesso', 'canton' => 'TI'),
    '6775' => array('town' => 'Ambrì', 'canton' => 'TI'),
    '6776' => array('town' => 'Piotta', 'canton' => 'TI'),
    '6777' => array('town' => 'Quinto', 'canton' => 'TI'),
    '6780' => array('town' => 'Airolo', 'canton' => 'TI'),
    '6781' => array('town' => 'Villa Bedretto', 'canton' => 'TI'),
    '6744' => array('town' => 'Personico', 'canton' => 'TI'),
    '6748' => array('town' => 'Anzonico', 'canton' => 'TI'),
    '6749' => array('town' => 'Sobrio', 'canton' => 'TI'),
    '6763' => array('town' => 'Mairengo', 'canton' => 'TI'),
    '6764' => array('town' => 'Chiggiogna', 'canton' => 'TI'),
    '6773' => array('town' => 'Prato (Leventina)', 'canton' => 'TI'),
    '6774' => array('town' => 'Dalpe', 'canton' => 'TI'),
    '6802' => array('town' => 'Rivera', 'canton' => 'TI'),
    '6804' => array('town' => 'Bironico', 'canton' => 'TI'),
    '6803' => array('town' => 'Camignolo', 'canton' => 'TI'),
    '6807' => array('town' => 'Taverne', 'canton' => 'TI'),
    '6808' => array('town' => 'Torricella', 'canton' => 'TI'),
    '6814' => array('town' => 'Lamone-Cadempino', 'canton' => 'TI'),
    '6815' => array('town' => 'Melide', 'canton' => 'TI'),
    '6816' => array('town' => 'Bissone', 'canton' => 'TI'),
    '6817' => array('town' => 'Maroggia', 'canton' => 'TI'),
    '6818' => array('town' => 'Melano', 'canton' => 'TI'),
    '6822' => array('town' => 'Arogno', 'canton' => 'TI'),
    '6825' => array('town' => 'Capolago', 'canton' => 'TI'),
    '6826' => array('town' => 'Riva San Vitale', 'canton' => 'TI'),
    '6828' => array('town' => 'Balerna', 'canton' => 'TI'),
    '6830' => array('town' => 'Chiasso', 'canton' => 'TI'),
    '6839' => array('town' => 'Sagno', 'canton' => 'TI'),
    '6837' => array('town' => 'Caneggio', 'canton' => 'TI'),
    '6838' => array('town' => 'Cabbio', 'canton' => 'TI'),
    '6832' => array('town' => 'Pedrinate', 'canton' => 'TI'),
    '6833' => array('town' => 'Vacallo', 'canton' => 'TI'),
    '6834' => array('town' => 'Morbio Inferiore', 'canton' => 'TI'),
    '6836' => array('town' => 'Serfontana', 'canton' => 'TI'),
    '6835' => array('town' => 'Morbio Superiore', 'canton' => 'TI'),
    '6809' => array('town' => 'Medeglia', 'canton' => 'TI'),
    '6810' => array('town' => 'Isone', 'canton' => 'TI'),
    '6805' => array('town' => 'Mezzovico', 'canton' => 'TI'),
    '6806' => array('town' => 'Sigirino', 'canton' => 'TI'),
    '6821' => array('town' => 'Rovio', 'canton' => 'TI'),
    '6823' => array('town' => 'Pugerna', 'canton' => 'TI'),
    '6850' => array('town' => 'Mendrisio', 'canton' => 'TI'),
    '6875' => array('town' => 'Monte', 'canton' => 'TI'),
    '6873' => array('town' => 'Corteglia', 'canton' => 'TI'),
    '6852' => array('town' => 'Genestrerio', 'canton' => 'TI'),
    '6853' => array('town' => 'Ligornetto', 'canton' => 'TI'),
    '6854' => array('town' => 'S. Pietro', 'canton' => 'TI'),
    '6855' => array('town' => 'Stabio', 'canton' => 'TI'),
    '6862' => array('town' => 'Rancate', 'canton' => 'TI'),
    '6863' => array('town' => 'Besazio', 'canton' => 'TI'),
    '6864' => array('town' => 'Arzo', 'canton' => 'TI'),
    '6865' => array('town' => 'Tremona', 'canton' => 'TI'),
    '6866' => array('town' => 'Meride', 'canton' => 'TI'),
    '6867' => array('town' => 'Serpiano', 'canton' => 'TI'),
    '6872' => array('town' => 'Salorino', 'canton' => 'TI'),
    '6874' => array('town' => 'Castel San Pietro', 'canton' => 'TI'),
    '6877' => array('town' => 'Coldrerio', 'canton' => 'TI'),
    '6883' => array('town' => 'Novazzano', 'canton' => 'TI'),
    '6900' => array('town' => 'Lugano', 'canton' => 'TI'),
    '6901' => array('town' => 'Lugano', 'canton' => 'TI'),
    '6902' => array('town' => 'Lugano 2 Caselle', 'canton' => 'TI'),
    '6903' => array('town' => 'Lugano', 'canton' => 'TI'),
    '6904' => array('town' => 'Lugano 4 Caselle', 'canton' => 'TI'),
    '6905' => array('town' => 'Lugano 5 Autoposta', 'canton' => 'TI'),
    '6906' => array('town' => 'Lugano 6 Caselle', 'canton' => 'TI'),
    '6913' => array('town' => 'Carabbia', 'canton' => 'TI'),
    '6915' => array('town' => 'Pambio-Noranco', 'canton' => 'TI'),
    '6916' => array('town' => 'Grancia', 'canton' => 'TI'),
    '6917' => array('town' => 'Barbengo', 'canton' => 'TI'),
    '6919' => array('town' => 'Carabietta', 'canton' => 'TI'),
    '6921' => array('town' => 'Vico Morcote', 'canton' => 'TI'),
    '6928' => array('town' => 'Manno', 'canton' => 'TI'),
    '6929' => array('town' => 'Gravesano', 'canton' => 'TI'),
    '6930' => array('town' => 'Bedano', 'canton' => 'TI'),
    '6939' => array('town' => 'Arosio', 'canton' => 'TI'),
    '6938' => array('town' => 'Vezio', 'canton' => 'TI'),
    '6937' => array('town' => 'Breno', 'canton' => 'TI'),
    '6949' => array('town' => 'Comano', 'canton' => 'TI'),
    '6979' => array('town' => 'Brè sopra Lugano', 'canton' => 'TI'),
    '6827' => array('town' => 'Brusino Arsizio', 'canton' => 'TI'),
    '6912' => array('town' => 'Pazzallo', 'canton' => 'TI'),
    '6914' => array('town' => 'Carona', 'canton' => 'TI'),
    '6918' => array('town' => 'Figino', 'canton' => 'TI'),
    '6922' => array('town' => 'Morcote', 'canton' => 'TI'),
    '6924' => array('town' => 'Sorengo', 'canton' => 'TI'),
    '6925' => array('town' => 'Gentilino', 'canton' => 'TI'),
    '6926' => array('town' => 'Montagnola', 'canton' => 'TI'),
    '6927' => array('town' => 'Agra', 'canton' => 'TI'),
    '6932' => array('town' => 'Breganzona', 'canton' => 'TI'),
    '6933' => array('town' => 'Muzzano', 'canton' => 'TI'),
    '6934' => array('town' => 'Bioggio', 'canton' => 'TI'),
    '6935' => array('town' => 'Bosco Luganese', 'canton' => 'TI'),
    '6936' => array('town' => 'Cademario', 'canton' => 'TI'),
    '6942' => array('town' => 'Savosa', 'canton' => 'TI'),
    '6943' => array('town' => 'Vezia', 'canton' => 'TI'),
    '6948' => array('town' => 'Porza', 'canton' => 'TI'),
    '6950' => array('town' => 'Tesserete', 'canton' => 'TI'),
    '6944' => array('town' => 'Cureglia', 'canton' => 'TI'),
    '6945' => array('town' => 'Origlio', 'canton' => 'TI'),
    '6946' => array('town' => 'Ponte Capriasca', 'canton' => 'TI'),
    '6947' => array('town' => 'Vaglio', 'canton' => 'TI'),
    '6954' => array('town' => 'Sala Capriasca', 'canton' => 'TI'),
    '6953' => array('town' => 'Lugaggia', 'canton' => 'TI'),
    '6951' => array('town' => 'Insone', 'canton' => 'TI'),
    '6956' => array('town' => 'Lopagno', 'canton' => 'TI'),
    '6957' => array('town' => 'Roveredo TI', 'canton' => 'TI'),
    '6958' => array('town' => 'Bidogno', 'canton' => 'TI'),
    '6955' => array('town' => 'Cagiallo', 'canton' => 'TI'),
    '6959' => array('town' => 'Cimadera', 'canton' => 'TI'),
    '6952' => array('town' => 'Canobbio', 'canton' => 'TI'),
    '6962' => array('town' => 'Viganello', 'canton' => 'TI'),
    '6963' => array('town' => 'Pregassona', 'canton' => 'TI'),
    '6964' => array('town' => 'Davesco-Soragno', 'canton' => 'TI'),
    '6965' => array('town' => 'Cadro', 'canton' => 'TI'),
    '6966' => array('town' => 'Villa Luganese', 'canton' => 'TI'),
    '6967' => array('town' => 'Dino', 'canton' => 'TI'),
    '6968' => array('town' => 'Sonvico', 'canton' => 'TI'),
    '6974' => array('town' => 'Aldesago', 'canton' => 'TI'),
    '6976' => array('town' => 'Castagnola', 'canton' => 'TI'),
    '6977' => array('town' => 'Ruvigliana', 'canton' => 'TI'),
    '6978' => array('town' => 'Gandria', 'canton' => 'TI'),
    '6990' => array('town' => 'Cassina d\'Agno', 'canton' => 'TI'),
    '6991' => array('town' => 'Neggio', 'canton' => 'TI'),
    '6992' => array('town' => 'Vernate', 'canton' => 'TI'),
    '6993' => array('town' => 'Iseo', 'canton' => 'TI'),
    '6994' => array('town' => 'Aranno', 'canton' => 'TI'),
    '6981' => array('town' => 'Bedigliora', 'canton' => 'TI'),
    '6980' => array('town' => 'Castelrotto', 'canton' => 'TI'),
    '6999' => array('town' => 'Astano', 'canton' => 'TI'),
    '6986' => array('town' => 'Miglieglia', 'canton' => 'TI'),
    '6989' => array('town' => 'Purasca', 'canton' => 'TI'),
    '6995' => array('town' => 'Molinazzo', 'canton' => 'TI'),
    '6996' => array('town' => 'Ponte Cremenaga', 'canton' => 'TI'),
    '6997' => array('town' => 'Sessa', 'canton' => 'TI'),
    '6998' => array('town' => 'Termine', 'canton' => 'TI'),
    '6982' => array('town' => 'Agno', 'canton' => 'TI'),
    '6983' => array('town' => 'Magliaso', 'canton' => 'TI'),
    '6984' => array('town' => 'Pura', 'canton' => 'TI'),
    '6987' => array('town' => 'Caslano', 'canton' => 'TI'),
    '6988' => array('town' => 'Ponte Tresa', 'canton' => 'TI'),
    '7000' => array('town' => 'Chur', 'canton' => 'GR'),
    '7001' => array('town' => 'Chur', 'canton' => 'GR'),
    '7002' => array('town' => 'Chur', 'canton' => 'GR'),
    '7004' => array('town' => 'Chur', 'canton' => 'GR'),
    '7006' => array('town' => 'Chur', 'canton' => 'GR'),
    '7007' => array('town' => 'Chur', 'canton' => 'GR'),
    '7012' => array('town' => 'Felsberg', 'canton' => 'GR'),
    '7013' => array('town' => 'Domat/Ems', 'canton' => 'GR'),
    '7015' => array('town' => 'Tamins', 'canton' => 'GR'),
    '7017' => array('town' => 'Flims Dorf', 'canton' => 'GR'),
    '7018' => array('town' => 'Flims Waldhaus', 'canton' => 'GR'),
    '7023' => array('town' => 'Haldenstein', 'canton' => 'GR'),
    '7026' => array('town' => 'Maladers', 'canton' => 'GR'),
    '7031' => array('town' => 'Laax GR', 'canton' => 'GR'),
    '7032' => array('town' => 'Laax GR 2', 'canton' => 'GR'),
    '7050' => array('town' => 'Arosa', 'canton' => 'GR'),
    '7062' => array('town' => 'Passugg-Araschgen', 'canton' => 'GR'),
    '7063' => array('town' => 'Praden', 'canton' => 'GR'),
    '7064' => array('town' => 'Tschiertschen', 'canton' => 'GR'),
    '7074' => array('town' => 'Malix', 'canton' => 'GR'),
    '7075' => array('town' => 'Churwalden', 'canton' => 'GR'),
    '7076' => array('town' => 'Parpan', 'canton' => 'GR'),
    '7077' => array('town' => 'Valbella', 'canton' => 'GR'),
    '7078' => array('town' => 'Lenzerheide/Lai', 'canton' => 'GR'),
    '7082' => array('town' => 'Vaz/Obervaz', 'canton' => 'GR'),
    '7083' => array('town' => 'Lantsch/Lenz', 'canton' => 'GR'),
    '7084' => array('town' => 'Brienz/Brinzauls', 'canton' => 'GR'),
    '7014' => array('town' => 'Trin', 'canton' => 'GR'),
    '7016' => array('town' => 'Trin Mulin', 'canton' => 'GR'),
    '7019' => array('town' => 'Fidaz', 'canton' => 'GR'),
    '7027' => array('town' => 'Lüen', 'canton' => 'GR'),
    '7028' => array('town' => 'St. Peter', 'canton' => 'GR'),
    '7056' => array('town' => 'Molinis', 'canton' => 'GR'),
    '7029' => array('town' => 'Peist', 'canton' => 'GR'),
    '7057' => array('town' => 'Langwies', 'canton' => 'GR'),
    '7058' => array('town' => 'Litzirüti', 'canton' => 'GR'),
    '7104' => array('town' => 'Versam', 'canton' => 'GR'),
    '7106' => array('town' => 'Tenna', 'canton' => 'GR'),
    '7107' => array('town' => 'Safien Platz', 'canton' => 'GR'),
    '7109' => array('town' => 'Thalkirch', 'canton' => 'GR'),
    '7122' => array('town' => 'Valendas', 'canton' => 'GR'),
    '7126' => array('town' => 'Castrisch', 'canton' => 'GR'),
    '7130' => array('town' => 'Ilanz', 'canton' => 'GR'),
    '7154' => array('town' => 'Ruschein', 'canton' => 'GR'),
    '7155' => array('town' => 'Ladir', 'canton' => 'GR'),
    '7151' => array('town' => 'Schluein', 'canton' => 'GR'),
    '7153' => array('town' => 'Falera', 'canton' => 'GR'),
    '7152' => array('town' => 'Sagogn', 'canton' => 'GR'),
    '7127' => array('town' => 'Sevgein', 'canton' => 'GR'),
    '7128' => array('town' => 'Riein', 'canton' => 'GR'),
    '7111' => array('town' => 'Pitasch', 'canton' => 'GR'),
    '7112' => array('town' => 'Duvin', 'canton' => 'GR'),
    '7113' => array('town' => 'Camuns', 'canton' => 'GR'),
    '7114' => array('town' => 'Uors (Lumnezia)', 'canton' => 'GR'),
    '7115' => array('town' => 'Surcasti', 'canton' => 'GR'),
    '7116' => array('town' => 'Tersnaus', 'canton' => 'GR'),
    '7141' => array('town' => 'Luven', 'canton' => 'GR'),
    '7142' => array('town' => 'Cumbel', 'canton' => 'GR'),
    '7143' => array('town' => 'Morissen', 'canton' => 'GR'),
    '7144' => array('town' => 'Vella', 'canton' => 'GR'),
    '7145' => array('town' => 'Degen', 'canton' => 'GR'),
    '7146' => array('town' => 'Vattiz', 'canton' => 'GR'),
    '7147' => array('town' => 'Vignogn', 'canton' => 'GR'),
    '7148' => array('town' => 'Lumbrein', 'canton' => 'GR'),
    '7149' => array('town' => 'Vrin', 'canton' => 'GR'),
    '7137' => array('town' => 'Flond', 'canton' => 'GR'),
    '7138' => array('town' => 'Surcuolm', 'canton' => 'GR'),
    '7132' => array('town' => 'Vals', 'canton' => 'GR'),
    '7133' => array('town' => 'Obersaxen Affeier', 'canton' => 'GR'),
    '7134' => array('town' => 'Obersaxen Meierhof', 'canton' => 'GR'),
    '7135' => array('town' => 'Obersaxen Giraniga', 'canton' => 'GR'),
    '7136' => array('town' => 'Obers Friggahüs', 'canton' => 'GR'),
    '7156' => array('town' => 'Pigniu', 'canton' => 'GR'),
    '7157' => array('town' => 'Siat', 'canton' => 'GR'),
    '7158' => array('town' => 'Waltensburg/Vuorz', 'canton' => 'GR'),
    '7159' => array('town' => 'Andiast', 'canton' => 'GR'),
    '7162' => array('town' => 'Tavanasa', 'canton' => 'GR'),
    '7163' => array('town' => 'Danis', 'canton' => 'GR'),
    '7164' => array('town' => 'Dardin', 'canton' => 'GR'),
    '7165' => array('town' => 'Breil/Brigels', 'canton' => 'GR'),
    '7166' => array('town' => 'Trun', 'canton' => 'GR'),
    '7168' => array('town' => 'Schlans', 'canton' => 'GR'),
    '7167' => array('town' => 'Zignau', 'canton' => 'GR'),
    '7172' => array('town' => 'Rabius', 'canton' => 'GR'),
    '7175' => array('town' => 'Sumvitg', 'canton' => 'GR'),
    '7174' => array('town' => 'S. Benedetg', 'canton' => 'GR'),
    '7180' => array('town' => 'Disentis/Mustér', 'canton' => 'GR'),
    '7182' => array('town' => 'Cavardiras', 'canton' => 'GR'),
    '7183' => array('town' => 'Mompé Medel', 'canton' => 'GR'),
    '7184' => array('town' => 'Curaglia', 'canton' => 'GR'),
    '7185' => array('town' => 'Platta', 'canton' => 'GR'),
    '7186' => array('town' => 'Segnas', 'canton' => 'GR'),
    '7187' => array('town' => 'Camischolas', 'canton' => 'GR'),
    '7189' => array('town' => 'Rueras', 'canton' => 'GR'),
    '7188' => array('town' => 'Sedrun', 'canton' => 'GR'),
    '7173' => array('town' => 'Surrein', 'canton' => 'GR'),
    '7176' => array('town' => 'Cumpadials', 'canton' => 'GR'),
    '7201' => array('town' => 'Untervaz Bahnhof', 'canton' => 'GR'),
    '7203' => array('town' => 'Trimmis', 'canton' => 'GR'),
    '7202' => array('town' => 'Says', 'canton' => 'GR'),
    '7204' => array('town' => 'Untervaz', 'canton' => 'GR'),
    '7205' => array('town' => 'Zizers', 'canton' => 'GR'),
    '7206' => array('town' => 'Igis', 'canton' => 'GR'),
    '7208' => array('town' => 'Malans GR', 'canton' => 'GR'),
    '7212' => array('town' => 'Seewis Dorf', 'canton' => 'GR'),
    '7213' => array('town' => 'Valzeina', 'canton' => 'GR'),
    '7214' => array('town' => 'Grüsch', 'canton' => 'GR'),
    '7215' => array('town' => 'Fanas', 'canton' => 'GR'),
    '7220' => array('town' => 'Schiers', 'canton' => 'GR'),
    '7228' => array('town' => 'Schuders', 'canton' => 'GR'),
    '7226' => array('town' => 'Stels', 'canton' => 'GR'),
    '7222' => array('town' => 'Mittellunden', 'canton' => 'GR'),
    '7223' => array('town' => 'Buchen', 'canton' => 'GR'),
    '7224' => array('town' => 'Putz', 'canton' => 'GR'),
    '7231' => array('town' => 'Pragg-Jenaz', 'canton' => 'GR'),
    '7232' => array('town' => 'Furna', 'canton' => 'GR'),
    '7233' => array('town' => 'Jenaz', 'canton' => 'GR'),
    '7235' => array('town' => 'Fideris', 'canton' => 'GR'),
    '7240' => array('town' => 'Küblis', 'canton' => 'GR'),
    '7242' => array('town' => 'Luzein', 'canton' => 'GR'),
    '7243' => array('town' => 'Pany', 'canton' => 'GR'),
    '7244' => array('town' => 'Gadenstätt', 'canton' => 'GR'),
    '7245' => array('town' => 'Ascharina', 'canton' => 'GR'),
    '7246' => array('town' => 'St. Antönien', 'canton' => 'GR'),
    '7241' => array('town' => 'Conters', 'canton' => 'GR'),
    '7247' => array('town' => 'Saas im Prättigau', 'canton' => 'GR'),
    '7249' => array('town' => 'Serneus', 'canton' => 'GR'),
    '7250' => array('town' => 'Klosters', 'canton' => 'GR'),
    '7252' => array('town' => 'Klosters Dorf', 'canton' => 'GR'),
    '7260' => array('town' => 'Davos Dorf', 'canton' => 'GR'),
    '7265' => array('town' => 'Davos Wolfgang', 'canton' => 'GR'),
    '7270' => array('town' => 'Davos Platz', 'canton' => 'GR'),
    '7272' => array('town' => 'Davos Clavadel', 'canton' => 'GR'),
    '7276' => array('town' => 'Davos Frauenkirch', 'canton' => 'GR'),
    '7277' => array('town' => 'Davos Glaris', 'canton' => 'GR'),
    '7278' => array('town' => 'Davos Monstein', 'canton' => 'GR'),
    '7302' => array('town' => 'Landquart', 'canton' => 'GR'),
    '7303' => array('town' => 'Mastrils', 'canton' => 'GR'),
    '7304' => array('town' => 'Maienfeld', 'canton' => 'GR'),
    '7306' => array('town' => 'Fläsch', 'canton' => 'GR'),
    '7307' => array('town' => 'Jenins', 'canton' => 'GR'),
    '7310' => array('town' => 'Bad Ragaz', 'canton' => 'SG'),
    '7317' => array('town' => 'Valens', 'canton' => 'SG'),
    '7314' => array('town' => 'Vadura', 'canton' => 'SG'),
    '7315' => array('town' => 'Vättis', 'canton' => 'SG'),
    '7312' => array('town' => 'Pfäfers', 'canton' => 'SG'),
    '7313' => array('town' => 'St. Margrethenberg', 'canton' => 'SG'),
    '7320' => array('town' => 'Sargans', 'canton' => 'SG'),
    '7325' => array('town' => 'Schwendi', 'canton' => 'SG'),
    '7326' => array('town' => 'Weisstannen', 'canton' => 'SG'),
    '7323' => array('town' => 'Wangs', 'canton' => 'SG'),
    '7324' => array('town' => 'Vilters', 'canton' => 'SG'),
    '7402' => array('town' => 'Bonaduz', 'canton' => 'GR'),
    '7403' => array('town' => 'Rhäzüns', 'canton' => 'GR'),
    '7404' => array('town' => 'Feldis/Veulden', 'canton' => 'GR'),
    '7405' => array('town' => 'Rothenbrunnen', 'canton' => 'GR'),
    '7408' => array('town' => 'Cazis', 'canton' => 'GR'),
    '7411' => array('town' => 'Sils im Domleschg', 'canton' => 'GR'),
    '7412' => array('town' => 'Scharans', 'canton' => 'GR'),
    '7413' => array('town' => 'Fürstenaubruck', 'canton' => 'GR'),
    '7414' => array('town' => 'Fürstenau', 'canton' => 'GR'),
    '7415' => array('town' => 'Rodels', 'canton' => 'GR'),
    '7416' => array('town' => 'Almens', 'canton' => 'GR'),
    '7417' => array('town' => 'Paspels', 'canton' => 'GR'),
    '7407' => array('town' => 'Trans', 'canton' => 'GR'),
    '7418' => array('town' => 'Tumegl/Tomils', 'canton' => 'GR'),
    '7419' => array('town' => 'Scheid', 'canton' => 'GR'),
    '7430' => array('town' => 'Thusis', 'canton' => 'GR'),
    '7425' => array('town' => 'Masein', 'canton' => 'GR'),
    '7426' => array('town' => 'Flerden', 'canton' => 'GR'),
    '7427' => array('town' => 'Urmein', 'canton' => 'GR'),
    '7428' => array('town' => 'Tschappina', 'canton' => 'GR'),
    '7421' => array('town' => 'Summaprada', 'canton' => 'GR'),
    '7422' => array('town' => 'Tartar', 'canton' => 'GR'),
    '7423' => array('town' => 'Sarn', 'canton' => 'GR'),
    '7424' => array('town' => 'Präz', 'canton' => 'GR'),
    '7431' => array('town' => 'Mutten', 'canton' => 'GR'),
    '7432' => array('town' => 'Zillis', 'canton' => 'GR'),
    '7433' => array('town' => 'Donat', 'canton' => 'GR'),
    '7434' => array('town' => 'Sufers', 'canton' => 'GR'),
    '7435' => array('town' => 'Splügen', 'canton' => 'GR'),
    '7436' => array('town' => 'Medels', 'canton' => 'GR'),
    '7437' => array('town' => 'Nufenen', 'canton' => 'GR'),
    '7438' => array('town' => 'Hinterrhein', 'canton' => 'GR'),
    '7440' => array('town' => 'Andeer', 'canton' => 'GR'),
    '7442' => array('town' => 'Clugin', 'canton' => 'GR'),
    '7443' => array('town' => 'Pignia', 'canton' => 'GR'),
    '7444' => array('town' => 'Ausserferrera', 'canton' => 'GR'),
    '7445' => array('town' => 'Innerferrera', 'canton' => 'GR'),
    '7446' => array('town' => 'Campsut-Cröt', 'canton' => 'GR'),
    '7447' => array('town' => 'Cresta (Avers)', 'canton' => 'GR'),
    '7448' => array('town' => 'Juf', 'canton' => 'GR'),
    '7450' => array('town' => 'Tiefencastel', 'canton' => 'GR'),
    '7458' => array('town' => 'Mon', 'canton' => 'GR'),
    '7459' => array('town' => 'Stierva', 'canton' => 'GR'),
    '7451' => array('town' => 'Alvaschein', 'canton' => 'GR'),
    '7452' => array('town' => 'Cunter', 'canton' => 'GR'),
    '7453' => array('town' => 'Tinizong', 'canton' => 'GR'),
    '7454' => array('town' => 'Rona', 'canton' => 'GR'),
    '7455' => array('town' => 'Mulegns', 'canton' => 'GR'),
    '7456' => array('town' => 'Sur', 'canton' => 'GR'),
    '7457' => array('town' => 'Bivio', 'canton' => 'GR'),
    '7460' => array('town' => 'Savognin', 'canton' => 'GR'),
    '7462' => array('town' => 'Salouf', 'canton' => 'GR'),
    '7463' => array('town' => 'Riom', 'canton' => 'GR'),
    '7464' => array('town' => 'Parsonz', 'canton' => 'GR'),
    '7472' => array('town' => 'Surava', 'canton' => 'GR'),
    '7473' => array('town' => 'Alvaneu Bad', 'canton' => 'GR'),
    '7477' => array('town' => 'Filisur', 'canton' => 'GR'),
    '7482' => array('town' => 'Bergün/Bravuogn', 'canton' => 'GR'),
    '7484' => array('town' => 'Latsch', 'canton' => 'GR'),
    '7492' => array('town' => 'Alvaneu Dorf', 'canton' => 'GR'),
    '7493' => array('town' => 'Schmitten (Albula)', 'canton' => 'GR'),
    '7494' => array('town' => 'Davos Wiesen', 'canton' => 'GR'),
    '7500' => array('town' => 'St. Moritz', 'canton' => 'GR'),
    '7502' => array('town' => 'Bever', 'canton' => 'GR'),
    '7503' => array('town' => 'Samedan', 'canton' => 'GR'),
    '7504' => array('town' => 'Pontresina', 'canton' => 'GR'),
    '7505' => array('town' => 'Celerina', 'canton' => 'GR'),
    '7512' => array('town' => 'Champfèr', 'canton' => 'GR'),
    '7513' => array('town' => 'Silvaplana', 'canton' => 'GR'),
    '7514' => array('town' => 'Sils/Segl Maria', 'canton' => 'GR'),
    '7515' => array('town' => 'Sils/Segl Baselgia', 'canton' => 'GR'),
    '7516' => array('town' => 'Maloja', 'canton' => 'GR'),
    '7517' => array('town' => 'Plaun da Lej', 'canton' => 'GR'),
    '7522' => array('town' => 'La Punt-Chamues-ch', 'canton' => 'GR'),
    '7523' => array('town' => 'Madulain', 'canton' => 'GR'),
    '7524' => array('town' => 'Zuoz', 'canton' => 'GR'),
    '7525' => array('town' => 'S-chanf', 'canton' => 'GR'),
    '7526' => array('town' => 'Cinuos-chel', 'canton' => 'GR'),
    '7527' => array('town' => 'Brail', 'canton' => 'GR'),
    '7530' => array('town' => 'Zernez', 'canton' => 'GR'),
    '7532' => array('town' => 'Tschierv', 'canton' => 'GR'),
    '7533' => array('town' => 'Fuldera', 'canton' => 'GR'),
    '7534' => array('town' => 'Lü', 'canton' => 'GR'),
    '7535' => array('town' => 'Valchava', 'canton' => 'GR'),
    '7536' => array('town' => 'Sta. Maria V. M.', 'canton' => 'GR'),
    '7537' => array('town' => 'Müstair', 'canton' => 'GR'),
    '7542' => array('town' => 'Susch', 'canton' => 'GR'),
    '7543' => array('town' => 'Lavin', 'canton' => 'GR'),
    '7545' => array('town' => 'Guarda', 'canton' => 'GR'),
    '7546' => array('town' => 'Ardez', 'canton' => 'GR'),
    '7550' => array('town' => 'Scuol', 'canton' => 'GR'),
    '7551' => array('town' => 'Ftan', 'canton' => 'GR'),
    '7552' => array('town' => 'Vulpera', 'canton' => 'GR'),
    '7553' => array('town' => 'Tarasp', 'canton' => 'GR'),
    '7554' => array('town' => 'Sent', 'canton' => 'GR'),
    '7556' => array('town' => 'Ramosch', 'canton' => 'GR'),
    '7557' => array('town' => 'Vnà', 'canton' => 'GR'),
    '7558' => array('town' => 'Strada', 'canton' => 'GR'),
    '7559' => array('town' => 'Tschlin', 'canton' => 'GR'),
    '7560' => array('town' => 'Martina', 'canton' => 'GR'),
    '7562' => array('town' => 'Samnaun-Compatsch', 'canton' => 'GR'),
    '7563' => array('town' => 'Samnaun Dorf', 'canton' => 'GR'),
    '7602' => array('town' => 'Casaccia', 'canton' => 'GR'),
    '7603' => array('town' => 'Vicosoprano', 'canton' => 'GR'),
    '7604' => array('town' => 'Borgonovo', 'canton' => 'GR'),
    '7605' => array('town' => 'Stampa', 'canton' => 'GR'),
    '7606' => array('town' => 'Promontogno', 'canton' => 'GR'),
    '7610' => array('town' => 'Soglio', 'canton' => 'GR'),
    '7608' => array('town' => 'Castasegna', 'canton' => 'GR'),
    '7742' => array('town' => 'Poschiavo', 'canton' => 'GR'),
    '7743' => array('town' => 'Brusio', 'canton' => 'GR'),
    '7747' => array('town' => 'Viano', 'canton' => 'GR'),
    '7744' => array('town' => 'Campocologno', 'canton' => 'GR'),
    '7710' => array('town' => 'Ospizio Bernina', 'canton' => 'GR'),
    '7741' => array('town' => 'S. Carlo GR', 'canton' => 'GR'),
    '7745' => array('town' => 'Li Curt', 'canton' => 'GR'),
    '7746' => array('town' => 'Le Prese', 'canton' => 'GR'),
    '7748' => array('town' => 'Campascio', 'canton' => 'GR'),
    '8000' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8001' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8002' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8003' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8004' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8005' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8006' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8008' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8010' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8020' => array('town' => 'Zürich 1', 'canton' => 'ZH'),
    '8016' => array('town' => 'Zürich 16 Zust', 'canton' => 'ZH'),
    '8080' => array('town' => 'Zürich 80', 'canton' => 'ZH'),
    '8021' => array('town' => 'Zürich 1 Sihlpost', 'canton' => 'ZH'),
    '8022' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8023' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8024' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8026' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8027' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8030' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8031' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8032' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8033' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8034' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8036' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8037' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8038' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8039' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8040' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8041' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8042' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8044' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8045' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8046' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8047' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8048' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8049' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8050' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8051' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8052' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8053' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8055' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8057' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8058' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8061' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8063' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8064' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8065' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8088' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8090' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8091' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8092' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8093' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8099' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8102' => array('town' => 'Oberengstringen', 'canton' => 'ZH'),
    '8103' => array('town' => 'Unterengstringen', 'canton' => 'ZH'),
    '8104' => array('town' => 'Weiningen ZH', 'canton' => 'ZH'),
    '8105' => array('town' => 'Regensdorf', 'canton' => 'ZH'),
    '8107' => array('town' => 'Buchs ZH', 'canton' => 'ZH'),
    '8108' => array('town' => 'Dällikon', 'canton' => 'ZH'),
    '8112' => array('town' => 'Otelfingen', 'canton' => 'ZH'),
    '8113' => array('town' => 'Boppelsen', 'canton' => 'ZH'),
    '8114' => array('town' => 'Dänikon ZH', 'canton' => 'ZH'),
    '8115' => array('town' => 'Hüttikon', 'canton' => 'ZH'),
    '5436' => array('town' => 'Würenlos', 'canton' => 'AG'),
    '8117' => array('town' => 'Fällanden', 'canton' => 'ZH'),
    '8121' => array('town' => 'Benglen', 'canton' => 'ZH'),
    '8122' => array('town' => 'Binz', 'canton' => 'ZH'),
    '8123' => array('town' => 'Ebmatingen', 'canton' => 'ZH'),
    '8124' => array('town' => 'Maur', 'canton' => 'ZH'),
    '8125' => array('town' => 'Zollikerberg', 'canton' => 'ZH'),
    '8126' => array('town' => 'Zumikon', 'canton' => 'ZH'),
    '8127' => array('town' => 'Forch', 'canton' => 'ZH'),
    '8132' => array('town' => 'Hinteregg', 'canton' => 'ZH'),
    '8133' => array('town' => 'Esslingen', 'canton' => 'ZH'),
    '8134' => array('town' => 'Adliswil', 'canton' => 'ZH'),
    '8135' => array('town' => 'Langnau am Albis', 'canton' => 'ZH'),
    '8136' => array('town' => 'Gattikon', 'canton' => 'ZH'),
    '8143' => array('town' => 'Uetliberg', 'canton' => 'ZH'),
    '8142' => array('town' => 'Uitikon Waldegg', 'canton' => 'ZH'),
    '8152' => array('town' => 'Glattbrugg', 'canton' => 'ZH'),
    '8153' => array('town' => 'Rümlang', 'canton' => 'ZH'),
    '8154' => array('town' => 'Oberglatt ZH', 'canton' => 'ZH'),
    '8155' => array('town' => 'Niederhasli', 'canton' => 'ZH'),
    '8156' => array('town' => 'Oberhasli', 'canton' => 'ZH'),
    '8157' => array('town' => 'Dielsdorf', 'canton' => 'ZH'),
    '8158' => array('town' => 'Regensberg', 'canton' => 'ZH'),
    '8162' => array('town' => 'Steinmaur', 'canton' => 'ZH'),
    '8164' => array('town' => 'Bachs', 'canton' => 'ZH'),
    '8165' => array('town' => 'Schöfflisdorf', 'canton' => 'ZH'),
    '8166' => array('town' => 'Niederweningen', 'canton' => 'ZH'),
    '8172' => array('town' => 'Niederglatt ZH', 'canton' => 'ZH'),
    '8173' => array('town' => 'Neerach', 'canton' => 'ZH'),
    '8174' => array('town' => 'Stadel', 'canton' => 'ZH'),
    '8175' => array('town' => 'Windlach', 'canton' => 'ZH'),
    '8180' => array('town' => 'Bülach', 'canton' => 'ZH'),
    '8181' => array('town' => 'Höri', 'canton' => 'ZH'),
    '8182' => array('town' => 'Hochfelden', 'canton' => 'ZH'),
    '8184' => array('town' => 'Bachenbülach', 'canton' => 'ZH'),
    '8185' => array('town' => 'Winkel', 'canton' => 'ZH'),
    '8192' => array('town' => 'Glattfelden', 'canton' => 'ZH'),
    '8193' => array('town' => 'Eglisau', 'canton' => 'ZH'),
    '8194' => array('town' => 'Hüntwangen', 'canton' => 'ZH'),
    '8195' => array('town' => 'Wasterkingen', 'canton' => 'ZH'),
    '8196' => array('town' => 'Wil ZH', 'canton' => 'ZH'),
    '8197' => array('town' => 'Rafz', 'canton' => 'ZH'),
    '8200' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8201' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8202' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8203' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8204' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8205' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8207' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8208' => array('town' => 'Schaffhausen', 'canton' => 'SH'),
    '8219' => array('town' => 'Trasadingen', 'canton' => 'SH'),
    '8228' => array('town' => 'Beggingen', 'canton' => 'SH'),
    '8231' => array('town' => 'Hemmental', 'canton' => 'SH'),
    '8234' => array('town' => 'Stetten SH', 'canton' => 'SH'),
    '8235' => array('town' => 'Lohn SH', 'canton' => 'SH'),
    '8236' => array('town' => 'Opfertshofen SH', 'canton' => 'SH'),
    '8242' => array('town' => 'Bibern SH', 'canton' => 'SH'),
    '8243' => array('town' => 'Altdorf SH', 'canton' => 'SH'),
    '8239' => array('town' => 'Dörflingen', 'canton' => 'SH'),
    '8212' => array('town' => 'Neuhausen', 'canton' => 'SH'),
    '8213' => array('town' => 'Neunkirch', 'canton' => 'SH'),
    '8214' => array('town' => 'Gächlingen', 'canton' => 'SH'),
    '8215' => array('town' => 'Hallau', 'canton' => 'SH'),
    '8216' => array('town' => 'Oberhallau', 'canton' => 'SH'),
    '8217' => array('town' => 'Wilchingen', 'canton' => 'SH'),
    '8218' => array('town' => 'Osterfingen', 'canton' => 'SH'),
    '8222' => array('town' => 'Beringen', 'canton' => 'SH'),
    '8223' => array('town' => 'Guntmadingen', 'canton' => 'SH'),
    '8224' => array('town' => 'Löhningen', 'canton' => 'SH'),
    '8225' => array('town' => 'Siblingen', 'canton' => 'SH'),
    '8226' => array('town' => 'Schleitheim', 'canton' => 'SH'),
    '8232' => array('town' => 'Merishausen', 'canton' => 'SH'),
    '8233' => array('town' => 'Bargen SH', 'canton' => 'SH'),
    '8240' => array('town' => 'Thayngen', 'canton' => 'SH'),
    '8241' => array('town' => 'Barzheim', 'canton' => 'SH'),
    '8245' => array('town' => 'Feuerthalen', 'canton' => 'ZH'),
    '8246' => array('town' => 'Langwiesen', 'canton' => 'ZH'),
    '8247' => array('town' => 'Flurlingen', 'canton' => 'ZH'),
    '8252' => array('town' => 'Schlatt TG', 'canton' => 'TG'),
    '8254' => array('town' => 'Basadingen', 'canton' => 'TG'),
    '8259' => array('town' => 'Kaltenbach', 'canton' => 'TG'),
    '8253' => array('town' => 'Diessenhofen', 'canton' => 'TG'),
    '8255' => array('town' => 'Schlattingen', 'canton' => 'TG'),
    '8260' => array('town' => 'Stein am Rhein', 'canton' => 'SH'),
    '8261' => array('town' => 'Hemishofen', 'canton' => 'SH'),
    '8262' => array('town' => 'Ramsen', 'canton' => 'SH'),
    '8263' => array('town' => 'Buch SH', 'canton' => 'SH'),
    '8264' => array('town' => 'Eschenz', 'canton' => 'TG'),
    '8265' => array('town' => 'Mammern', 'canton' => 'TG'),
    '8266' => array('town' => 'Steckborn', 'canton' => 'TG'),
    '8267' => array('town' => 'Berlingen', 'canton' => 'TG'),
    '8268' => array('town' => 'Mannenbach-Salenst', 'canton' => 'TG'),
    '8272' => array('town' => 'Ermatingen', 'canton' => 'TG'),
    '8273' => array('town' => 'Triboltingen', 'canton' => 'TG'),
    '8274' => array('town' => 'Tägerwilen', 'canton' => 'TG'),
    '8280' => array('town' => 'Kreuzlingen', 'canton' => 'TG'),
    '8301' => array('town' => 'Glattzentrum', 'canton' => 'ZH'),
    '8302' => array('town' => 'Kloten', 'canton' => 'ZH'),
    '8303' => array('town' => 'Bassersdorf', 'canton' => 'ZH'),
    '8304' => array('town' => 'Wallisellen', 'canton' => 'ZH'),
    '8305' => array('town' => 'Dietlikon', 'canton' => 'ZH'),
    '8306' => array('town' => 'Brüttisellen', 'canton' => 'ZH'),
    '8307' => array('town' => 'Effretikon', 'canton' => 'ZH'),
    '8315' => array('town' => 'Lindau', 'canton' => 'ZH'),
    '8308' => array('town' => 'Illnau', 'canton' => 'ZH'),
    '8309' => array('town' => 'Nürensdorf', 'canton' => 'ZH'),
    '8310' => array('town' => 'Kemptthal', 'canton' => 'ZH'),
    '8312' => array('town' => 'Winterberg ZH', 'canton' => 'ZH'),
    '8311' => array('town' => 'Brütten', 'canton' => 'ZH'),
    '8314' => array('town' => 'Kyburg', 'canton' => 'ZH'),
    '8130' => array('town' => 'Zumikon Y. Rocher', 'canton' => 'ZH'),
    '8320' => array('town' => 'Fehraltorf', 'canton' => 'ZH'),
    '8489' => array('town' => 'Wildberg', 'canton' => 'ZH'),
    '8322' => array('town' => 'Madetswil', 'canton' => 'ZH'),
    '8330' => array('town' => 'Pfäffikon ZH', 'canton' => 'ZH'),
    '8331' => array('town' => 'Auslikon', 'canton' => 'ZH'),
    '8332' => array('town' => 'Russikon', 'canton' => 'ZH'),
    '8335' => array('town' => 'Hittnau', 'canton' => 'ZH'),
    '8340' => array('town' => 'Hinwil', 'canton' => 'ZH'),
    '8342' => array('town' => 'Wernetshausen', 'canton' => 'ZH'),
    '8344' => array('town' => 'Bäretswil', 'canton' => 'ZH'),
    '8345' => array('town' => 'Adetswil', 'canton' => 'ZH'),
    '8352' => array('town' => 'Elsau', 'canton' => 'ZH'),
    '8353' => array('town' => 'Elgg', 'canton' => 'ZH'),
    '8354' => array('town' => 'Hofstetten ZH', 'canton' => 'ZH'),
    '8355' => array('town' => 'Aadorf', 'canton' => 'TG'),
    '8356' => array('town' => 'Ettenhausen TG', 'canton' => 'TG'),
    '8357' => array('town' => 'Guntershausen', 'canton' => 'TG'),
    '8360' => array('town' => 'Eschlikon TG', 'canton' => 'TG'),
    '8362' => array('town' => 'Balterswil', 'canton' => 'TG'),
    '8363' => array('town' => 'Bichelsee', 'canton' => 'TG'),
    '8370' => array('town' => 'Sirnach', 'canton' => 'TG'),
    '8372' => array('town' => 'Wiezikon b.Sirnach', 'canton' => 'TG'),
    '8374' => array('town' => 'Oberwangen TG', 'canton' => 'TG'),
    '8376' => array('town' => 'Fischingen', 'canton' => 'TG'),
    '8400' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8401' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8402' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8404' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8405' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8406' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8408' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8409' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8410' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8411' => array('town' => 'Winterthur', 'canton' => 'ZH'),
    '8412' => array('town' => 'Aesch (Neftenbach)', 'canton' => 'ZH'),
    '8413' => array('town' => 'Neftenbach', 'canton' => 'ZH'),
    '8414' => array('town' => 'Buch am Irchel', 'canton' => 'ZH'),
    '8415' => array('town' => 'Berg am Irchel', 'canton' => 'ZH'),
    '8416' => array('town' => 'Flaach', 'canton' => 'ZH'),
    '8418' => array('town' => 'Schlatt', 'canton' => 'ZH'),
    '8422' => array('town' => 'Pfungen', 'canton' => 'ZH'),
    '8421' => array('town' => 'Dättlikon', 'canton' => 'ZH'),
    '8423' => array('town' => 'Embrach-Embraport', 'canton' => 'ZH'),
    '8424' => array('town' => 'Embrach', 'canton' => 'ZH'),
    '8425' => array('town' => 'Oberembrach', 'canton' => 'ZH'),
    '8426' => array('town' => 'Lufingen', 'canton' => 'ZH'),
    '8427' => array('town' => 'Rorbas-Freienstein', 'canton' => 'ZH'),
    '8428' => array('town' => 'Teufen ZH', 'canton' => 'ZH'),
    '8187' => array('town' => 'Weiach', 'canton' => 'ZH'),
    '5466' => array('town' => 'Kaiserstuhl AG', 'canton' => 'AG'),
    '5467' => array('town' => 'Fisibach', 'canton' => 'AG'),
    '5332' => array('town' => 'Rekingen AG', 'canton' => 'AG'),
    '5330' => array('town' => 'Bad Zurzach', 'canton' => 'AG'),
    '5323' => array('town' => 'Rietheim', 'canton' => 'AG'),
    '5464' => array('town' => 'Rümikon AG', 'canton' => 'AG'),
    '5465' => array('town' => 'Mellikon', 'canton' => 'AG'),
    '5463' => array('town' => 'Wislikofen', 'canton' => 'AG'),
    '5462' => array('town' => 'Siglistorf', 'canton' => 'AG'),
    '5333' => array('town' => 'Baldingen', 'canton' => 'AG'),
    '5334' => array('town' => 'Böbikon', 'canton' => 'AG'),
    '8442' => array('town' => 'Hettlingen', 'canton' => 'ZH'),
    '8444' => array('town' => 'Henggart', 'canton' => 'ZH'),
    '8447' => array('town' => 'Dachsen', 'canton' => 'ZH'),
    '8248' => array('town' => 'Uhwiesen', 'canton' => 'ZH'),
    '8450' => array('town' => 'Andelfingen', 'canton' => 'ZH'),
    '8453' => array('town' => 'Alten', 'canton' => 'ZH'),
    '8451' => array('town' => 'Kleinandelfingen', 'canton' => 'ZH'),
    '8452' => array('town' => 'Adlikon', 'canton' => 'ZH'),
    '8457' => array('town' => 'Humlikon', 'canton' => 'ZH'),
    '8458' => array('town' => 'Dorf', 'canton' => 'ZH'),
    '8459' => array('town' => 'Volken', 'canton' => 'ZH'),
    '8454' => array('town' => 'Buchberg', 'canton' => 'SH'),
    '8455' => array('town' => 'Rüdlingen', 'canton' => 'SH'),
    '8460' => array('town' => 'Marthalen', 'canton' => 'ZH'),
    '8464' => array('town' => 'Ellikon am Rhein', 'canton' => 'ZH'),
    '8461' => array('town' => 'Oerlingen', 'canton' => 'ZH'),
    '8465' => array('town' => 'Rudolfingen', 'canton' => 'ZH'),
    '8466' => array('town' => 'Trüllikon', 'canton' => 'ZH'),
    '8462' => array('town' => 'Rheinau', 'canton' => 'ZH'),
    '8463' => array('town' => 'Benken ZH', 'canton' => 'ZH'),
    '8472' => array('town' => 'Seuzach', 'canton' => 'ZH'),
    '8474' => array('town' => 'Dinhard', 'canton' => 'ZH'),
    '8475' => array('town' => 'Ossingen', 'canton' => 'ZH'),
    '8476' => array('town' => 'Unterstammheim', 'canton' => 'ZH'),
    '8477' => array('town' => 'Oberstammheim', 'canton' => 'ZH'),
    '8471' => array('town' => 'Rutschwil', 'canton' => 'ZH'),
    '8478' => array('town' => 'Thalheim', 'canton' => 'ZH'),
    '8479' => array('town' => 'Altikon', 'canton' => 'ZH'),
    '8467' => array('town' => 'Truttikon', 'canton' => 'ZH'),
    '8468' => array('town' => 'Guntalingen', 'canton' => 'ZH'),
    '8482' => array('town' => 'Sennhof', 'canton' => 'ZH'),
    '8483' => array('town' => 'Kollbrunn', 'canton' => 'ZH'),
    '8484' => array('town' => 'Weisslingen', 'canton' => 'ZH'),
    '8486' => array('town' => 'Rikon im Tösstal', 'canton' => 'ZH'),
    '8487' => array('town' => 'Rämismühle', 'canton' => 'ZH'),
    '8488' => array('town' => 'Turbenthal', 'canton' => 'ZH'),
    '8492' => array('town' => 'Wila', 'canton' => 'ZH'),
    '8493' => array('town' => 'Saland', 'canton' => 'ZH'),
    '8494' => array('town' => 'Bauma', 'canton' => 'ZH'),
    '8496' => array('town' => 'Steg im Tösstal', 'canton' => 'ZH'),
    '8497' => array('town' => 'Fischenthal', 'canton' => 'ZH'),
    '8498' => array('town' => 'Gibswil-Ried', 'canton' => 'ZH'),
    '8495' => array('town' => 'Schmidrüti', 'canton' => 'ZH'),
    '8499' => array('town' => 'Sternenberg', 'canton' => 'ZH'),
    '8500' => array('town' => 'Frauenfeld', 'canton' => 'TG'),
    '8501' => array('town' => 'Frauenfeld', 'canton' => 'TG'),
    '8502' => array('town' => 'Frauenfeld', 'canton' => 'TG'),
    '8503' => array('town' => 'Frauenfeld', 'canton' => 'TG'),
    '8505' => array('town' => 'Pfyn', 'canton' => 'TG'),
    '8506' => array('town' => 'Lanzenneunforn', 'canton' => 'TG'),
    '8507' => array('town' => 'Hörhausen', 'canton' => 'TG'),
    '8508' => array('town' => 'Homburg', 'canton' => 'TG'),
    '8512' => array('town' => 'Thundorf', 'canton' => 'TG'),
    '8514' => array('town' => 'Amlikon-Bissegg', 'canton' => 'TG'),
    '8522' => array('town' => 'Häuslenen', 'canton' => 'TG'),
    '8523' => array('town' => 'Hagenbuch ZH', 'canton' => 'ZH'),
    '8524' => array('town' => 'Uesslingen', 'canton' => 'TG'),
    '8525' => array('town' => 'Niederneunforn', 'canton' => 'TG'),
    '8526' => array('town' => 'Oberneunforn', 'canton' => 'TG'),
    '8532' => array('town' => 'Warth', 'canton' => 'TG'),
    '8535' => array('town' => 'Herdern', 'canton' => 'TG'),
    '8536' => array('town' => 'Hüttwilen', 'canton' => 'TG'),
    '8537' => array('town' => 'Nussbaumen TG', 'canton' => 'TG'),
    '8542' => array('town' => 'Wiesendangen', 'canton' => 'ZH'),
    '8545' => array('town' => 'Rickenbach ZH', 'canton' => 'ZH'),
    '8544' => array('town' => 'Attikon', 'canton' => 'ZH'),
    '8546' => array('town' => 'Islikon', 'canton' => 'TG'),
    '8547' => array('town' => 'Gachnang', 'canton' => 'TG'),
    '8548' => array('town' => 'Ellikon a d Thur', 'canton' => 'ZH'),
    '8552' => array('town' => 'Felben-Wellhausen', 'canton' => 'TG'),
    '8553' => array('town' => 'Hüttlingen-Mettdf', 'canton' => 'TG'),
    '8554' => array('town' => 'Müllheim-Wigoltgn', 'canton' => 'TG'),
    '8555' => array('town' => 'Müllheim Dorf', 'canton' => 'TG'),
    '8556' => array('town' => 'Wigoltingen', 'canton' => 'TG'),
    '8564' => array('town' => 'Lipperswil', 'canton' => 'TG'),
    '8558' => array('town' => 'Raperswilen', 'canton' => 'TG'),
    '8269' => array('town' => 'Fruthwilen', 'canton' => 'TG'),
    '8560' => array('town' => 'Märstetten', 'canton' => 'TG'),
    '8561' => array('town' => 'Ottoberg', 'canton' => 'TG'),
    '8565' => array('town' => 'Hugelshofen', 'canton' => 'TG'),
    '8566' => array('town' => 'Dotnacht', 'canton' => 'TG'),
    '8570' => array('town' => 'Weinfelden', 'canton' => 'TG'),
    '8572' => array('town' => 'Berg TG', 'canton' => 'TG'),
    '8573' => array('town' => 'Siegershausen', 'canton' => 'TG'),
    '8574' => array('town' => 'Lengwil-Oberhofen', 'canton' => 'TG'),
    '8575' => array('town' => 'Bürglen TG', 'canton' => 'TG'),
    '8576' => array('town' => 'Mauren TG', 'canton' => 'TG'),
    '8577' => array('town' => 'Schönholzerswilen', 'canton' => 'TG'),
    '9217' => array('town' => 'Neukirch', 'canton' => 'TG'),
    '8580' => array('town' => 'Amriswil', 'canton' => 'TG'),
    '8582' => array('town' => 'Dozwil', 'canton' => 'TG'),
    '8581' => array('town' => 'Schocherswil', 'canton' => 'TG'),
    '8588' => array('town' => 'Zihlschlacht', 'canton' => 'TG'),
    '8589' => array('town' => 'Sitterdorf', 'canton' => 'TG'),
    '8583' => array('town' => 'Sulgen', 'canton' => 'TG'),
    '8584' => array('town' => 'Leimbach TG', 'canton' => 'TG'),
    '8585' => array('town' => 'Mattwil', 'canton' => 'TG'),
    '8586' => array('town' => 'Erlen', 'canton' => 'TG'),
    '8587' => array('town' => 'Oberaach', 'canton' => 'TG'),
    '8590' => array('town' => 'Romanshorn', 'canton' => 'TG'),
    '8599' => array('town' => 'Salmsach', 'canton' => 'TG'),
    '8592' => array('town' => 'Uttwil', 'canton' => 'TG'),
    '8593' => array('town' => 'Kesswil', 'canton' => 'TG'),
    '8594' => array('town' => 'Güttingen', 'canton' => 'TG'),
    '8595' => array('town' => 'Altnau', 'canton' => 'TG'),
    '8596' => array('town' => 'Scherzingen', 'canton' => 'TG'),
    '8597' => array('town' => 'Landschlacht', 'canton' => 'TG'),
    '8598' => array('town' => 'Bottighofen', 'canton' => 'TG'),
    '8600' => array('town' => 'Dübendorf', 'canton' => 'ZH'),
    '8602' => array('town' => 'Wangen ZH', 'canton' => 'ZH'),
    '8603' => array('town' => 'Schwerzenbach', 'canton' => 'ZH'),
    '8604' => array('town' => 'Volketswil', 'canton' => 'ZH'),
    '8605' => array('town' => 'Gutenswil', 'canton' => 'ZH'),
    '8606' => array('town' => 'Nänikon', 'canton' => 'ZH'),
    '8607' => array('town' => 'Aathal-Seegräben', 'canton' => 'ZH'),
    '8608' => array('town' => 'Bubikon', 'canton' => 'ZH'),
    '8610' => array('town' => 'Uster', 'canton' => 'ZH'),
    '8612' => array('town' => 'Uster 2', 'canton' => 'ZH'),
    '8613' => array('town' => 'Uster 3', 'canton' => 'ZH'),
    '8614' => array('town' => 'Bertschikon Gossau', 'canton' => 'ZH'),
    '8615' => array('town' => 'Wermatswil', 'canton' => 'ZH'),
    '8616' => array('town' => 'Riedikon', 'canton' => 'ZH'),
    '8617' => array('town' => 'Mönchaltorf', 'canton' => 'ZH'),
    '8618' => array('town' => 'Oetwil am See', 'canton' => 'ZH'),
    '8620' => array('town' => 'Wetzikon ZH', 'canton' => 'ZH'),
    '8621' => array('town' => 'Wetzikon ZH 4', 'canton' => 'ZH'),
    '8622' => array('town' => 'Wetzikon ZH', 'canton' => 'ZH'),
    '8623' => array('town' => 'Wetzikon ZH', 'canton' => 'ZH'),
    '8624' => array('town' => 'Grüt (Gossau ZH)', 'canton' => 'ZH'),
    '8625' => array('town' => 'Gossau ZH', 'canton' => 'ZH'),
    '8626' => array('town' => 'Ottikon', 'canton' => 'ZH'),
    '8627' => array('town' => 'Grüningen', 'canton' => 'ZH'),
    '8630' => array('town' => 'Rüti ZH', 'canton' => 'ZH'),
    '8632' => array('town' => 'Tann', 'canton' => 'ZH'),
    '8633' => array('town' => 'Wolfhausen', 'canton' => 'ZH'),
    '8634' => array('town' => 'Hombrechtikon', 'canton' => 'ZH'),
    '8635' => array('town' => 'Dürnten', 'canton' => 'ZH'),
    '8636' => array('town' => 'Wald ZH', 'canton' => 'ZH'),
    '8639' => array('town' => 'Faltigberg', 'canton' => 'ZH'),
    '8637' => array('town' => 'Laupen ZH', 'canton' => 'ZH'),
    '8638' => array('town' => 'Goldingen', 'canton' => 'SG'),
    '8640' => array('town' => 'Rapperswil SG', 'canton' => 'SG'),
    '8645' => array('town' => 'Jona', 'canton' => 'SG'),
    '8646' => array('town' => 'Wagen', 'canton' => 'SG'),
    '8700' => array('town' => 'Küsnacht ZH', 'canton' => 'ZH'),
    '8702' => array('town' => 'Zollikon', 'canton' => 'ZH'),
    '8703' => array('town' => 'Erlenbach ZH', 'canton' => 'ZH'),
    '8704' => array('town' => 'Herrliberg', 'canton' => 'ZH'),
    '8706' => array('town' => 'Meilen', 'canton' => 'ZH'),
    '8707' => array('town' => 'Uetikon am See', 'canton' => 'ZH'),
    '8708' => array('town' => 'Männedorf', 'canton' => 'ZH'),
    '8712' => array('town' => 'Stäfa', 'canton' => 'ZH'),
    '8713' => array('town' => 'Uerikon', 'canton' => 'ZH'),
    '8714' => array('town' => 'Feldbach', 'canton' => 'ZH'),
    '8715' => array('town' => 'Bollingen', 'canton' => 'SG'),
    '8716' => array('town' => 'Schmerikon', 'canton' => 'SG'),
    '8717' => array('town' => 'Benken SG', 'canton' => 'SG'),
    '8718' => array('town' => 'Schänis', 'canton' => 'SG'),
    '8722' => array('town' => 'Kaltbrunn', 'canton' => 'SG'),
    '8723' => array('town' => 'Rufi', 'canton' => 'SG'),
    '8725' => array('town' => 'Ernetschwil', 'canton' => 'SG'),
    '8726' => array('town' => 'Ricken SG', 'canton' => 'SG'),
    '8727' => array('town' => 'Walde SG', 'canton' => 'SG'),
    '8730' => array('town' => 'Uznach', 'canton' => 'SG'),
    '8732' => array('town' => 'Neuhaus SG', 'canton' => 'SG'),
    '8733' => array('town' => 'Eschenbach SG', 'canton' => 'SG'),
    '8734' => array('town' => 'Ermenswil', 'canton' => 'SG'),
    '8735' => array('town' => 'St. Gallenkappel', 'canton' => 'SG'),
    '8737' => array('town' => 'Gommiswald', 'canton' => 'SG'),
    '8738' => array('town' => 'Uetliburg SG', 'canton' => 'SG'),
    '8739' => array('town' => 'Rieden SG', 'canton' => 'SG'),
    '8740' => array('town' => 'Uznach Vögele AG', 'canton' => 'SG'),
    '8750' => array('town' => 'Glarus', 'canton' => 'GL'),
    '8751' => array('town' => 'Urnerboden', 'canton' => 'UR'),
    '8752' => array('town' => 'Näfels', 'canton' => 'GL'),
    '8753' => array('town' => 'Mollis', 'canton' => 'GL'),
    '8754' => array('town' => 'Netstal', 'canton' => 'GL'),
    '8755' => array('town' => 'Ennenda', 'canton' => 'GL'),
    '8756' => array('town' => 'Mitlödi', 'canton' => 'GL'),
    '8762' => array('town' => 'Schwanden GL', 'canton' => 'GL'),
    '8765' => array('town' => 'Engi', 'canton' => 'GL'),
    '8766' => array('town' => 'Matt', 'canton' => 'GL'),
    '8767' => array('town' => 'Elm', 'canton' => 'GL'),
    '8772' => array('town' => 'Nidfurn', 'canton' => 'GL'),
    '8773' => array('town' => 'Haslen GL', 'canton' => 'GL'),
    '8775' => array('town' => 'Luchsingen', 'canton' => 'GL'),
    '8777' => array('town' => 'Diesbach GL', 'canton' => 'GL'),
    '8782' => array('town' => 'Rüti GL', 'canton' => 'GL'),
    '8783' => array('town' => 'Linthal', 'canton' => 'GL'),
    '8784' => array('town' => 'Braunwald', 'canton' => 'GL'),
    '8800' => array('town' => 'Thalwil', 'canton' => 'ZH'),
    '8802' => array('town' => 'Kilchberg ZH', 'canton' => 'ZH'),
    '8803' => array('town' => 'Rüschlikon', 'canton' => 'ZH'),
    '8804' => array('town' => 'Au ZH', 'canton' => 'ZH'),
    '8805' => array('town' => 'Richterswil', 'canton' => 'ZH'),
    '8806' => array('town' => 'Bäch SZ', 'canton' => 'SZ'),
    '8807' => array('town' => 'Freienbach', 'canton' => 'SZ'),
    '8808' => array('town' => 'Pfäffikon SZ', 'canton' => 'SZ'),
    '8810' => array('town' => 'Horgen', 'canton' => 'ZH'),
    '8812' => array('town' => 'Horgen', 'canton' => 'ZH'),
    '8813' => array('town' => 'Horgen', 'canton' => 'ZH'),
    '8815' => array('town' => 'Horgenberg', 'canton' => 'ZH'),
    '8816' => array('town' => 'Hirzel', 'canton' => 'ZH'),
    '8820' => array('town' => 'Wädenswil', 'canton' => 'ZH'),
    '8824' => array('town' => 'Schönenberg ZH', 'canton' => 'ZH'),
    '8825' => array('town' => 'Hütten', 'canton' => 'ZH'),
    '8832' => array('town' => 'Wollerau', 'canton' => 'SZ'),
    '8833' => array('town' => 'Samstagern', 'canton' => 'ZH'),
    '8834' => array('town' => 'Schindellegi', 'canton' => 'SZ'),
    '8835' => array('town' => 'Feusisberg', 'canton' => 'SZ'),
    '8836' => array('town' => 'Bennau', 'canton' => 'SZ'),
    '8840' => array('town' => 'Einsiedeln', 'canton' => 'SZ'),
    '8849' => array('town' => 'Alpthal', 'canton' => 'SZ'),
    '8846' => array('town' => 'Willerzell', 'canton' => 'SZ'),
    '8847' => array('town' => 'Egg SZ', 'canton' => 'SZ'),
    '8841' => array('town' => 'Gross', 'canton' => 'SZ'),
    '8844' => array('town' => 'Euthal', 'canton' => 'SZ'),
    '8845' => array('town' => 'Studen SZ', 'canton' => 'SZ'),
    '8842' => array('town' => 'Unteriberg', 'canton' => 'SZ'),
    '8843' => array('town' => 'Oberiberg', 'canton' => 'SZ'),
    '8852' => array('town' => 'Altendorf', 'canton' => 'SZ'),
    '8853' => array('town' => 'Lachen SZ', 'canton' => 'SZ'),
    '8854' => array('town' => 'Siebnen', 'canton' => 'SZ'),
    '8855' => array('town' => 'Wangen SZ', 'canton' => 'SZ'),
    '8856' => array('town' => 'Tuggen', 'canton' => 'SZ'),
    '8857' => array('town' => 'Vorderthal', 'canton' => 'SZ'),
    '8858' => array('town' => 'Innerthal', 'canton' => 'SZ'),
    '8862' => array('town' => 'Schübelbach', 'canton' => 'SZ'),
    '8863' => array('town' => 'Buttikon SZ', 'canton' => 'SZ'),
    '8864' => array('town' => 'Reichenburg', 'canton' => 'SZ'),
    '8865' => array('town' => 'Bilten', 'canton' => 'GL'),
    '8866' => array('town' => 'Ziegelbrücke', 'canton' => 'GL'),
    '8867' => array('town' => 'Niederurnen', 'canton' => 'GL'),
    '8868' => array('town' => 'Oberurnen', 'canton' => 'GL'),
    '8872' => array('town' => 'Weesen', 'canton' => 'SG'),
    '8873' => array('town' => 'Amden', 'canton' => 'SG'),
    '8874' => array('town' => 'Mühlehorn', 'canton' => 'GL'),
    '8758' => array('town' => 'Obstalden', 'canton' => 'GL'),
    '8757' => array('town' => 'Filzbach', 'canton' => 'GL'),
    '8877' => array('town' => 'Murg', 'canton' => 'SG'),
    '8878' => array('town' => 'Quinten', 'canton' => 'SG'),
    '8880' => array('town' => 'Walenstadt', 'canton' => 'SG'),
    '8881' => array('town' => 'Walenstadtberg', 'canton' => 'SG'),
    '8882' => array('town' => 'Unterterzen', 'canton' => 'SG'),
    '8883' => array('town' => 'Quarten', 'canton' => 'SG'),
    '8884' => array('town' => 'Oberterzen', 'canton' => 'SG'),
    '8885' => array('town' => 'Mols', 'canton' => 'SG'),
    '8887' => array('town' => 'Mels', 'canton' => 'SG'),
    '8886' => array('town' => 'Mädris-Vermol', 'canton' => 'SG'),
    '8889' => array('town' => 'Plons', 'canton' => 'SG'),
    '8888' => array('town' => 'Heiligkreuz (Mels)', 'canton' => 'SG'),
    '8890' => array('town' => 'Flums', 'canton' => 'SG'),
    '8892' => array('town' => 'Berschis', 'canton' => 'SG'),
    '8893' => array('town' => 'Flums Hochwiese', 'canton' => 'SG'),
    '8894' => array('town' => 'Flumserberg Saxli', 'canton' => 'SG'),
    '8895' => array('town' => 'Flumserberg Portel', 'canton' => 'SG'),
    '8896' => array('town' => 'Flumserberg Bergh', 'canton' => 'SG'),
    '8897' => array('town' => 'Flumserberg Theim', 'canton' => 'SG'),
    '8898' => array('town' => 'Flumserberg Tboden', 'canton' => 'SG'),
    '8902' => array('town' => 'Urdorf', 'canton' => 'ZH'),
    '8903' => array('town' => 'Birmensdorf ZH', 'canton' => 'ZH'),
    '8904' => array('town' => 'Aesch ZH', 'canton' => 'ZH'),
    '8905' => array('town' => 'Arni-Islisberg', 'canton' => 'AG'),
    '8906' => array('town' => 'Bonstetten', 'canton' => 'ZH'),
    '8907' => array('town' => 'Wettswil', 'canton' => 'ZH'),
    '8908' => array('town' => 'Hedingen', 'canton' => 'ZH'),
    '8910' => array('town' => 'Affoltern am Albis', 'canton' => 'ZH'),
    '8909' => array('town' => 'Zwillikon', 'canton' => 'ZH'),
    '8911' => array('town' => 'Rifferswil', 'canton' => 'ZH'),
    '8912' => array('town' => 'Obfelden', 'canton' => 'ZH'),
    '8913' => array('town' => 'Ottenbach', 'canton' => 'ZH'),
    '8914' => array('town' => 'Aeugst am Albis', 'canton' => 'ZH'),
    '8915' => array('town' => 'Hausen am Albis', 'canton' => 'ZH'),
    '8916' => array('town' => 'Jonen', 'canton' => 'AG'),
    '8917' => array('town' => 'Oberlunkhofen', 'canton' => 'AG'),
    '8918' => array('town' => 'Unterlunkhofen', 'canton' => 'AG'),
    '8919' => array('town' => 'Rottenschwil', 'canton' => 'AG'),
    '8925' => array('town' => 'Ebertswil', 'canton' => 'ZH'),
    '8926' => array('town' => 'Kappel am Albis', 'canton' => 'ZH'),
    '8932' => array('town' => 'Mettmenstetten', 'canton' => 'ZH'),
    '8933' => array('town' => 'Maschwanden', 'canton' => 'ZH'),
    '8934' => array('town' => 'Knonau', 'canton' => 'ZH'),
    '8942' => array('town' => 'Oberrieden', 'canton' => 'ZH'),
    '8951' => array('town' => 'Fahrweid', 'canton' => 'ZH'),
    '8952' => array('town' => 'Schlieren', 'canton' => 'ZH'),
    '8953' => array('town' => 'Dietikon', 'canton' => 'ZH'),
    '8954' => array('town' => 'Geroldswil', 'canton' => 'ZH'),
    '8955' => array('town' => 'Oetwil a.d. Limmat', 'canton' => 'ZH'),
    '8956' => array('town' => 'Killwangen', 'canton' => 'AG'),
    '8957' => array('town' => 'Spreitenbach', 'canton' => 'AG'),
    '8962' => array('town' => 'Bergdietikon', 'canton' => 'AG'),
    '8964' => array('town' => 'Rudolfstetten', 'canton' => 'AG'),
    '8965' => array('town' => 'Berikon', 'canton' => 'AG'),
    '8966' => array('town' => 'Oberwil-Lieli', 'canton' => 'AG'),
    '8967' => array('town' => 'Widen', 'canton' => 'AG'),
    '9000' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9001' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9004' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9006' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9007' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9008' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9009' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9010' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9011' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9012' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9013' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9014' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9015' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9016' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '9030' => array('town' => 'Abtwil SG', 'canton' => 'SG'),
    '9032' => array('town' => 'Engelburg', 'canton' => 'SG'),
    '9033' => array('town' => 'Untereggen', 'canton' => 'SG'),
    '9034' => array('town' => 'Eggersriet', 'canton' => 'SG'),
    '9035' => array('town' => 'Grub AR', 'canton' => 'AR'),
    '9036' => array('town' => 'Grub SG', 'canton' => 'SG'),
    '9037' => array('town' => 'Speicherschwendi', 'canton' => 'AR'),
    '9038' => array('town' => 'Rehetobel', 'canton' => 'AR'),
    '9042' => array('town' => 'Speicher', 'canton' => 'AR'),
    '9043' => array('town' => 'Trogen', 'canton' => 'AR'),
    '9044' => array('town' => 'Wald AR', 'canton' => 'AR'),
    '9050' => array('town' => 'Appenzell', 'canton' => 'AI'),
    '9052' => array('town' => 'Niederteufen', 'canton' => 'AR'),
    '9053' => array('town' => 'Teufen AR', 'canton' => 'AR'),
    '9054' => array('town' => 'Haslen AI', 'canton' => 'AI'),
    '9055' => array('town' => 'Bühler', 'canton' => 'AR'),
    '9056' => array('town' => 'Gais', 'canton' => 'AR'),
    '9057' => array('town' => 'Weissbad', 'canton' => 'AI'),
    '9058' => array('town' => 'Brülisau', 'canton' => 'AI'),
    '9062' => array('town' => 'Lustmühle', 'canton' => 'AR'),
    '9063' => array('town' => 'Stein AR', 'canton' => 'AR'),
    '9064' => array('town' => 'Hundwil', 'canton' => 'AR'),
    '9100' => array('town' => 'Herisau', 'canton' => 'AR'),
    '9102' => array('town' => 'Herisau', 'canton' => 'AR'),
    '9103' => array('town' => 'Schwellbrunn', 'canton' => 'AR'),
    '9104' => array('town' => 'Waldstatt', 'canton' => 'AR'),
    '9105' => array('town' => 'Schönengrund', 'canton' => 'AR'),
    '9107' => array('town' => 'Urnäsch', 'canton' => 'AR'),
    '9108' => array('town' => 'Gonten', 'canton' => 'AI'),
    '9112' => array('town' => 'Schachen b.Herisau', 'canton' => 'AR'),
    '9113' => array('town' => 'Degersheim', 'canton' => 'SG'),
    '9114' => array('town' => 'Hoffeld', 'canton' => 'SG'),
    '9115' => array('town' => 'Dicken', 'canton' => 'SG'),
    '9116' => array('town' => 'Wolfertswil', 'canton' => 'SG'),
    '9122' => array('town' => 'Mogelsberg', 'canton' => 'SG'),
    '9123' => array('town' => 'Nassen', 'canton' => 'SG'),
    '9125' => array('town' => 'Brunnadern', 'canton' => 'SG'),
    '9126' => array('town' => 'Necker', 'canton' => 'SG'),
    '9127' => array('town' => 'St. Peterzell', 'canton' => 'SG'),
    '9633' => array('town' => 'Bächli (Hemberg)', 'canton' => 'SG'),
    '9200' => array('town' => 'Gossau SG', 'canton' => 'SG'),
    '9203' => array('town' => 'Niederwil SG', 'canton' => 'SG'),
    '9204' => array('town' => 'Andwil SG', 'canton' => 'SG'),
    '9205' => array('town' => 'Waldkirch', 'canton' => 'SG'),
    '9212' => array('town' => 'Arnegg', 'canton' => 'SG'),
    '9213' => array('town' => 'Hauptwil', 'canton' => 'TG'),
    '9214' => array('town' => 'Kradolf-Schönenb.', 'canton' => 'TG'),
    '9216' => array('town' => 'Heldswil', 'canton' => 'TG'),
    '9215' => array('town' => 'Schönenberg TG', 'canton' => 'TG'),
    '9220' => array('town' => 'Bischofszell', 'canton' => 'TG'),
    '9223' => array('town' => 'Schweizersholz', 'canton' => 'TG'),
    '9225' => array('town' => 'Wilen (Gottshaus)', 'canton' => 'TG'),
    '9230' => array('town' => 'Flawil', 'canton' => 'SG'),
    '9231' => array('town' => 'Egg (Flawil)', 'canton' => 'SG'),
    '9604' => array('town' => 'Oberrindal', 'canton' => 'SG'),
    '9240' => array('town' => 'Uzwil', 'canton' => 'SG'),
    '9242' => array('town' => 'Oberuzwil', 'canton' => 'SG'),
    '9248' => array('town' => 'Bichwil', 'canton' => 'SG'),
    '9243' => array('town' => 'Jonschwil', 'canton' => 'SG'),
    '9244' => array('town' => 'Niederuzwil', 'canton' => 'SG'),
    '9245' => array('town' => 'Oberbüren', 'canton' => 'SG'),
    '9246' => array('town' => 'Niederbüren', 'canton' => 'SG'),
    '9247' => array('town' => 'Henau', 'canton' => 'SG'),
    '9249' => array('town' => 'Algetshausen', 'canton' => 'SG'),
    '9300' => array('town' => 'Wittenbach', 'canton' => 'SG'),
    '9304' => array('town' => 'Bernhardzell', 'canton' => 'SG'),
    '9305' => array('town' => 'Berg SG', 'canton' => 'SG'),
    '9306' => array('town' => 'Freidorf TG', 'canton' => 'TG'),
    '9315' => array('town' => 'Winden', 'canton' => 'TG'),
    '9308' => array('town' => 'Lömmenschwil', 'canton' => 'SG'),
    '9312' => array('town' => 'Häggenschwil', 'canton' => 'SG'),
    '9313' => array('town' => 'Muolen', 'canton' => 'SG'),
    '9314' => array('town' => 'Steinebrunn', 'canton' => 'TG'),
    '9320' => array('town' => 'Arbon', 'canton' => 'TG'),
    '9322' => array('town' => 'Egnach', 'canton' => 'TG'),
    '9323' => array('town' => 'Steinach', 'canton' => 'SG'),
    '9325' => array('town' => 'Roggwil TG', 'canton' => 'TG'),
    '9326' => array('town' => 'Horn', 'canton' => 'TG'),
    '9327' => array('town' => 'Tübach', 'canton' => 'SG'),
    '9400' => array('town' => 'Rorschach', 'canton' => 'SG'),
    '9404' => array('town' => 'Rorschacherberg', 'canton' => 'SG'),
    '9402' => array('town' => 'Mörschwil', 'canton' => 'SG'),
    '9403' => array('town' => 'Goldach', 'canton' => 'SG'),
    '9405' => array('town' => 'Wienacht-Tobel', 'canton' => 'AR'),
    '9410' => array('town' => 'Heiden', 'canton' => 'AR'),
    '9411' => array('town' => 'Reute AR', 'canton' => 'AR'),
    '9413' => array('town' => 'Oberegg', 'canton' => 'AI'),
    '9414' => array('town' => 'Schachen b. Reute', 'canton' => 'AR'),
    '9422' => array('town' => 'Staad SG', 'canton' => 'SG'),
    '9423' => array('town' => 'Altenrhein', 'canton' => 'SG'),
    '9424' => array('town' => 'Rheineck', 'canton' => 'SG'),
    '9425' => array('town' => 'Thal', 'canton' => 'SG'),
    '9426' => array('town' => 'Lutzenberg', 'canton' => 'AR'),
    '9427' => array('town' => 'Wolfhalden', 'canton' => 'AR'),
    '9428' => array('town' => 'Walzenhausen', 'canton' => 'AR'),
    '9430' => array('town' => 'St. Margrethen SG', 'canton' => 'SG'),
    '9434' => array('town' => 'Au SG', 'canton' => 'SG'),
    '9435' => array('town' => 'Heerbrugg', 'canton' => 'SG'),
    '9436' => array('town' => 'Balgach', 'canton' => 'SG'),
    '9437' => array('town' => 'Marbach SG', 'canton' => 'SG'),
    '9450' => array('town' => 'Lüchingen', 'canton' => 'SG'),
    '9442' => array('town' => 'Berneck', 'canton' => 'SG'),
    '9443' => array('town' => 'Widnau', 'canton' => 'SG'),
    '9444' => array('town' => 'Diepoldsau', 'canton' => 'SG'),
    '9445' => array('town' => 'Rebstein', 'canton' => 'SG'),
    '9451' => array('town' => 'Kriessern', 'canton' => 'SG'),
    '9452' => array('town' => 'Hinterforst', 'canton' => 'SG'),
    '9453' => array('town' => 'Eichberg', 'canton' => 'SG'),
    '9462' => array('town' => 'Montlingen', 'canton' => 'SG'),
    '9463' => array('town' => 'Oberriet SG', 'canton' => 'SG'),
    '9464' => array('town' => 'Rüthi (Rheintal)', 'canton' => 'SG'),
    '9465' => array('town' => 'Salez', 'canton' => 'SG'),
    '9466' => array('town' => 'Sennwald', 'canton' => 'SG'),
    '9467' => array('town' => 'Frümsen', 'canton' => 'SG'),
    '9468' => array('town' => 'Sax', 'canton' => 'SG'),
    '9469' => array('town' => 'Haag (Rheintal)', 'canton' => 'SG'),
    '9470' => array('town' => 'Buchs SG', 'canton' => 'SG'),
    '9472' => array('town' => 'Grabs', 'canton' => 'SG'),
    '9473' => array('town' => 'Gams', 'canton' => 'SG'),
    '9475' => array('town' => 'Sevelen', 'canton' => 'SG'),
    '9476' => array('town' => 'Weite', 'canton' => 'SG'),
    '9477' => array('town' => 'Trübbach', 'canton' => 'SG'),
    '9478' => array('town' => 'Azmoos', 'canton' => 'SG'),
    '9479' => array('town' => 'Oberschan', 'canton' => 'SG'),
    '9485' => array('town' => 'Nendeln', 'canton' => 'FL'),
    '9486' => array('town' => 'Schaanwald', 'canton' => 'FL'),
    '9487' => array('town' => 'Gamprin-Bendern', 'canton' => 'FL'),
    '9488' => array('town' => 'Schellenberg', 'canton' => 'FL'),
    '9490' => array('town' => 'Vaduz', 'canton' => 'FL'),
    '9491' => array('town' => 'Ruggell', 'canton' => 'FL'),
    '9492' => array('town' => 'Eschen', 'canton' => 'FL'),
    '9493' => array('town' => 'Mauren FL', 'canton' => 'FL'),
    '9494' => array('town' => 'Schaan', 'canton' => 'FL'),
    '9495' => array('town' => 'Triesen', 'canton' => 'FL'),
    '9496' => array('town' => 'Balzers', 'canton' => 'FL'),
    '9497' => array('town' => 'Triesenberg', 'canton' => 'FL'),
    '9500' => array('town' => 'Wil SG', 'canton' => 'SG'),
    '9502' => array('town' => 'Braunau', 'canton' => 'TG'),
    '9503' => array('town' => 'Stehrenberg', 'canton' => 'TG'),
    '9504' => array('town' => 'Friltschen', 'canton' => 'TG'),
    '9506' => array('town' => 'Lommis', 'canton' => 'TG'),
    '9507' => array('town' => 'Stettfurt', 'canton' => 'TG'),
    '9508' => array('town' => 'Weingarten-Kalth', 'canton' => 'TG'),
    '9512' => array('town' => 'Rossrüti', 'canton' => 'SG'),
    '9514' => array('town' => 'Wuppenau', 'canton' => 'TG'),
    '9515' => array('town' => 'Hosenruck', 'canton' => 'TG'),
    '9517' => array('town' => 'Mettlen', 'canton' => 'TG'),
    '9565' => array('town' => 'Rothenhausen', 'canton' => 'TG'),
    '9523' => array('town' => 'Züberwangen', 'canton' => 'SG'),
    '9524' => array('town' => 'Zuzwil SG', 'canton' => 'SG'),
    '9525' => array('town' => 'Lenggenwil', 'canton' => 'SG'),
    '9526' => array('town' => 'Zuckenriet', 'canton' => 'SG'),
    '9527' => array('town' => 'Niederhelfenschwil', 'canton' => 'SG'),
    '9532' => array('town' => 'Rickenbach b. Wil', 'canton' => 'TG'),
    '9533' => array('town' => 'Kirchberg SG', 'canton' => 'SG'),
    '9534' => array('town' => 'Gähwil', 'canton' => 'SG'),
    '9535' => array('town' => 'Wilen b. Wil', 'canton' => 'TG'),
    '9536' => array('town' => 'Schwarzenbach SG', 'canton' => 'SG'),
    '9542' => array('town' => 'Münchwilen TG', 'canton' => 'TG'),
    '9543' => array('town' => 'St. Margarethen TG', 'canton' => 'TG'),
    '9545' => array('town' => 'Wängi', 'canton' => 'TG'),
    '9546' => array('town' => 'Tuttwil', 'canton' => 'TG'),
    '9547' => array('town' => 'Wittenwil', 'canton' => 'TG'),
    '9548' => array('town' => 'Matzingen', 'canton' => 'TG'),
    '9552' => array('town' => 'Bronschhofen', 'canton' => 'SG'),
    '9553' => array('town' => 'Bettwiesen', 'canton' => 'TG'),
    '9554' => array('town' => 'Tägerschen', 'canton' => 'TG'),
    '9555' => array('town' => 'Tobel', 'canton' => 'TG'),
    '9556' => array('town' => 'Affeltrangen', 'canton' => 'TG'),
    '9562' => array('town' => 'Märwil', 'canton' => 'TG'),
    '9573' => array('town' => 'Littenheid', 'canton' => 'TG'),
    '9601' => array('town' => 'Lütisburg Station', 'canton' => 'SG'),
    '9602' => array('town' => 'Bazenheid', 'canton' => 'SG'),
    '9606' => array('town' => 'Bütschwil', 'canton' => 'SG'),
    '9607' => array('town' => 'Mosnang', 'canton' => 'SG'),
    '9608' => array('town' => 'Ganterschwil', 'canton' => 'SG'),
    '9612' => array('town' => 'Dreien', 'canton' => 'SG'),
    '9613' => array('town' => 'Mühlrüti', 'canton' => 'SG'),
    '9614' => array('town' => 'Libingen', 'canton' => 'SG'),
    '9615' => array('town' => 'Dietfurt', 'canton' => 'SG'),
    '9620' => array('town' => 'Lichtensteig', 'canton' => 'SG'),
    '9621' => array('town' => 'Oberhelfenschwil', 'canton' => 'SG'),
    '9622' => array('town' => 'Krinau', 'canton' => 'SG'),
    '9630' => array('town' => 'Wattwil', 'canton' => 'SG'),
    '9631' => array('town' => 'Ulisbach', 'canton' => 'SG'),
    '9642' => array('town' => 'Ebnat-Kappel', 'canton' => 'SG'),
    '9643' => array('town' => 'Krummenau', 'canton' => 'SG'),
    '9650' => array('town' => 'Nesslau', 'canton' => 'SG'),
    '9651' => array('town' => 'Ennetbühl', 'canton' => 'SG'),
    '9655' => array('town' => 'Stein SG', 'canton' => 'SG'),
    '9652' => array('town' => 'Neu St. Johann', 'canton' => 'SG'),
    '9656' => array('town' => 'Alt St. Johann', 'canton' => 'SG'),
    '9657' => array('town' => 'Unterwasser', 'canton' => 'SG'),
    '9658' => array('town' => 'Wildhaus', 'canton' => 'SG'),
    '3185' => array('town' => 'Schmitten FR', 'canton' => 'FR'),
    '3113' => array('town' => 'Rubigen', 'canton' => 'BE'),
    '6304' => array('town' => 'Zug', 'canton' => 'ZG'),
    '6911' => array('town' => 'Campione', 'canton' => 'IT'),
    '8238' => array('town' => 'Büsingen', 'canton' => 'DE'),
    '6302' => array('town' => 'Zug', 'canton' => 'ZG'),
    '6303' => array('town' => 'Zug', 'canton' => 'ZG'),
    '1289' => array('town' => 'Genève Serv. Spéc.', 'canton' => 'GE'),
    '7003' => array('town' => 'Chur Postauto', 'canton' => 'GR'),
    '3024' => array('town' => 'Bern', 'canton' => 'BE'),
    '1017' => array('town' => 'Lausanne Veillon', 'canton' => 'VD'),
    '1099' => array('town' => 'Montpreveyres Foto', 'canton' => 'VD'),
    '3030' => array('town' => 'Bern', 'canton' => 'BE'),
    '1031' => array('town' => 'Mex VD', 'canton' => 'VD'),
    '1734' => array('town' => 'Tentlingen', 'canton' => 'FR'),
    '1029' => array('town' => 'Villars-Ste-Croix', 'canton' => 'VD'),
    '9101' => array('town' => 'Herisau', 'canton' => 'AR'),
    '3044' => array('town' => 'Innerberg', 'canton' => 'BE'),
    '8317' => array('town' => 'Tagelswangen', 'canton' => 'ZH'),
    '6908' => array('town' => 'Massagno Caselle', 'canton' => 'TI'),
    '6009' => array('town' => 'Luzern', 'canton' => 'LU'),
    '6910' => array('town' => 'Lugano', 'canton' => 'TI'),
    '5232' => array('town' => 'Villigen PSI', 'canton' => 'AG'),
    '6349' => array('town' => 'Baar', 'canton' => 'ZG'),
    '2715' => array('town' => 'Monible', 'canton' => 'BE'),
    '1653' => array('town' => 'Châtel-Montsalvens', 'canton' => 'FR'),
    '1730' => array('town' => 'Ecuvillens', 'canton' => 'FR'),
    '1428' => array('town' => 'Mutrux', 'canton' => 'VD'),
    '1047' => array('town' => 'Oppens', 'canton' => 'VD'),
    '2027' => array('town' => 'Montalchez', 'canton' => 'NE'),
    '2933' => array('town' => 'Damphreux', 'canton' => 'JU'),
    '8543' => array('town' => 'Bertschikon', 'canton' => 'ZH'),
    '3429' => array('town' => 'Hellsau', 'canton' => 'BE'),
    '3632' => array('town' => 'Niederstocken', 'canton' => 'BE'),
    '8774' => array('town' => 'Leuggelbach', 'canton' => 'GL'),
    '4584' => array('town' => 'Gächliwil', 'canton' => 'SO'),
    '5058' => array('town' => 'Wiliberg', 'canton' => 'AG'),
    '3940' => array('town' => 'Steg VS', 'canton' => 'VS'),
    '9498' => array('town' => 'Planken', 'canton' => 'FL'),
    '8801' => array('town' => 'Thalwil', 'canton' => 'ZH'),
    '6341' => array('town' => 'Baar', 'canton' => 'ZG'),
    '6342' => array('town' => 'Baar', 'canton' => 'ZG'),
    '9029' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '1709' => array('town' => 'Fribourg', 'canton' => 'FR'),
    '8879' => array('town' => 'Pizolpark (Mels)', 'canton' => 'SG'),
    '8118' => array('town' => 'Pfaffhausen', 'canton' => 'ZH'),
    '5601' => array('town' => 'Lenzburg Sonderdst', 'canton' => 'AG'),
    '9028' => array('town' => 'St. Gallen CV AG', 'canton' => 'SG'),
    '9027' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '1811' => array('town' => 'Vevey', 'canton' => 'VD'),
    '3609' => array('town' => 'Thun', 'canton' => 'BE'),
    '1775' => array('town' => 'Mannens', 'canton' => 'FR'),
    '8106' => array('town' => 'Adlikon b.Regensdf', 'canton' => 'ZH'),
    '8070' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8071' => array('town' => 'Zürich CS PZ', 'canton' => 'ZH'),
    '1631' => array('town' => 'Bulle', 'canton' => 'FR'),
    '3040' => array('town' => 'Bern', 'canton' => 'BE'),
    '4040' => array('town' => 'Basel', 'canton' => 'BL'),
    '6007' => array('town' => 'Luzern', 'canton' => 'LU'),
    '8759' => array('town' => 'Netstal', 'canton' => 'GL'),
    '9020' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '4573' => array('town' => 'Lohn-Ammannsegg', 'canton' => 'SO'),
    '9026' => array('town' => 'St. Gallen K AG', 'canton' => 'SG'),
    '6031' => array('town' => 'Ebikon', 'canton' => 'LU'),
    '6021' => array('town' => 'Emmenbrücke 1', 'canton' => 'LU'),
    '6391' => array('town' => 'Engelberg', 'canton' => 'OW'),
    '6281' => array('town' => 'Hochdorf', 'canton' => 'LU'),
    '6011' => array('town' => 'Kriens', 'canton' => 'LU'),
    '6061' => array('town' => 'Sarnen 1', 'canton' => 'OW'),
    '6371' => array('town' => 'Stans', 'canton' => 'NW'),
    '6431' => array('town' => 'Schwyz', 'canton' => 'SZ'),
    '9025' => array('town' => 'St. Gallen Quelle', 'canton' => 'SG'),
    '6907' => array('town' => 'Lugano 7 Caselle', 'canton' => 'TI'),
    '1240' => array('town' => 'Genève', 'canton' => 'GE'),
    '9471' => array('town' => 'Buchs SG 1', 'canton' => 'SG'),
    '9401' => array('town' => 'Rorschach', 'canton' => 'SG'),
    '9501' => array('town' => 'Wil SG 1', 'canton' => 'SG'),
    '4509' => array('town' => 'Solothurn', 'canton' => 'SO'),
    '4070' => array('town' => 'Basel', 'canton' => 'BS'),
    '8609' => array('town' => 'Schwerzenbach', 'canton' => 'ZH'),
    '6602' => array('town' => 'Muralto', 'canton' => 'TI'),
    '6161' => array('town' => 'Entlebuch', 'canton' => 'LU'),
    '9201' => array('town' => 'Gossau SG', 'canton' => 'SG'),
    '8510' => array('town' => 'Frauenfeld', 'canton' => 'TG'),
    '3050' => array('town' => 'Bern', 'canton' => 'BE'),
    '8086' => array('town' => 'Zürich R Digest', 'canton' => 'ZH'),
    '8085' => array('town' => 'Zürich Versich.', 'canton' => 'ZH'),
    '2075' => array('town' => 'Thielle', 'canton' => 'NE'),
    '1068' => array('town' => 'Les Monts-de-Pully', 'canton' => 'VD'),
    '2010' => array('town' => 'Neuchâtel OFS', 'canton' => 'NE'),
    '8285' => array('town' => 'Kreuzlingen Ifolor', 'canton' => 'TG'),
    '4039' => array('town' => 'Basel', 'canton' => 'BS'),
    '2510' => array('town' => 'Biel/Bienne DistBa', 'canton' => 'BE'),
    '5510' => array('town' => 'Hunzenschwil DistB', 'canton' => 'AG'),
    '8210' => array('town' => 'Schaffhausen DistB', 'canton' => 'SH'),
    '9510' => array('town' => 'Wil SG Dist Ba', 'canton' => 'SG'),
    '5018' => array('town' => 'Erlinsbach', 'canton' => 'AG'),
    '1310' => array('town' => 'Daillens Dist Ba', 'canton' => 'VD'),
    '8098' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '8066' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '4620' => array('town' => 'Härkingen PZ', 'canton' => 'SO'),
    '8183' => array('town' => 'Bülach Dist Ba', 'canton' => 'ZH'),
    '8325' => array('town' => 'Effretikon Dist Ba', 'canton' => 'ZH'),
    '8520' => array('town' => 'Frauenfeld PZ', 'canton' => 'TG'),
    '8343' => array('town' => 'Hinwil Dist Ba', 'canton' => 'ZH'),
    '8087' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '4078' => array('town' => 'Basel Reader\'s D.', 'canton' => 'BS'),
    '9024' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '4609' => array('town' => 'Olten', 'canton' => 'SO'),
    '8015' => array('town' => 'Zürich 15', 'canton' => 'ZH'),
    '1818' => array('town' => 'Montreux Redoute', 'canton' => 'VD'),
    '8540' => array('town' => 'Frauenfeld ST PP 1', 'canton' => 'TG'),
    '8530' => array('town' => 'Frauenfeld CALL', 'canton' => 'TG'),
    '4640' => array('town' => 'Härkingen ST PP 1', 'canton' => 'SO'),
    '4630' => array('town' => 'Härkingen CALL', 'canton' => 'SO'),
    '1330' => array('town' => 'Daillens CALL', 'canton' => 'VD'),
    '1320' => array('town' => 'Daillens ST PP 1', 'canton' => 'VD'),
    '1440' => array('town' => 'Montagny-Chamard', 'canton' => 'VD'),
    '4065' => array('town' => 'Basel SBB Cargo AG', 'canton' => 'BS'),
    '8075' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '4080' => array('town' => 'Basel', 'canton' => 'BS'),
    '6039' => array('town' => 'Root Längenbold', 'canton' => 'LU'),
    '4034' => array('town' => 'Basel 34 Breite', 'canton' => 'BS'),
    '4035' => array('town' => 'Basel', 'canton' => 'BS'),
    '4089' => array('town' => 'Basel', 'canton' => 'BS'),
    '8068' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '3071' => array('town' => 'Ostermundigen Zust', 'canton' => 'BE'),
    '4033' => array('town' => 'Basel', 'canton' => 'BS'),
    '4081' => array('town' => 'Basel', 'canton' => 'BS'),
    '4082' => array('town' => 'Basel', 'canton' => 'BS'),
    '8186' => array('town' => 'Bülach', 'canton' => 'ZH'),
    '3039' => array('town' => 'Bern PF OC', 'canton' => 'BE'),
    '4042' => array('town' => 'Basel PF OC', 'canton' => 'BL'),
    '4083' => array('town' => 'Basel', 'canton' => 'BS'),
    '4084' => array('town' => 'Basel', 'canton' => 'BS'),
    '4085' => array('town' => 'Basel', 'canton' => 'BS'),
    '4086' => array('town' => 'Basel', 'canton' => 'BS'),
    '4087' => array('town' => 'Basel', 'canton' => 'BS'),
    '4088' => array('town' => 'Basel', 'canton' => 'BS'),
    '8081' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '4092' => array('town' => 'Basel SPI AS 22', 'canton' => 'BS'),
    '4093' => array('town' => 'Basel SPI AS 23', 'canton' => 'BS'),
    '4094' => array('town' => 'Basel SPI AS 24', 'canton' => 'BS'),
    '4095' => array('town' => 'Basel SPI AS 25', 'canton' => 'BS'),
    '4096' => array('town' => 'Basel SPI AS 26', 'canton' => 'BS'),
    '8901' => array('town' => 'Urdorf', 'canton' => 'ZH'),
    '3041' => array('town' => 'Bern', 'canton' => 'BE'),
    '6008' => array('town' => 'Luzern', 'canton' => 'LU'),
    '4041' => array('town' => 'Basel', 'canton' => 'BS'),
    '9489' => array('town' => 'Vaduz', 'canton' => 'FL'),
    '4551' => array('town' => 'Derendingen', 'canton' => 'SO'),
    '4075' => array('town' => 'Basel', 'canton' => 'BS'),
    '9022' => array('town' => 'St. Gallen', 'canton' => 'SG'),
    '8109' => array('town' => 'Kloster Fahr', 'canton' => 'AG'),
    '1019' => array('town' => 'Lausanne', 'canton' => 'VD'),
    '1039' => array('town' => 'Cheseaux Polyval', 'canton' => 'VD'),
    '6346' => array('town' => 'Baar 3', 'canton' => 'ZG'),
    '3085' => array('town' => 'Wabern Weihnachten', 'canton' => 'BE'),
    '1300' => array('town' => 'Eclépens CC', 'canton' => 'VD'),
    '3070' => array('town' => 'Ostermundigen LZB', 'canton' => 'BE'),
    '4621' => array('town' => 'Härkingen BZ', 'canton' => 'SO'),
    '6590' => array('town' => 'Cadenazzo (CLL)', 'canton' => 'TI'),
    '1919' => array('town' => 'Martigny Mutuel', 'canton' => 'VS'),
    '8096' => array('town' => 'Zürich IBRS local', 'canton' => 'ZH'),
    '4808' => array('town' => 'Zofingen PF', 'canton' => 'AG'),
    '4807' => array('town' => 'Zofingen PF', 'canton' => 'AG'),
    '1311' => array('town' => 'Eclépens SC', 'canton' => 'VD'),
    '4611' => array('town' => 'Härkingen SC', 'canton' => 'SO'),
    '8011' => array('town' => 'Zürich Mülligen SC', 'canton' => 'ZH'),
    '8060' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '6333' => array('town' => 'Hünenberg See', 'canton' => 'ZG'),
    '4809' => array('town' => 'Zofingen PF', 'canton' => 'AG'),
    '8059' => array('town' => 'Zürich 59 EO', 'canton' => 'ZH'),
    '3017' => array('town' => 'Bern Zustellung', 'canton' => 'BE'),
    '9301' => array('town' => 'Wittenbach', 'canton' => 'SG'),
    '6511' => array('town' => 'Cadenazzo SC', 'canton' => 'TI'),
    '8074' => array('town' => 'Zürich Voice Pub', 'canton' => 'ZH'),
    '3029' => array('town' => 'Bern Entris', 'canton' => 'BE'),
    '7110' => array('town' => 'Peiden', 'canton' => 'GR'),
    '8012' => array('town' => 'Zürich', 'canton' => 'ZH'),
    '2360' => array('town' => 'Le Bémont', 'canton' => 'JU'),
    '2362' => array('town' => 'Montfaucon', 'canton' => 'JU'),
    '2363' => array('town' => 'Les Enfers', 'canton' => 'JU'),
    '2364' => array('town' => 'St-Brais', 'canton' => 'JU'),
    '8970' => array('town' => 'Urdorf Exchange', 'canton' => 'ZH'),
  );

  // Check if theres something for autocomplete
  if (!empty($element['#value']) && (isset($data[$element['#value']]))) {
    // Get the base #parents for this address form.
    $base_parents = array_slice($element['#parents'], 0, -1);
    $base_array_parents = array_slice($element['#array_parents'], 0, -2);

    $city = $data[$element['#value']];

    // Set the new values in the form.
    drupal_array_set_nested_value($form_state['values'], array_merge($base_parents, array('locality')), $city['town'], TRUE);
    drupal_array_set_nested_value($form_state['values'], array_merge($base_parents, array('administrative_area')), $city['canton'], TRUE);

    // Discard value the user has already entered there.
    drupal_array_set_nested_value($form_state['input'], array_merge($base_parents, array('locality')), NULL, TRUE);
    drupal_array_set_nested_value($form_state['input'], array_merge($base_parents, array('administrative_area')), NULL, TRUE);
  }
}