(function ($, Drupal) {
  Drupal.behaviors.selectToggle = {
    attach: function (context, settings) {

      once('selectToggle', '.babel-brush-search-form', context).forEach(() => {
        let selectAllButton = document.querySelector('.select-all-button')
        let deselectAllButton = document.querySelector('.deselect-all-button')
        let deleteButton = document.querySelector('#delete-button')

        selectAllButton.addEventListener('click', (event) => {
          event.preventDefault()
          $('input[type="checkbox"]', context).prop('checked', true)
          deleteButton.style.display = 'block'
        })

        deselectAllButton.addEventListener('click', (event) => {
          event.preventDefault()
          $('input[type="checkbox"]', context).prop('checked', false)
          deleteButton.style.display = 'none'
        })
      })

    }
  };
})(jQuery, Drupal);
