# Back-2-Top Module

A Drupal module that adds a configurable back-to-top button using vanilla JavaScript.

## Features

- **Configurable Position**: Choose from bottom-left, bottom-center, or bottom-right
- **Customizable Appearance**: Set color, opacity, and size
- **Multiple Image Options**: Arrow, chevron, triangle, or custom image upload
- **Smart Visibility**: Only appears when page content exceeds viewport height
- **Admin Control**: Choose whether to show on admin pages
- **Smooth Scrolling**: Uses requestAnimationFrame for smooth animation
- **Responsive Design**: Adapts to mobile devices
- **Accessibility**: Includes proper ARIA labels and keyboard support

## Requirements

- Drupal 10.x or 11.x
- PHP 8.1+

## Installation

1. Download and extract the module to your `modules/contrib` or `modules/custom` directory
2. Enable the module via the admin interface or using Drush:
   ```bash
   drush en back_2_top
   ```

## Configuration

After enabling the module, configure it by navigating to:

**Administration > Configuration > User Interface > Back-2-Top Settings**

Or visit directly: `/admin/config/user-interface/back-to-top`

You can also access configuration through: **Administration > Help > Back-2-Top** which provides detailed setup instructions.

### General Settings
- **Enable/Disable**: Toggle the back-to-top button
- **Position**: Choose button placement (bottom-left, bottom-center, bottom-right)

### Appearance Settings
- **Color**: Set the button background color using a color picker
- **Opacity**: Adjust button transparency (0.1 to 1.0)
- **Size**: Set button dimensions in pixels (20-100px)
- **Image Type**: Choose from built-in icons or upload custom image
  - Arrow (default)
  - Chevron
  - Triangle
  - Custom image upload

### Visibility Settings
- **Show on Admin Pages**: Control whether the button appears on administrative pages

## Technical Details

### File Structure
```
back_2_top/
├── back_2_top.info.yml
├── back_2_top.module
├── back_2_top.install
├── back_2_top.routing.yml
├── back_2_top.libraries.yml
├── config/schema/back_2_top.schema.yml
├── src/Form/Back2TopSettingsForm.php
├── css/back_2_top.css
├── js/back_2_top.js
└── README.md
```

### JavaScript Implementation
- Uses vanilla JavaScript (no jQuery dependency)
- Implements requestAnimationFrame for smooth scrolling
- Uses passive event listeners for optimal performance
- Includes throttling for scroll events
- Responsive to window resize events

### CSS Features
- CSS transitions for smooth show/hide animations
- Hover effects with scale transformations
- Responsive design with mobile breakpoints
- Box shadows for visual depth
- Flexible positioning system

## Browser Support

- Chrome 60+
- Firefox 55+
- Safari 12+
- Edge 79+
- Mobile browsers with modern JavaScript support

## Customization

### Custom Styling
You can override the default styles by adding CSS to your theme:

```css
.back-to-top {
  /* Your custom styles */
}
```

### Custom JavaScript
The module uses Drupal behaviors, so you can extend functionality:

```javascript
Drupal.behaviors.myCustomBack2Top = {
  attach: function (context, settings) {
    // Your custom code
  }
};
```

## Performance Considerations

- Minimal JavaScript footprint (~3KB minified)
- CSS-only animations where possible
- Event listener throttling
- Conditional loading based on page content height

## Accessibility

- ARIA labels for screen readers
- Keyboard navigation support
- High contrast support
- Focus indicators
- Semantic HTML structure

## Troubleshooting

### Button Not Appearing
1. Check if the module is enabled
2. Verify page content height exceeds viewport
3. Check admin page visibility settings
4. Clear Drupal cache

### Custom Image Not Loading
1. Verify image upload was successful
2. Check file permissions
3. Ensure image format is supported (PNG, JPG, GIF, SVG)
4. Check file size limit (2MB max)

## Development

### Running Tests
```bash
# PHPUnit tests
vendor/bin/phpunit modules/custom/back_2_top/tests/

# JavaScript tests
npm test
```

### Code Standards
This module follows Drupal coding standards:
- PHP_CodeSniffer with Drupal standards
- ESLint for JavaScript
- Stylelint for CSS

## License

GPL-2.0-or-later

## Credits

Developed for Drupal 10 and 11 compatibility with modern web standards and accessibility best practices.

## Support

For issues and feature requests, please use the project's issue queue or contact the maintainer.